/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.DuplicateModelException;
import org.gradle.model.internal.core.EmptyReferenceProjection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.registry.ModelRegistryInternal;
import org.gradle.model.internal.type.ModelType;

class ModelElementNode
extends ModelNodeInternal {
    private Map<String, ModelNodeInternal> links;
    private final MutableModelNode parent;
    private Object privateData;
    private ModelType<?> privateDataType;

    public ModelElementNode(ModelRegistryInternal modelRegistry, ModelRegistration registration, MutableModelNode parent) {
        super(modelRegistry, registration);
        this.parent = parent;
    }

    @Override
    public MutableModelNode getParent() {
        return this.parent;
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, @Nullable ModelRuleDescriptor ruleDescriptor) {
        ModelView<T> modelView = this.getAdapter().asImmutable(type, this, ruleDescriptor);
        if (modelView == null) {
            throw new IllegalStateException("Model element " + this.getPath() + " cannot be expressed as a read-only view of type " + type);
        }
        return modelView;
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, ModelRuleDescriptor ruleDescriptor) {
        ModelView<T> modelView = this.isMutable() ? this.getAdapter().asMutable(type, this, ruleDescriptor) : this.getAdapter().asImmutable(type, this, ruleDescriptor);
        if (modelView == null) {
            throw new IllegalStateException("Model element " + this.getPath() + " cannot be expressed as a mutable view of type " + type);
        }
        return modelView;
    }

    @Override
    public <T> T getPrivateData(Class<T> type) {
        return this.getPrivateData(ModelType.of(type));
    }

    @Override
    public <T> T getPrivateData(ModelType<T> type) {
        if (this.privateData == null) {
            return null;
        }
        if (!type.isAssignableFrom(this.privateDataType)) {
            throw new ClassCastException("Cannot get private data '" + this.privateData + "' of type '" + this.privateDataType + "' as type '" + type);
        }
        return (T)Cast.uncheckedCast((Object)this.privateData);
    }

    @Override
    public Object getPrivateData() {
        return this.privateData;
    }

    @Override
    public <T> void setPrivateData(Class<? super T> type, T object) {
        this.setPrivateData(ModelType.of(type), object);
    }

    @Override
    public <T> void setPrivateData(ModelType<? super T> type, T object) {
        if (!this.isMutable()) {
            throw new IllegalStateException(String.format("Cannot set value for model element '%s' as this element is not mutable.", this.getPath()));
        }
        this.privateDataType = type;
        this.privateData = object;
    }

    @Override
    public boolean hasLink(String name) {
        return this.links != null && this.links.containsKey(name);
    }

    @Override
    @Nullable
    public ModelNodeInternal getLink(String name) {
        return this.links == null ? null : this.links.get(name);
    }

    @Override
    public Iterable<? extends ModelNodeInternal> getLinks() {
        return this.links == null ? Collections.emptyList() : this.links.values();
    }

    @Override
    public int getLinkCount(Predicate<? super MutableModelNode> predicate) {
        return this.links == null ? 0 : Iterables.size((Iterable)Iterables.filter(this.links.values(), predicate));
    }

    @Override
    public Set<String> getLinkNames(Predicate<? super MutableModelNode> predicate) {
        if (this.links == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (Map.Entry<String, ModelNodeInternal> entry : this.links.entrySet()) {
            ModelNodeInternal link = entry.getValue();
            if (!predicate.apply((Object)link)) continue;
            names.add((Object)entry.getKey());
        }
        return names.build();
    }

    @Override
    public Set<String> getLinkNames() {
        return this.links == null ? Collections.emptySet() : this.links.keySet();
    }

    @Override
    public Iterable<? extends MutableModelNode> getLinks(Predicate<? super MutableModelNode> predicate) {
        return this.links == null ? Collections.emptyList() : Iterables.filter(this.links.values(), predicate);
    }

    @Override
    public int getLinkCount() {
        return this.links == null ? 0 : this.links.size();
    }

    @Override
    public boolean hasLink(String name, Predicate<? super MutableModelNode> predicate) {
        ModelNodeInternal linked = this.getLink(name);
        return linked != null && predicate.apply((Object)linked);
    }

    @Override
    public void applyToLink(ModelActionRole type, ModelAction action) {
        if (!this.getPath().isDirectChild(action.getSubject().getPath())) {
            throw new IllegalArgumentException(String.format("Linked element action reference has a path (%s) which is not a child of this node (%s).", action.getSubject().getPath(), this.getPath()));
        }
        this.modelRegistry.bind(action.getSubject(), type, action);
    }

    @Override
    public void applyTo(NodePredicate predicate, ModelActionRole role, ModelAction action) {
        this.modelRegistry.configureMatching(predicate.scope(this.getPath()), role, action);
    }

    @Override
    public void applyTo(NodePredicate predicate, Class<? extends RuleSource> rules) {
        this.modelRegistry.configureMatching(predicate.scope(this.getPath()), rules);
    }

    @Override
    public <T> void addReference(String name, ModelType<T> type, ModelNode target, ModelRuleDescriptor descriptor) {
        EmptyReferenceProjection<T> projection = new EmptyReferenceProjection<T>(type);
        ModelRegistration registration = ModelRegistrations.of(this.getPath().child(name)).withProjection(projection).descriptor(descriptor).build();
        ModelReferenceNode referenceNode = new ModelReferenceNode(this.modelRegistry, registration, this);
        if (target != null) {
            referenceNode.setTarget(target);
        }
        this.addNode(referenceNode, registration);
    }

    @Override
    public void addLink(ModelRegistration registration) {
        this.addNode(new ModelElementNode(this.modelRegistry, registration, this), registration);
    }

    private void addNode(ModelNodeInternal child, ModelRegistration registration) {
        ModelNodeInternal currentChild;
        ModelPath childPath = child.getPath();
        if (!this.getPath().isDirectChild(childPath)) {
            throw new IllegalArgumentException(String.format("Element registration has a path (%s) which is not a child of this node (%s).", childPath, this.getPath()));
        }
        ModelNodeInternal modelNodeInternal = currentChild = this.links == null ? null : this.links.get(childPath.getName());
        if (currentChild != null) {
            if (!currentChild.isAtLeast(ModelNode.State.Created)) {
                throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' is already registered to create this model element.", childPath, ModelElementNode.describe(registration.getDescriptor()), ModelElementNode.describe(currentChild.getDescriptor())));
            }
            throw new DuplicateModelException(String.format("Cannot create '%s' using creation rule '%s' as the rule '%s' has already been used to create this model element.", childPath, ModelElementNode.describe(registration.getDescriptor()), ModelElementNode.describe(currentChild.getDescriptor())));
        }
        if (!this.isMutable()) {
            throw new IllegalStateException(String.format("Cannot create '%s' using creation rule '%s' as model element '%s' is no longer mutable.", childPath, ModelElementNode.describe(registration.getDescriptor()), this.getPath()));
        }
        if (this.links == null) {
            this.links = new TreeMap<String, ModelNodeInternal>();
        }
        this.links.put(child.getPath().getName(), child);
        this.modelRegistry.registerNode(child, registration.getActions());
    }

    @Override
    public void removeLink(String name) {
        if (this.links != null && this.links.remove(name) != null) {
            this.modelRegistry.remove(this.getPath().child(name));
        }
    }

    @Override
    public void setTarget(ModelNode target) {
        throw new UnsupportedOperationException(String.format("This node (%s) is not a reference to another node.", this.getPath()));
    }

    @Override
    public void ensureUsable() {
        this.ensureAtLeast(ModelNode.State.Initialized);
    }

    @Override
    public void ensureAtLeast(ModelNode.State state) {
        this.modelRegistry.transition(this, state, true);
    }

    private static String describe(ModelRuleDescriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        descriptor.describeTo(stringBuilder);
        return stringBuilder.toString();
    }
}

