/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email.utils;

import au.com.trgtd.email.utils.Attachment;
import au.com.trgtd.email.utils.Renderable;
import java.io.IOException;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import tr.util.HTML;

public class RenderableMessage
implements Renderable {
    private static final Logger LOG = Logger.getLogger("tr.email");
    private String subject;
    private String bodytext;

    public RenderableMessage(Message m) throws MessagingException, IOException {
        this.subject = m.getSubject();
        this.extractPart((Part)m);
    }

    private boolean extractPart(Part part) throws MessagingException, IOException {
        if (part.getContent() instanceof Multipart) {
            return this.handleMultipart((Multipart)part.getContent());
        }
        LOG.info("Part content type: " + part.getContentType());
        if (part.getContentType().startsWith("text/plain")) {
            LOG.info("TEXT:" + (String)part.getContent());
            this.bodytext = this.bodytext == null ? (String)part.getContent() : this.bodytext + "\n" + (String)part.getContent();
            return true;
        }
        if (part.getContentType().startsWith("text/html")) {
            LOG.info("HTML:" + (String)part.getContent());
            this.bodytext = this.bodytext == null ? HTML.html2text((String)((String)part.getContent())) : this.bodytext + HTML.html2text((String)("<p>" + (String)part.getContent() + "</p>"));
            return true;
        }
        return false;
    }

    private boolean handleMultipart(Multipart mp) throws MessagingException, IOException {
        LOG.info("Multipart content type: " + mp.getContentType());
        if (mp.getContentType().startsWith("multipart/alternative")) {
            return this.handleMultipartAlternative(mp);
        }
        if (mp.getContentType().startsWith("multipart/mixed")) {
            return this.handleMultipartMixed(mp);
        }
        if (mp.getContentType().startsWith("multipart/related")) {
            return this.handleMultipartRelated(mp);
        }
        if (mp.getContentType().startsWith("multipart/digest")) {
            return this.handleMultipartDigest(mp);
        }
        if (mp.getContentType().startsWith("multipart/signed")) {
            return this.handleMultipartSigned(mp);
        }
        LOG.info("Multipart content could not be handled.");
        return false;
    }

    private boolean handleMultipartAlternative(Multipart mp) throws MessagingException, IOException {
        BodyPart p;
        int i;
        for (i = 0; i < mp.getCount(); ++i) {
            p = mp.getBodyPart(i);
            if (!p.getContentType().startsWith("text/plain")) continue;
            this.extractPart((Part)p);
            return true;
        }
        for (i = 0; i < mp.getCount(); ++i) {
            p = mp.getBodyPart(i);
            if (!p.getContentType().startsWith("text/html")) continue;
            this.extractPart((Part)p);
            return true;
        }
        for (i = 0; i < mp.getCount(); ++i) {
            p = mp.getBodyPart(i);
            if (!(p.getContent() instanceof Multipart) || !this.handleMultipart((Multipart)p.getContent())) continue;
            return true;
        }
        return false;
    }

    private boolean handleMultipartMixed(Multipart mp) throws MessagingException, IOException {
        boolean handled = false;
        for (int i = 0; i < mp.getCount(); ++i) {
            if (!this.extractPart((Part)mp.getBodyPart(i))) continue;
            handled = true;
        }
        return handled;
    }

    private boolean handleMultipartDigest(Multipart mp) throws MessagingException, IOException {
        boolean handled = false;
        for (int i = 0; i < mp.getCount(); ++i) {
            if (!this.extractPart((Part)mp.getBodyPart(i))) continue;
            handled = true;
        }
        return handled;
    }

    private boolean handleMultipartSigned(Multipart mp) throws MessagingException, IOException {
        boolean handled = false;
        for (int i = 0; i < mp.getCount(); ++i) {
            if (!this.extractPart((Part)mp.getBodyPart(i))) continue;
            handled = true;
        }
        return handled;
    }

    private boolean handleMultipartRelated(Multipart mp) throws MessagingException, IOException {
        boolean handled = false;
        for (int i = 0; i < mp.getCount(); ++i) {
            if (!this.extractPart((Part)mp.getBodyPart(i))) continue;
            handled = true;
        }
        return handled;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBodytext() {
        return this.bodytext;
    }

    public int getAttachmentCount() {
        return 0;
    }

    public Attachment getAttachment(int i) {
        return null;
    }
}

