/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.jid.Jid;

public class IBBTransferNegotiator
extends StreamNegotiator {
    private final InBandBytestreamManager manager;

    protected IBBTransferNegotiator(XMPPConnection connection) {
        super(connection);
        this.manager = InBandBytestreamManager.getByteStreamManager(connection);
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, Jid initiator, Jid target) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        InBandBytestreamSession session = this.manager.establishSession(target, streamID);
        session.setCloseBothStreamsEnabled(true);
        return session.getOutputStream();
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.manager.ignoreBytestreamRequestOnce(initiation.getSessionID());
        IQ streamInitiation = this.initiateIncomingStream(this.connection(), initiation);
        return this.negotiateIncomingStream(streamInitiation);
    }

    @Override
    public void newStreamInitiation(Jid from, String streamID) {
        this.manager.ignoreBytestreamRequestOnce(streamID);
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/ibb";
    }

    @Override
    InputStream negotiateIncomingStream(Stanza streamInitiation) throws SmackException.NotConnectedException, InterruptedException {
        ByteStreamRequest request = new ByteStreamRequest(this.manager, (Open)streamInitiation);
        InBandBytestreamSession session = request.accept();
        session.setCloseBothStreamsEnabled(true);
        return session.getInputStream();
    }

    private static final class ByteStreamRequest
    extends InBandBytestreamRequest {
        private ByteStreamRequest(InBandBytestreamManager manager, Open byteStreamRequest) {
            super(manager, byteStreamRequest);
        }
    }
}

