/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.thumbnail;

import java.text.ParseException;
import java.util.Date;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.thumbnail.Thumbnail;
import org.jitsi.xmpp.extensions.thumbnail.ThumbnailFile;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jxmpp.util.XmppDateTime;

public class ThumbnailStreamInitiationProvider
extends SafeParseIqProvider<StreamInitiation> {
    private static final Logger logger = new LoggerImpl(ThumbnailStreamInitiationProvider.class.getName());

    @Override
    protected StreamInitiation doParse(XmlPullParser parser2) throws Exception {
        boolean done = false;
        String id = parser2.getAttributeValue("", "id");
        String mimeType = parser2.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size = null;
        String hash = null;
        String date = null;
        String desc = null;
        Thumbnail thumbnail = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String elementName = parser2.getName();
            String namespace = parser2.getNamespace();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("file")) {
                    name = parser2.getAttributeValue("", "name");
                    size = parser2.getAttributeValue("", "size");
                    hash = parser2.getAttributeValue("", "hash");
                    date = parser2.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser2.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (elementName.equals("x") && namespace.equals("jabber:x:data")) {
                    form = (DataForm)dataFormProvider.parse(parser2);
                    continue;
                }
                if (!elementName.equals("thumbnail")) continue;
                thumbnail = new Thumbnail(parser2);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT) continue;
            if (elementName.equals("si")) {
                done = true;
                continue;
            }
            if (!elementName.equals("file") || name == null) continue;
            long fileSize = 0L;
            if (size != null && size.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size);
                }
                catch (NumberFormatException e) {
                    logger.warn("Received an invalid file size, continuing with fileSize set to 0", e);
                }
            }
            ThumbnailFile file = new ThumbnailFile(name, fileSize);
            file.setHash(hash);
            if (date != null) {
                try {
                    file.setDate(XmppDateTime.parseDate(date));
                }
                catch (ParseException ex) {
                    logger.warn("Unknown dateformat on incoming file transfer: " + date);
                }
            } else {
                file.setDate(new Date());
            }
            if (thumbnail != null) {
                file.setThumbnail(thumbnail);
            }
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile(file);
        }
        initiation.setSessionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }
}

