/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.TextifierSupport;
import org.jetbrains.org.objectweb.asm.util.TraceSignatureVisitor;

public class Textifier
extends Printer {
    private static final List<String> FRAME_TYPES = Collections.unmodifiableList(Arrays.asList("T", "I", "F", "D", "J", "N", "U"));
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected Map<Label, String> labelNames;
    private int access;
    private int numAnnotationValues;

    public Textifier() {
        this(589824);
        if (this.getClass() != Textifier.class) {
            throw new IllegalStateException();
        }
    }

    protected Textifier(int api) {
        super(api);
    }

    public void visit(int version2, int access, String name2, String signature2, String superName, String[] interfaces) {
        if ((access & 0x8000) != 0) {
            return;
        }
        this.access = access;
        int majorVersion = version2 & 0xFFFF;
        int minorVersion = version2 >>> 16;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// class version ").append(majorVersion).append('.').append(minorVersion).append(" (").append(version2).append(")\n");
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append("// DEPRECATED\n");
        }
        if ((access & 0x10000) != 0) {
            this.stringBuilder.append("// RECORD\n");
        }
        this.appendRawAccess(access);
        this.appendDescriptor(5, signature2);
        if (signature2 != null) {
            this.appendJavaDeclaration(name2, signature2);
        }
        this.appendAccess(access & 0xFFFF7FDF);
        if ((access & 0x2000) != 0) {
            this.stringBuilder.append("@interface ");
        } else if ((access & 0x200) != 0) {
            this.stringBuilder.append("interface ");
        } else if ((access & 0x4000) == 0) {
            this.stringBuilder.append("class ");
        }
        this.appendDescriptor(0, name2);
        if (superName != null && !"java/lang/Object".equals(superName)) {
            this.stringBuilder.append(" extends ");
            this.appendDescriptor(0, superName);
        }
        if (interfaces != null && interfaces.length > 0) {
            this.stringBuilder.append(" implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                this.appendDescriptor(0, interfaces[i]);
                if (i == interfaces.length - 1) continue;
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append(" {\n\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitSource(String file2, String debug) {
        this.stringBuilder.setLength(0);
        if (file2 != null) {
            this.stringBuilder.append(this.tab).append("// compiled from: ").append(file2).append('\n');
        }
        if (debug != null) {
            this.stringBuilder.append(this.tab).append("// debug info: ").append(debug).append('\n');
        }
        if (this.stringBuilder.length() > 0) {
            this.text.add(this.stringBuilder.toString());
        }
    }

    public Printer visitModule(String name2, int access, String version2) {
        this.stringBuilder.setLength(0);
        if ((access & 0x20) != 0) {
            this.stringBuilder.append("open ");
        }
        this.stringBuilder.append("module ").append(name2).append(" { ").append(version2 == null ? "" : "// " + version2).append("\n\n");
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public void visitNestHost(String nestHost) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTHOST ");
        this.appendDescriptor(0, nestHost);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitOuterClass(String owner, String name2, String descriptor2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, owner);
        this.stringBuilder.append(' ');
        if (name2 != null) {
            this.stringBuilder.append(name2).append(' ');
        }
        this.appendDescriptor(3, descriptor2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitClassAnnotation(String descriptor2, boolean visible) {
        this.text.add("\n");
        return this.visitAnnotation(descriptor2, visible);
    }

    public Printer visitClassTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        this.text.add("\n");
        return this.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
    }

    public void visitClassAttribute(Attribute attribute) {
        this.text.add("\n");
        this.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTMEMBER ");
        this.appendDescriptor(0, nestMember);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("PERMITTEDSUBCLASS ");
        this.appendDescriptor(0, permittedSubclass);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access & 0xFFFFFFDF);
        this.stringBuilder.append(this.tab);
        this.appendAccess(access);
        this.stringBuilder.append("INNERCLASS ");
        this.appendDescriptor(0, name2);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, outerName);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, innerName);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitRecordComponent(String name2, String descriptor2, String signature2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("RECORDCOMPONENT ");
        if (signature2 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, signature2);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name2, signature2);
        }
        this.stringBuilder.append(this.tab);
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append(' ').append(name2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public Textifier visitField(int access, String name2, String descriptor2, String signature2, Object value2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append("// DEPRECATED\n");
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access);
        if (signature2 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, signature2);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name2, signature2);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(access);
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append(' ').append(name2);
        if (value2 != null) {
            this.stringBuilder.append(" = ");
            if (value2 instanceof String) {
                this.stringBuilder.append('\"').append(value2).append('\"');
            } else {
                this.stringBuilder.append(value2);
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public Textifier visitMethod(int access, String name2, String descriptor2, String signature2, String[] exceptions) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append("// DEPRECATED\n");
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access);
        if (signature2 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(4, signature2);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name2, signature2);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(access & 0xFFFFFF3F);
        if ((access & 0x100) != 0) {
            this.stringBuilder.append("native ");
        }
        if ((access & 0x80) != 0) {
            this.stringBuilder.append("varargs ");
        }
        if ((access & 0x40) != 0) {
            this.stringBuilder.append("bridge ");
        }
        if ((this.access & 0x200) != 0 && (access & 0x408) == 0) {
            this.stringBuilder.append("default ");
        }
        this.stringBuilder.append(name2);
        this.appendDescriptor(3, descriptor2);
        if (exceptions != null && exceptions.length > 0) {
            this.stringBuilder.append(" throws ");
            for (String exception : exceptions) {
                this.appendDescriptor(0, exception);
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public void visitClassEnd() {
        this.text.add("}\n");
    }

    public void visitMainClass(String mainClass) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // main class ").append(mainClass).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPackage(String packaze) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // package ").append(packaze).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitRequire(String require, int access, String version2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("requires ");
        if ((access & 0x20) != 0) {
            this.stringBuilder.append("transitive ");
        }
        if ((access & 0x40) != 0) {
            this.stringBuilder.append("static ");
        }
        this.stringBuilder.append(require).append(';');
        this.appendRawAccess(access);
        if (version2 != null) {
            this.stringBuilder.append("  // version ").append(version2).append('\n');
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitExport(String packaze, int access, String ... modules2) {
        this.visitExportOrOpen("exports ", packaze, access, modules2);
    }

    public void visitOpen(String packaze, int access, String ... modules2) {
        this.visitExportOrOpen("opens ", packaze, access, modules2);
    }

    private void visitExportOrOpen(String method, String packaze, int access, String ... modules2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append(method);
        this.stringBuilder.append(packaze);
        if (modules2 != null && modules2.length > 0) {
            this.stringBuilder.append(" to");
        } else {
            this.stringBuilder.append(';');
        }
        this.appendRawAccess(access);
        if (modules2 != null && modules2.length > 0) {
            for (int i = 0; i < modules2.length; ++i) {
                this.stringBuilder.append(this.tab2).append(modules2[i]);
                this.stringBuilder.append(i != modules2.length - 1 ? ",\n" : ";\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitUse(String use2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("uses ");
        this.appendDescriptor(0, use2);
        this.stringBuilder.append(";\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitProvide(String provide, String ... providers) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("provides ");
        this.appendDescriptor(0, provide);
        this.stringBuilder.append(" with\n");
        for (int i = 0; i < providers.length; ++i) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(0, providers[i]);
            this.stringBuilder.append(i != providers.length - 1 ? ",\n" : ";\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitModuleEnd() {
    }

    public void visit(String name2, Object value2) {
        this.visitAnnotationValue(name2);
        if (value2 instanceof String) {
            this.visitString((String)value2);
        } else if (value2 instanceof Type) {
            this.visitType((Type)value2);
        } else if (value2 instanceof Byte) {
            this.visitByte((Byte)value2);
        } else if (value2 instanceof Boolean) {
            this.visitBoolean((Boolean)value2);
        } else if (value2 instanceof Short) {
            this.visitShort((Short)value2);
        } else if (value2 instanceof Character) {
            this.visitChar(((Character)value2).charValue());
        } else if (value2 instanceof Integer) {
            this.visitInt((Integer)value2);
        } else if (value2 instanceof Float) {
            this.visitFloat(((Float)value2).floatValue());
        } else if (value2 instanceof Long) {
            this.visitLong((Long)value2);
        } else if (value2 instanceof Double) {
            this.visitDouble((Double)value2);
        } else if (value2.getClass().isArray()) {
            this.stringBuilder.append('{');
            if (value2 instanceof byte[]) {
                byte[] byteArray = (byte[])value2;
                for (int i = 0; i < byteArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitByte(byteArray[i]);
                }
            } else if (value2 instanceof boolean[]) {
                boolean[] booleanArray = (boolean[])value2;
                for (int i = 0; i < booleanArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitBoolean(booleanArray[i]);
                }
            } else if (value2 instanceof short[]) {
                short[] shortArray = (short[])value2;
                for (int i = 0; i < shortArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitShort(shortArray[i]);
                }
            } else if (value2 instanceof char[]) {
                char[] charArray = (char[])value2;
                for (int i = 0; i < charArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitChar(charArray[i]);
                }
            } else if (value2 instanceof int[]) {
                int[] intArray = (int[])value2;
                for (int i = 0; i < intArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitInt(intArray[i]);
                }
            } else if (value2 instanceof long[]) {
                long[] longArray = (long[])value2;
                for (int i = 0; i < longArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitLong(longArray[i]);
                }
            } else if (value2 instanceof float[]) {
                float[] floatArray = (float[])value2;
                for (int i = 0; i < floatArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitFloat(floatArray[i]);
                }
            } else if (value2 instanceof double[]) {
                double[] doubleArray = (double[])value2;
                for (int i = 0; i < doubleArray.length; ++i) {
                    this.maybeAppendComma(i);
                    this.visitDouble(doubleArray[i]);
                }
            }
            this.stringBuilder.append('}');
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void visitInt(int value2) {
        this.stringBuilder.append(value2);
    }

    private void visitLong(long value2) {
        this.stringBuilder.append(value2).append('L');
    }

    private void visitFloat(float value2) {
        this.stringBuilder.append(value2).append('F');
    }

    private void visitDouble(double value2) {
        this.stringBuilder.append(value2).append('D');
    }

    private void visitChar(char value2) {
        this.stringBuilder.append("(char)").append((int)value2);
    }

    private void visitShort(short value2) {
        this.stringBuilder.append("(short)").append(value2);
    }

    private void visitByte(byte value2) {
        this.stringBuilder.append("(byte)").append(value2);
    }

    private void visitBoolean(boolean value2) {
        this.stringBuilder.append(value2);
    }

    private void visitString(String value2) {
        Textifier.appendString(this.stringBuilder, value2);
    }

    private void visitType(Type value2) {
        this.stringBuilder.append(value2.getClassName()).append(".class");
    }

    public void visitEnum(String name2, String descriptor2, String value2) {
        this.visitAnnotationValue(name2);
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('.').append(value2);
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitAnnotation(String name2, String descriptor2) {
        this.visitAnnotationValue(name2);
        this.stringBuilder.append('@');
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(")");
    }

    public Textifier visitArray(String name2) {
        this.visitAnnotationValue(name2);
        this.stringBuilder.append('{');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier("}");
    }

    public void visitAnnotationEnd() {
    }

    private void visitAnnotationValue(String name2) {
        this.stringBuilder.setLength(0);
        this.maybeAppendComma(this.numAnnotationValues++);
        if (name2 != null) {
            this.stringBuilder.append(name2).append('=');
        }
    }

    public Textifier visitRecordComponentAnnotation(String descriptor2, boolean visible) {
        return this.visitAnnotation(descriptor2, visible);
    }

    public Printer visitRecordComponentTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
    }

    public void visitRecordComponentAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitRecordComponentEnd() {
    }

    public Textifier visitFieldAnnotation(String descriptor2, boolean visible) {
        return this.visitAnnotation(descriptor2, visible);
    }

    public Printer visitFieldTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
    }

    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitFieldEnd() {
    }

    public void visitParameter(String name2, int access) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// parameter ");
        this.appendAccess(access);
        this.stringBuilder.append(' ').append(name2 == null ? "<no name>" : name2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        return this.addNewTextifier("\n");
    }

    public Textifier visitMethodAnnotation(String descriptor2, boolean visible) {
        return this.visitAnnotation(descriptor2, visible);
    }

    public Printer visitMethodTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
    }

    public Textifier visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// annotable parameter count: ");
        this.stringBuilder.append(parameterCount);
        this.stringBuilder.append(visible ? " (visible)\n" : " (invisible)\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    public Textifier visitParameterAnnotation(int parameter2, String descriptor2, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append('@');
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(visible ? ") // parameter " : ") // invisible, parameter ").append(parameter2).append('\n');
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int type2, int numLocal, Object[] local, int numStack, Object[] stack) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.stringBuilder.append("FRAME ");
        switch (type2) {
            case -1: 
            case 0: {
                this.stringBuilder.append("FULL [");
                this.appendFrameTypes(numLocal, local);
                this.stringBuilder.append("] [");
                this.appendFrameTypes(numStack, stack);
                this.stringBuilder.append(']');
                break;
            }
            case 1: {
                this.stringBuilder.append("APPEND [");
                this.appendFrameTypes(numLocal, local);
                this.stringBuilder.append(']');
                break;
            }
            case 2: {
                this.stringBuilder.append("CHOP ").append(numLocal);
                break;
            }
            case 3: {
                this.stringBuilder.append("SAME");
                break;
            }
            case 4: {
                this.stringBuilder.append("SAME1 ");
                this.appendFrameTypes(1, stack);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInsn(int opcode) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIntInsn(int opcode, int operand) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ').append(opcode == 188 ? TYPES[operand] : Integer.toString(operand)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitVarInsn(int opcode, int var) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ').append(var).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTypeInsn(int opcode, String type2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, type2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitFieldInsn(int opcode, String owner, String name2, String descriptor2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.stringBuilder.append('.').append(name2).append(" : ");
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodInsn(int opcode, String owner, String name2, String descriptor2, boolean isInterface) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.stringBuilder.append('.').append(name2).append(' ');
        this.appendDescriptor(3, descriptor2);
        if (isInterface) {
            this.stringBuilder.append(" (itf)");
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInvokeDynamicInsn(String name2, String descriptor2, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("INVOKEDYNAMIC").append(' ');
        this.stringBuilder.append(name2);
        this.appendDescriptor(3, descriptor2);
        this.stringBuilder.append(" [");
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendHandle(bootstrapMethodHandle);
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3).append("// arguments:");
        if (bootstrapMethodArguments.length == 0) {
            this.stringBuilder.append(" none");
        } else {
            this.stringBuilder.append('\n');
            for (Object value2 : bootstrapMethodArguments) {
                this.stringBuilder.append(this.tab3);
                if (value2 instanceof String) {
                    Printer.appendString(this.stringBuilder, (String)value2);
                } else if (value2 instanceof Type) {
                    Type type2 = (Type)value2;
                    if (type2.getSort() == 11) {
                        this.appendDescriptor(3, type2.getDescriptor());
                    } else {
                        this.visitType(type2);
                    }
                } else if (value2 instanceof Handle) {
                    this.appendHandle((Handle)value2);
                } else {
                    this.stringBuilder.append(value2);
                }
                this.stringBuilder.append(", \n");
            }
            this.stringBuilder.setLength(this.stringBuilder.length() - 3);
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab2).append("]\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ');
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLdcInsn(Object value2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LDC ");
        if (value2 instanceof String) {
            Printer.appendString(this.stringBuilder, (String)value2);
        } else if (value2 instanceof Type) {
            this.stringBuilder.append(((Type)value2).getDescriptor()).append(".class");
        } else {
            this.stringBuilder.append(value2);
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIincInsn(int var, int increment) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("IINC ").append(var).append(' ').append(increment).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labels2.length; ++i) {
            this.stringBuilder.append(this.tab3).append(min + i).append(": ");
            this.appendLabel(labels2[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labels2.length; ++i) {
            this.stringBuilder.append(this.tab3).append(keys[i]).append(": ");
            this.appendLabel(labels2[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMultiANewArrayInsn(String descriptor2, int numDimensions) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append(' ').append(numDimensions).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        return this.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler2, String type2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(start);
        this.stringBuilder.append(' ');
        this.appendLabel(end);
        this.stringBuilder.append(' ');
        this.appendLabel(handler2);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, type2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK @");
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(typeRef);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitLocalVariable(String name2, String descriptor2, String signature2, Label start, Label end, int index2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE ").append(name2).append(' ');
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append(' ');
        this.appendLabel(start);
        this.stringBuilder.append(' ');
        this.appendLabel(end);
        this.stringBuilder.append(' ').append(index2).append('\n');
        if (signature2 != null) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(2, signature2);
            this.stringBuilder.append(this.tab2);
            this.appendJavaDeclaration(name2, signature2);
        }
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index2, String descriptor2, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE @");
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(typeRef);
        this.stringBuilder.append(", ").append(typePath);
        for (int i = 0; i < start.length; ++i) {
            this.stringBuilder.append(" [ ");
            this.appendLabel(start[i]);
            this.stringBuilder.append(" - ");
            this.appendLabel(end[i]);
            this.stringBuilder.append(" - ").append(index2[i]).append(" ]");
        }
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitLineNumber(int line, Label start) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LINENUMBER ").append(line).append(' ');
        this.appendLabel(start);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXSTACK = ").append(maxStack).append('\n');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXLOCALS = ").append(maxLocals).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodEnd() {
    }

    public Textifier visitAnnotation(String descriptor2, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(visible ? ")\n" : ") // invisible\n");
    }

    public Textifier visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, descriptor2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(typeRef);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof TextifierSupport) {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            ((TextifierSupport)((Object)attribute)).textify(this.stringBuilder, this.labelNames);
        } else {
            this.stringBuilder.append(" : unknown\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void appendAccess(int accessFlags2) {
        if ((accessFlags2 & 1) != 0) {
            this.stringBuilder.append("public ");
        }
        if ((accessFlags2 & 2) != 0) {
            this.stringBuilder.append("private ");
        }
        if ((accessFlags2 & 4) != 0) {
            this.stringBuilder.append("protected ");
        }
        if ((accessFlags2 & 0x10) != 0) {
            this.stringBuilder.append("final ");
        }
        if ((accessFlags2 & 8) != 0) {
            this.stringBuilder.append("static ");
        }
        if ((accessFlags2 & 0x20) != 0) {
            this.stringBuilder.append("synchronized ");
        }
        if ((accessFlags2 & 0x40) != 0) {
            this.stringBuilder.append("volatile ");
        }
        if ((accessFlags2 & 0x80) != 0) {
            this.stringBuilder.append("transient ");
        }
        if ((accessFlags2 & 0x400) != 0) {
            this.stringBuilder.append("abstract ");
        }
        if ((accessFlags2 & 0x800) != 0) {
            this.stringBuilder.append("strictfp ");
        }
        if ((accessFlags2 & 0x1000) != 0) {
            this.stringBuilder.append("synthetic ");
        }
        if ((accessFlags2 & 0x8000) != 0) {
            this.stringBuilder.append("mandated ");
        }
        if ((accessFlags2 & 0x4000) != 0) {
            this.stringBuilder.append("enum ");
        }
    }

    private void appendRawAccess(int accessFlags2) {
        this.stringBuilder.append("// access flags 0x").append(Integer.toHexString(accessFlags2).toUpperCase()).append('\n');
    }

    protected void appendDescriptor(int type2, String value2) {
        if (type2 == 5 || type2 == 2 || type2 == 4) {
            if (value2 != null) {
                this.stringBuilder.append("// signature ").append(value2).append('\n');
            }
        } else {
            this.stringBuilder.append(value2);
        }
    }

    private void appendJavaDeclaration(String name2, String signature2) {
        TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(this.access);
        new SignatureReader(signature2).accept(traceSignatureVisitor);
        this.stringBuilder.append("// declaration: ");
        if (traceSignatureVisitor.getReturnType() != null) {
            this.stringBuilder.append(traceSignatureVisitor.getReturnType());
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append(name2);
        this.stringBuilder.append(traceSignatureVisitor.getDeclaration());
        if (traceSignatureVisitor.getExceptions() != null) {
            this.stringBuilder.append(" throws ").append(traceSignatureVisitor.getExceptions());
        }
        this.stringBuilder.append('\n');
    }

    protected void appendLabel(Label label) {
        String name2;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((name2 = this.labelNames.get(label)) == null) {
            name2 = "L" + this.labelNames.size();
            this.labelNames.put(label, name2);
        }
        this.stringBuilder.append(name2);
    }

    protected void appendHandle(Handle handle2) {
        int tag = handle2.getTag();
        this.stringBuilder.append("// handle kind 0x").append(Integer.toHexString(tag)).append(" : ");
        boolean isMethodHandle = false;
        switch (tag) {
            case 1: {
                this.stringBuilder.append("GETFIELD");
                break;
            }
            case 2: {
                this.stringBuilder.append("GETSTATIC");
                break;
            }
            case 3: {
                this.stringBuilder.append("PUTFIELD");
                break;
            }
            case 4: {
                this.stringBuilder.append("PUTSTATIC");
                break;
            }
            case 9: {
                this.stringBuilder.append("INVOKEINTERFACE");
                isMethodHandle = true;
                break;
            }
            case 7: {
                this.stringBuilder.append("INVOKESPECIAL");
                isMethodHandle = true;
                break;
            }
            case 6: {
                this.stringBuilder.append("INVOKESTATIC");
                isMethodHandle = true;
                break;
            }
            case 5: {
                this.stringBuilder.append("INVOKEVIRTUAL");
                isMethodHandle = true;
                break;
            }
            case 8: {
                this.stringBuilder.append("NEWINVOKESPECIAL");
                isMethodHandle = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendDescriptor(0, handle2.getOwner());
        this.stringBuilder.append('.');
        this.stringBuilder.append(handle2.getName());
        if (!isMethodHandle) {
            this.stringBuilder.append('(');
        }
        this.appendDescriptor(9, handle2.getDesc());
        if (!isMethodHandle) {
            this.stringBuilder.append(')');
        }
        if (handle2.isInterface()) {
            this.stringBuilder.append(" itf");
        }
    }

    private void maybeAppendComma(int numValues) {
        if (numValues > 0) {
            this.stringBuilder.append(", ");
        }
    }

    private void appendTypeReference(int typeRef) {
        TypeReference typeReference = new TypeReference(typeRef);
        switch (typeReference.getSort()) {
            case 0: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 1: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 16: {
                this.stringBuilder.append("CLASS_EXTENDS ").append(typeReference.getSuperTypeIndex());
                break;
            }
            case 17: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 18: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 19: {
                this.stringBuilder.append("FIELD");
                break;
            }
            case 20: {
                this.stringBuilder.append("METHOD_RETURN");
                break;
            }
            case 21: {
                this.stringBuilder.append("METHOD_RECEIVER");
                break;
            }
            case 22: {
                this.stringBuilder.append("METHOD_FORMAL_PARAMETER ").append(typeReference.getFormalParameterIndex());
                break;
            }
            case 23: {
                this.stringBuilder.append("THROWS ").append(typeReference.getExceptionIndex());
                break;
            }
            case 64: {
                this.stringBuilder.append("LOCAL_VARIABLE");
                break;
            }
            case 65: {
                this.stringBuilder.append("RESOURCE_VARIABLE");
                break;
            }
            case 66: {
                this.stringBuilder.append("EXCEPTION_PARAMETER ").append(typeReference.getTryCatchBlockIndex());
                break;
            }
            case 67: {
                this.stringBuilder.append("INSTANCEOF");
                break;
            }
            case 68: {
                this.stringBuilder.append("NEW");
                break;
            }
            case 69: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE");
                break;
            }
            case 70: {
                this.stringBuilder.append("METHOD_REFERENCE");
                break;
            }
            case 71: {
                this.stringBuilder.append("CAST ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 72: {
                this.stringBuilder.append("CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 73: {
                this.stringBuilder.append("METHOD_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 74: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 75: {
                this.stringBuilder.append("METHOD_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void appendFrameTypes(int numTypes, Object[] frameTypes) {
        for (int i = 0; i < numTypes; ++i) {
            if (i > 0) {
                this.stringBuilder.append(' ');
            }
            if (frameTypes[i] instanceof String) {
                String descriptor2 = (String)frameTypes[i];
                if (descriptor2.charAt(0) == '[') {
                    this.appendDescriptor(1, descriptor2);
                    continue;
                }
                this.appendDescriptor(0, descriptor2);
                continue;
            }
            if (frameTypes[i] instanceof Integer) {
                this.stringBuilder.append(FRAME_TYPES.get((Integer)frameTypes[i]));
                continue;
            }
            this.appendLabel((Label)frameTypes[i]);
        }
    }

    private Textifier addNewTextifier(String endText) {
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        if (endText != null) {
            this.text.add(endText);
        }
        return textifier;
    }

    protected Textifier createTextifier() {
        return new Textifier(this.api);
    }
}

