/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;

public class FreeColXMLReader
extends StreamReaderDelegate
implements Closeable {
    private static final Logger logger = Logger.getLogger(FreeColXMLReader.class.getName());
    private static final Map<Integer, String> tagStrings = CollectionUtils.makeUnmodifiableMap(new Integer[]{10, 12, 4, 5, 11, 8, 2, 15, 9, 13, 14, 3, 6, 7, 1}, new String[]{"Attribute", "CData", "Characters", "Comment", "DTD", "EndDocument", "EndElement", "EntityDeclaration", "EntityReference", "Namespace", "NotationDeclaration", "ProcessingInstruction", "Space", "StartDocument", "StartElement"});
    private boolean tracing = false;
    private InputStream inputStream = null;
    private ReadScope readScope;
    private Map<String, FreeColObject> uninterned = new HashMap<String, FreeColObject>();

    public FreeColXMLReader(BufferedInputStream bis) throws XMLStreamException {
        XMLInputFactory xif = FreeColXMLReader.newXMLInputFactory();
        try {
            XMLStreamReader xsr = xif.createXMLStreamReader(bis, "UTF-8");
            this.setParent(xsr);
        }
        catch (Exception ex) {
            throw new XMLStreamException("Stream reader fail", ex);
        }
        this.inputStream = bis;
        this.readScope = ReadScope.NORMAL;
        this.uninterned.clear();
    }

    public FreeColXMLReader(InputStream inputStream) throws XMLStreamException {
        this(new BufferedInputStream(inputStream));
    }

    public FreeColXMLReader(File file) throws IOException, XMLStreamException {
        this(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public FreeColXMLReader(Reader reader) throws XMLStreamException {
        XMLInputFactory xif = FreeColXMLReader.newXMLInputFactory();
        XMLStreamReader xsr = xif.createXMLStreamReader(reader);
        this.setParent(xsr);
        this.inputStream = null;
        this.readScope = ReadScope.NORMAL;
        this.uninterned.clear();
    }

    private static XMLInputFactory newXMLInputFactory() {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.supportDTD", false);
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xif;
    }

    public FreeColXMLReader setTracing(boolean tracing) {
        this.tracing = tracing;
        return this;
    }

    public boolean shouldIntern() {
        return this.readScope != ReadScope.NOINTERN;
    }

    public ReadScope getReadScope() {
        return this.readScope;
    }

    public FreeColXMLReader setReadScope(ReadScope readScope) {
        this.readScope = readScope;
        return this;
    }

    public ReadScope replaceScope(ReadScope newReadScope) {
        ReadScope ret = this.readScope;
        if (this.readScope != newReadScope) {
            this.uninterned.clear();
        }
        this.readScope = newReadScope;
        return ret;
    }

    private FreeColObject lookup(Game game, String id) {
        FreeColObject fco;
        FreeColObject freeColObject = fco = this.shouldIntern() ? null : this.uninterned.get(id);
        return fco != null ? fco : (game == null ? null : game.getFreeColGameObject(id));
    }

    public <T extends FreeColObject> T lookup(Game game, String id, Class<T> returnClass) throws XMLStreamException {
        FreeColObject fco = this.lookup(game, id);
        try {
            return (T)((FreeColObject)returnClass.cast(fco));
        }
        catch (ClassCastException cce) {
            throw new XMLStreamException(cce);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Error closing stream.", xse);
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error closing stream.", ioe);
            }
            this.inputStream = null;
        }
    }

    public String readId() {
        Object id = this.getAttribute("id", null);
        if (id == null) {
            return null;
        }
        int idx = ((String)id).indexOf(58);
        if (idx > 10) {
            String prefix = ((String)id).substring(0, idx);
            if ("tileitemcontainer".equals(prefix)) {
                id = "tileItemContainer" + ((String)id).substring(idx);
            } else if ("tileimprovement".equals(prefix)) {
                id = "tileImprovement" + ((String)id).substring(idx);
            }
        }
        return id;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int tag = super.nextTag();
        if (this.tracing) {
            switch (tag) {
                case 1: {
                    System.err.println("[" + this.getLocalName());
                    break;
                }
                case 2: {
                    System.err.println(this.getLocalName() + "]");
                    break;
                }
                default: {
                    String val = tagStrings.get(tag);
                    System.err.println((String)(val == null ? "Weird tag: " + tag : val));
                }
            }
        }
        return tag;
    }

    public boolean atTag(String tag) {
        return this.getLocalName().equals(tag);
    }

    public void expectTag(String tag) throws XMLStreamException {
        String endTag = this.getLocalName();
        if (!endTag.equals(tag)) {
            throw new XMLStreamException("Parse error, " + tag + " expected, not: " + endTag);
        }
    }

    public boolean moreTags() throws XMLStreamException {
        return this.nextTag() != 2;
    }

    public void closeTag(String tag) throws XMLStreamException {
        if (this.moreTags()) {
            throw new XMLStreamException("Parse error, END_ELEMENT expected, not: " + this.getLocalName());
        }
        this.expectTag(tag);
    }

    public void closeTag(String tag, String ... others) throws XMLStreamException {
        int next = this.nextTag();
        while (next != 2) {
            String at = CollectionUtils.find(others, s -> this.atTag((String)s));
            if (at == null) {
                throw new XMLStreamException("Parse error, END_ELEMENT(" + tag + " or alternatives) expected, not: " + this.getLocalName());
            }
            this.closeTag(at);
            next = this.nextTag();
        }
        this.expectTag(tag);
    }

    public void swallowTag(String tag) throws XMLStreamException {
        while (this.moreTags() || !tag.equals(this.getLocalName())) {
        }
    }

    public String currentTag() {
        StringBuilder sb = new StringBuilder(this.getLocalName());
        sb.append(", attributes:");
        int n = this.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            sb.append(' ').append(this.getAttributeLocalName(i)).append("=\"").append(this.getAttributeValue(i)).append('\"');
        }
        return sb.toString();
    }

    public void unexpectedTag(String context) throws XMLStreamException {
        throw new XMLStreamException("In " + context + ", unexpected tag " + this.getLocalName() + ", at: " + this.currentTag());
    }

    public boolean hasAttribute(String attributeName) {
        return this.getParent().getAttributeValue(null, attributeName) != null;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : Boolean.parseBoolean(attrib);
    }

    public float getAttribute(String attributeName, float defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        float result = defaultValue;
        if (attrib != null) {
            try {
                result = Float.parseFloat(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not a float: " + attrib);
            }
        }
        return result;
    }

    public int getAttribute(String attributeName, int defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        int result = defaultValue;
        if (attrib != null) {
            try {
                result = Integer.decode(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not an integer: " + attrib);
            }
        }
        return result;
    }

    public long getAttribute(String attributeName, long defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        long result = defaultValue;
        if (attrib != null) {
            try {
                result = Long.decode(attrib);
            }
            catch (NumberFormatException e) {
                logger.warning(attributeName + " is not a long: " + attrib);
            }
        }
        return result;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        return attrib == null ? defaultValue : attrib;
    }

    public <T extends Enum<T>> T getAttribute(String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = this.getParent().getAttributeValue(null, attributeName);
        T result = defaultValue;
        if (attrib != null) {
            try {
                result = Enum.valueOf(returnClass, StringUtils.upCase(attrib));
            }
            catch (Exception e) {
                logger.warning(attributeName + " is not a " + returnClass.getName() + ": " + attrib);
            }
        }
        return result;
    }

    public <T extends FreeColObject> T getAttribute(Game game, String attributeName, Class<T> returnClass, T defaultValue) throws XMLStreamException {
        String attrib;
        String string = attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (attrib == null) {
            return defaultValue;
        }
        return this.lookup(game, attrib, returnClass);
    }

    public <T extends AIObject> T getAttribute(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        return attrib == null ? defaultValue : aiMain.getAIObject(attrib, returnClass);
    }

    public Location getLocationAttribute(Game game, String attributeName, boolean make) throws XMLStreamException {
        Class<? extends FreeColGameObject> c;
        String attrib;
        if (attributeName == null) {
            return null;
        }
        String string = attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        if (attrib == null) {
            return null;
        }
        FreeColObject fco = this.lookup(game, attrib);
        if (fco == null && make && (c = Game.getLocationClass(attrib)) != null) {
            fco = this.makeFreeColObject(game, attributeName, c, this.getReadScope() == ReadScope.SERVER);
        }
        if (fco instanceof Location) {
            return (Location)((Object)fco);
        }
        logger.warning("Not a location: " + attrib);
        return null;
    }

    public Map<String, String> getAttributeMap(String ... attributes) {
        HashMap<String, String> ret = new HashMap<String, String>(attributes.length);
        for (String a : attributes) {
            ret.put(a, this.getAttribute(a, null));
        }
        return ret;
    }

    public Map<String, String> getArrayAttributeMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        int n = this.getAttribute("xLength", -1);
        if (n >= 0) {
            String key;
            ret.put("xLength", Integer.toString(n));
            for (int i = 0; i < n && this.hasAttribute(key = FreeColObject.arrayKey(i)); ++i) {
                ret.put(key, this.getAttribute(key, null));
            }
        }
        return ret;
    }

    public Map<String, String> getAllAttributes() {
        int n = this.getParent().getAttributeCount();
        HashMap<String, String> ret = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String key = this.getParent().getAttributeLocalName(i);
            String value = this.getParent().getAttributeValue(i);
            ret.put(key, value);
        }
        return ret;
    }

    public <T extends FreeColSpecObjectType> List<T> readList(Specification spec, String tag, Class<T> type) throws XMLStreamException {
        this.expectTag(tag);
        int length = this.getAttribute("xLength", -1);
        if (length < 0) {
            return Collections.emptyList();
        }
        ArrayList<FreeColSpecObjectType> list = new ArrayList<FreeColSpecObjectType>(length);
        for (int x = 0; x < length; ++x) {
            FreeColSpecObjectType value = this.getType(spec, FreeColObject.arrayKey(x), type, null);
            if (value == null) {
                logger.warning("Null list value(" + x + ")");
            }
            list.add(value);
        }
        this.closeTag(tag);
        return list;
    }

    public <T extends FreeColGameObject> T findFreeColGameObject(Game game, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        FreeColGameObject ret = this.getAttribute(game, attributeName, returnClass, (FreeColGameObject)null);
        if (ret == (FreeColGameObject)null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
            ret = defaultValue;
        }
        return (T)ret;
    }

    public <T extends FreeColObject> T makeFreeColObject(Game game, String attributeName, Class<T> returnClass, boolean required) throws XMLStreamException {
        String id = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        FreeColObject ret = null;
        if (id == null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
        } else {
            T t = this.lookup(game, id, returnClass);
            ret = (FreeColObject)t;
            if (t == null) {
                ret = (FreeColObject)Game.newInstance(game, returnClass, this.getReadScope() == ReadScope.SERVER);
                if (ret == null) {
                    String err = "Failed to create " + returnClass.getName() + " with id: " + id;
                    if (required) {
                        throw new XMLStreamException(err);
                    }
                    logger.warning(err);
                } else if (ret instanceof FreeColGameObject) {
                    ret.setId(id);
                    if (this.shouldIntern()) {
                        ((FreeColGameObject)ret).internId(id);
                    } else {
                        this.uninterned.put(id, ret);
                    }
                }
            }
        }
        return (T)ret;
    }

    private <T extends FreeColObject> T internedRead(Game game, Class<T> returnClass) throws XMLStreamException {
        T ret = this.makeFreeColObject(game, "id", returnClass, false);
        if (ret != null) {
            ((FreeColObject)ret).readFromXML(this);
        }
        return ret;
    }

    private <T extends FreeColObject> T uninternedRead(Game game, Class<T> returnClass) throws XMLStreamException {
        FreeColObject ret;
        String id = this.readId();
        if (id == null) {
            throw new XMLStreamException("Null object identifier for: " + returnClass.getName());
        }
        FreeColObject fco = this.uninterned.get(id);
        if (fco == null) {
            ret = Game.newInstance(game, returnClass, this.getReadScope() == ReadScope.SERVER);
            if (ret == null) {
                throw new XMLStreamException("Failed to create " + returnClass.getName() + " with id: " + id);
            }
        } else {
            try {
                ret = (FreeColObject)returnClass.cast(fco);
            }
            catch (ClassCastException cce) {
                throw new XMLStreamException(cce);
            }
        }
        this.uninterned.put(id, ret);
        ret.readFromXML(this);
        return (T)ret;
    }

    public <T extends FreeColObject> T readFreeColObject(Game game, Class<T> returnClass) throws XMLStreamException {
        return this.shouldIntern() ? this.internedRead(game, returnClass) : this.uninternedRead(game, returnClass);
    }

    public <T extends FreeColObject> T readFreeColObject(Game game) throws XMLStreamException {
        String tag = this.getLocalName();
        Class returnClass = FreeColObject.getFreeColObjectClassByName(tag);
        if (returnClass == null) {
            throw new XMLStreamException("No class: " + tag);
        }
        return this.readFreeColObject(game, returnClass);
    }

    public <T extends AIObject> T findAIObject(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        AIObject ret = this.getAttribute(aiMain, attributeName, returnClass, (AIObject)null);
        if (ret == (AIObject)null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
            ret = defaultValue;
        }
        return (T)ret;
    }

    public <T extends AIObject> T makeAIObject(AIMain aiMain, String attributeName, Class<T> returnClass, T defaultValue, boolean required) throws XMLStreamException {
        String id = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        AIObject ret = null;
        if (id == null) {
            if (required) {
                throw new XMLStreamException("Missing " + attributeName + " for " + returnClass.getName() + ": " + this.currentTag());
            }
        } else {
            ret = (AIObject)aiMain.getAIObject(id, returnClass);
            if (ret == null) {
                try {
                    Constructor<T> c = returnClass.getConstructor(AIMain.class, String.class);
                    ret = (AIObject)returnClass.cast(c.newInstance(aiMain, id));
                    if (required && ret == null) {
                        throw new XMLStreamException("Constructed null " + returnClass.getName() + " for " + id + ": " + this.currentTag());
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | XMLStreamException e) {
                    if (required) {
                        throw new XMLStreamException(e);
                    }
                    logger.log(Level.WARNING, "Failed to create AIObject: " + id, e);
                }
            }
        }
        return (T)ret;
    }

    public boolean shouldClearContainers() {
        return !this.hasAttribute("extends") && !this.hasAttribute("preserve");
    }

    public <T extends FreeColSpecObjectType> T getType(Specification spec, String attributeName, Class<T> returnClass, T defaultValue) {
        String attrib = "id".equals(attributeName) ? this.readId() : this.getAttribute(attributeName, null);
        return attrib == null ? defaultValue : spec.findType(attrib, returnClass);
    }

    public <T extends FreeColObject> T copy(Game game, Class<T> returnClass) throws XMLStreamException {
        this.setReadScope(ReadScope.NOINTERN);
        this.nextTag();
        return this.uninternedRead(game, returnClass);
    }

    public int readAttributeValues(Map<String, String> map, String attr) throws XMLStreamException {
        int ret = 0;
        while (this.hasNext()) {
            String id;
            try {
                this.nextTag();
            }
            catch (XMLStreamException xse) {
                break;
            }
            if (this.getEventType() != 1 || (id = this.readId()) == null || !map.containsKey(id)) continue;
            map.put(id, this.getAttribute(attr, null));
            ++ret;
        }
        return ret;
    }

    public static enum ReadScope {
        SERVER,
        NORMAL,
        NOINTERN;

    }
}

