/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Anchor;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RtfAnchor
extends RtfField {
    private static final byte[] HYPERLINK = "HYPERLINK".getBytes();
    private String url = "";
    private RtfPhrase content = null;

    public RtfAnchor(RtfDocument rtfDocument, Anchor anchor) {
        super(rtfDocument);
        this.url = anchor.getReference();
        this.content = new RtfPhrase(rtfDocument, anchor);
    }

    protected byte[] writeFieldInstContent() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldInstContent(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void writeFieldInstContent(OutputStream outputStream) throws IOException {
        outputStream.write(HYPERLINK);
        outputStream.write(DELIMITER);
        this.document.filterSpecialChar(outputStream, this.url, true, true);
    }

    protected byte[] writeFieldResultContent() throws IOException {
        return this.content.write();
    }

    protected void writeFieldResultContent(OutputStream outputStream) throws IOException {
        this.content.writeContent(outputStream);
    }
}

