/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.NaanSafeNumberFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LongMessageFormat
extends Format {
    protected static final int OUTSIDE_BRACKETS = 0;
    protected static final int INSIDE_BRACKETS = 1;
    protected List stringChunks;
    protected Format[] formats;
    protected int[] formatNumber;

    public LongMessageFormat(String pattern) throws IllegalArgumentException {
        this.applyPattern(pattern);
    }

    @Override
    public StringBuffer format(Object objArray, StringBuffer toAppendTo, FieldPosition ignore) throws IllegalArgumentException {
        return this.format((Object[])objArray, toAppendTo, ignore);
    }

    public StringBuffer format(Object[] objArray, StringBuffer toAppendTo, FieldPosition ignore) {
        int chunkNum = 0;
        Iterator chunkIterator = this.stringChunks.iterator();
        while (chunkIterator.hasNext()) {
            toAppendTo.append(chunkIterator.next());
            if (chunkIterator.hasNext()) {
                Object insertMe = objArray[this.formatNumber[chunkNum]];
                Format thisFieldFormat = this.formats[chunkNum];
                String parsedString = null;
                if (thisFieldFormat != null && insertMe != null) {
                    Object parsedObject = null;
                    try {
                        parsedObject = thisFieldFormat instanceof NumberFormat ? new Float((String)insertMe) : thisFieldFormat.parseObject((String)insertMe);
                        parsedString = thisFieldFormat.format(parsedObject);
                    }
                    catch (ParseException e) {
                        parsedString = insertMe.toString();
                    }
                    catch (NumberFormatException e) {
                        parsedString = insertMe.toString();
                    }
                    toAppendTo.append(parsedString);
                } else {
                    toAppendTo.append(insertMe);
                }
            }
            ++chunkNum;
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition ignore) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setFormat(int i, Format theFormat) {
        this.formats[i] = theFormat;
    }

    public Format getFormat(int i) {
        return this.formats[i];
    }

    public void applyPattern(String pattern) throws IllegalArgumentException {
        int numSpecifiers = this.countBraces(pattern);
        this.formatNumber = new int[numSpecifiers];
        this.stringChunks = new LinkedList();
        this.formats = new Format[numSpecifiers];
        this.parsePattern(pattern);
    }

    protected int countBraces(String pattern) throws IllegalArgumentException {
        int count = 0;
        int state = 0;
        block12: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case '}': {
                            throw new IllegalArgumentException("Found '}' without matching '{' at position " + i);
                        }
                        case '{': {
                            state = 1;
                            continue block12;
                        }
                    }
                    continue block12;
                }
                case 1: {
                    switch (ch) {
                        case '}': {
                            state = 0;
                            ++count;
                            break block0;
                        }
                        case '{': {
                            throw new IllegalArgumentException("Found '{' after '{' at position " + i);
                        }
                    }
                }
            }
        }
        if (state == 1) {
            throw new IllegalArgumentException("Unterminated '{'");
        }
        return count;
    }

    protected void parsePattern(String pattern) {
        int pos = 0;
        int nextPos = 0;
        int blockNum = 0;
        nextPos = pattern.indexOf(123, pos);
        while (nextPos >= 0) {
            this.stringChunks.add(pattern.substring(pos, nextPos));
            int formatNumStart = nextPos + 1;
            int formatNumEnd = 0;
            formatNumEnd = pattern.indexOf(125, formatNumStart);
            String formatNumStr = pattern.substring(formatNumStart, formatNumEnd);
            String formatType = null;
            int commaPos = formatNumStr.indexOf(44);
            if (commaPos != -1) {
                formatType = formatNumStr.substring(commaPos + 1);
                formatNumStr = formatNumStr.substring(0, commaPos);
            }
            int parsedFormatNum = 0;
            try {
                parsedFormatNum = Integer.parseInt(formatNumStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The format argument '" + formatNumStr + "' is not a number.");
            }
            if (formatType != null) {
                if (formatType.startsWith("number")) {
                    if (formatType.length() == "number".length()) {
                        this.setFormat(blockNum, new NaanSafeNumberFormat("#,##0.##"));
                    } else {
                        int formatIdx = formatType.indexOf(58);
                        if (formatIdx < 0) {
                            throw new IllegalArgumentException("Custom number format '" + formatType + "' incorrect. " + "You must use the form \"{number:\"<format>\"}\" " + "where <format> is a DecimalFormat pattern.");
                        }
                        String formatStr = formatType.substring(formatIdx + 1);
                        this.setFormat(blockNum, new NaanSafeNumberFormat(formatStr));
                    }
                } else {
                    throw new IllegalArgumentException("The format argument '" + formatType + "' is unknown.");
                }
            }
            this.formatNumber[blockNum] = parsedFormatNum;
            ++blockNum;
            pos = pattern.indexOf(125, nextPos) + 1;
            nextPos = pattern.indexOf(123, pos);
        }
        this.stringChunks.add(pattern.substring(pos));
    }

    public static void main(String[] args) {
        String pattern = "0: {0,number}, 1: {1}, 2: {2}, 5: {5}, 6: {6}, 7: {7}, 8: {8}, 9: {9}, 10: {10}, 4: {4}, 11: {11}, 3: {3}, 12: {12}.";
        Object[] numbersEN = new String[]{"234972349587.23947523947", null, null, "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        Object[] numbersES = new Object[]{"234972349587.23947523947", "uno", "dos", "tres", "cuatro", "cinquo", "seis", "siete", "ocho", "nueve", "diez", "once", "doce"};
        LongMessageFormat lmf = new LongMessageFormat(pattern);
        System.out.println("stringChunks=" + lmf.stringChunks);
        System.out.print("formatNumber=[");
        for (int i = 0; i < lmf.formatNumber.length; ++i) {
            System.out.print(lmf.formatNumber[i]);
            System.out.print(", ");
        }
        System.out.println("]");
        System.out.print("In English: ");
        System.out.println(lmf.format(numbersEN, new StringBuffer(), (FieldPosition)null));
        System.out.print("En Espanol: ");
        System.out.println(lmf.format(numbersES, new StringBuffer(), (FieldPosition)null));
    }
}

