/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.TableModelWrapper;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableUtils {
    public static void fitColumnWidth(JTable table, int colIndex, int padding) {
        TableUtils.fitColumnWidth(table, colIndex, -1, padding);
    }

    public static void fitColumnWidth(JTable table, int colIndex, int maxWidth, int padding) {
        TableUtils.fitColumnWidths(table, -1, maxWidth, padding);
    }

    public static void fitColumnWidth(JTable table, int colIndex, int minWidth, int maxWidth, int padding) {
        TableColumn column = null;
        Component comp = null;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        column = table.getColumnModel().getColumn(colIndex);
        comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, colIndex);
        cellWidth = comp.getPreferredSize().width + 2;
        int limit = table.getRowCount() > 100 ? 100 : table.getRowCount();
        for (int j = 0; j < limit; ++j) {
            TableCellRenderer cellRenderer = table.getCellRenderer(j, colIndex);
            if (cellRenderer == null) continue;
            comp = cellRenderer.getTableCellRendererComponent(table, table.getValueAt(j, colIndex), false, false, j, colIndex);
            cellWidth = Math.max(cellWidth, comp.getPreferredSize().width + 1);
            if (maxWidth <= 0 || cellWidth < maxWidth) continue;
            cellWidth = maxWidth;
            break;
        }
        if (minWidth >= 0 && cellWidth < minWidth) {
            cellWidth = minWidth;
        }
        column.setPreferredWidth(cellWidth + padding);
    }

    public static void fitColumnWidths(JTable table, int maxColumnWidth, int padding) {
        TableUtils.fitColumnWidths(table, -1, maxColumnWidth, padding);
    }

    public static void fitColumnWidths(JTable table, int minColumnWidth, int maxColumnWidth, int padding) {
        table.setAutoResizeMode(0);
        int limit = table.getColumnCount() > 5 ? 5 : table.getColumnCount();
        for (int colIndex = 0; colIndex < limit; ++colIndex) {
            TableUtils.fitColumnWidth(table, colIndex, minColumnWidth, maxColumnWidth, padding);
        }
    }

    public static void fitColumnWidths(JTable table, int padding) {
        TableUtils.fitColumnWidths(table, -1, padding);
    }

    public static TableModel unwrap(TableModel m) {
        while (m instanceof TableModelWrapper) {
            m = ((TableModelWrapper)((Object)m)).getWrappedModel();
        }
        return m;
    }
}

