/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public abstract class TimedDocumentListener
implements DocumentListener {
    private static final Logger logger = Logger.getLogger(TimedDocumentListener.class);
    private boolean dirty = false;
    private boolean changed = false;
    private Timer timer = new Timer();
    private boolean cancelled = false;
    private TimerTask task = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimedDocumentListener timedDocumentListener = TimedDocumentListener.this;
            synchronized (timedDocumentListener) {
                if (TimedDocumentListener.this.cancelled) {
                    TimedDocumentListener.this.timer.cancel();
                    return;
                }
                if (!TimedDocumentListener.this.isDirty() && TimedDocumentListener.this.isChanged()) {
                    TimedDocumentListener.this.textChanged();
                }
                TimedDocumentListener.this.setChanged(TimedDocumentListener.this.isDirty());
                TimedDocumentListener.this.setDirty(false);
            }
        }
    };
    private final String name;

    public TimedDocumentListener(String name, long delay) {
        this.name = name;
        this.timer.scheduleAtFixedRate(this.task, delay, delay);
    }

    @Override
    public synchronized void changedUpdate(DocumentEvent e) {
        this.setDirty(true);
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        this.setDirty(true);
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        this.setDirty(true);
    }

    public synchronized void cancel() {
        this.cancelled = true;
        logger.debug((Object)(this.name + ": cancelled called dirty is " + this.isDirty() + " changed is " + this.isChanged()));
        if (this.isDirty() || this.isChanged()) {
            this.textChanged();
        }
    }

    public abstract void textChanged();

    private synchronized void setDirty(boolean dirty) {
        this.dirty = dirty;
        logger.debug((Object)(this.name + ": dirty is " + dirty));
    }

    private synchronized boolean isDirty() {
        return this.dirty;
    }

    private synchronized void setChanged(boolean changed) {
        this.changed = changed;
        logger.debug((Object)(this.name + ": Changed is " + changed));
    }

    private synchronized boolean isChanged() {
        return this.changed;
    }
}

