/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.listeners.FilenameChangedListener;
import org.pentaho.di.core.listeners.NameChangedListener;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.reflection.StringSearcher;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.Messages;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryUtil;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.HasSlaveServersInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobMeta
extends ChangedFlag
implements Cloneable,
Comparable<JobMeta>,
XMLInterface,
UndoInterface,
HasDatabasesInterface,
VariableSpace,
EngineMetaInterface,
ResourceExportInterface,
HasSlaveServersInterface,
NamedParams {
    public static final String XML_TAG = "job";
    private static final String XML_TAG_SLAVESERVERS = "slaveservers";
    public LogWriter log;
    protected long id;
    protected String name;
    protected String description;
    protected String extendedDescription;
    protected String jobVersion;
    protected int jobStatus;
    protected String filename;
    public List<JobEntryInterface> jobentries;
    public List<JobEntryCopy> jobcopies;
    public List<JobHopMeta> jobhops;
    public List<NotePadMeta> notes;
    public List<DatabaseMeta> databases;
    private List<SlaveServer> slaveServers;
    protected RepositoryDirectory directory;
    protected String[] arguments;
    protected boolean changedEntries;
    protected boolean changedHops;
    protected boolean changedNotes;
    protected boolean changedDatabases;
    protected DatabaseMeta logConnection;
    protected String logTable;
    protected List<TransAction> undo;
    private VariableSpace variables = new Variables();
    protected int max_undo;
    protected int undo_position;
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    public static final String STRING_SPECIAL = "SPECIAL";
    public static final String STRING_SPECIAL_START = "START";
    public static final String STRING_SPECIAL_DUMMY = "DUMMY";
    public static final String STRING_SPECIAL_OK = "OK";
    public static final String STRING_SPECIAL_ERROR = "ERROR";
    public boolean[] max = new boolean[1];
    private String created_user;
    private String modifiedUser;
    private Date created_date;
    private Date modifiedDate;
    protected boolean useBatchId;
    protected boolean batchIdPassed;
    protected boolean logfieldUsed;
    protected String sharedObjectsFile;
    private SharedObjects sharedObjects;
    private List<NameChangedListener> nameChangedListeners;
    private List<FilenameChangedListener> filenameChangedListeners;
    private NamedParams namedParams = new NamedParamsDefault();
    private static final String XML_TAG_PARAMETERS = "parameters";
    private String logSizeLimit;

    public JobMeta(LogWriter l) {
        this.log = l;
        this.clear();
        this.initializeVariablesFrom(null);
    }

    public long getID() {
        return this.id;
    }

    @Override
    public void setID(long id) {
        this.id = id;
    }

    public void clear() {
        this.setName(null);
        this.setFilename(null);
        this.jobcopies = new ArrayList<JobEntryCopy>();
        this.jobentries = new ArrayList<JobEntryInterface>();
        this.jobhops = new ArrayList<JobHopMeta>();
        this.notes = new ArrayList<NotePadMeta>();
        this.databases = new ArrayList<DatabaseMeta>();
        this.slaveServers = new ArrayList<SlaveServer>();
        this.logConnection = null;
        this.logTable = null;
        this.arguments = null;
        this.max_undo = 100;
        this.undo = new ArrayList<TransAction>();
        this.undo_position = -1;
        this.addDefaults();
        this.setChanged(false);
        this.created_user = "-";
        this.created_date = new Date();
        this.modifiedUser = "-";
        this.modifiedDate = new Date();
        this.directory = new RepositoryDirectory();
        this.description = null;
        this.jobStatus = -1;
        this.jobVersion = null;
        this.extendedDescription = null;
        this.useBatchId = true;
        this.logfieldUsed = true;
    }

    public void addDefaults() {
        this.clearChanged();
    }

    public static final JobEntryCopy createStartEntry() {
        JobEntrySpecial jobEntrySpecial = new JobEntrySpecial(STRING_SPECIAL_START, true, false);
        JobEntryCopy jobEntry = new JobEntryCopy();
        jobEntry.setID(-1L);
        jobEntry.setEntry(jobEntrySpecial);
        jobEntry.setLocation(50, 50);
        jobEntry.setDrawn(false);
        jobEntry.setDescription(Messages.getString("JobMeta.StartJobEntry.Description"));
        return jobEntry;
    }

    public static final JobEntryCopy createDummyEntry() {
        JobEntrySpecial jobEntrySpecial = new JobEntrySpecial(STRING_SPECIAL_DUMMY, false, true);
        JobEntryCopy jobEntry = new JobEntryCopy();
        jobEntry.setID(-1L);
        jobEntry.setEntry(jobEntrySpecial);
        jobEntry.setLocation(50, 50);
        jobEntry.setDrawn(false);
        jobEntry.setDescription(Messages.getString("JobMeta.DummyJobEntry.Description"));
        return jobEntry;
    }

    public JobEntryCopy getStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isStart()) continue;
            return cge;
        }
        return null;
    }

    public JobEntryCopy getDummy() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy cge = this.getJobEntry(i);
            if (!cge.isDummy()) continue;
            return cge;
        }
        return null;
    }

    public int compare(JobMeta t1, JobMeta t2) {
        if (Const.isEmpty((String)t1.getName()) && !Const.isEmpty((String)t2.getName())) {
            return -1;
        }
        if (!Const.isEmpty((String)t1.getName()) && Const.isEmpty((String)t2.getName())) {
            return 1;
        }
        if (Const.isEmpty((String)t1.getName()) && Const.isEmpty((String)t2.getName())) {
            if (Const.isEmpty((String)t1.getFilename()) && !Const.isEmpty((String)t2.getFilename())) {
                return -1;
            }
            if (!Const.isEmpty((String)t1.getFilename()) && Const.isEmpty((String)t2.getFilename())) {
                return 1;
            }
            if (Const.isEmpty((String)t1.getFilename()) && Const.isEmpty((String)t2.getFilename())) {
                return 0;
            }
            return t1.getFilename().compareTo(t2.getFilename());
        }
        return t1.getName().compareTo(t2.getName());
    }

    @Override
    public int compareTo(JobMeta o) {
        return this.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobMeta)) {
            return false;
        }
        return this.compare(this, (JobMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            JobMeta jobMeta = (JobMeta)super.clone();
            if (doClear) {
                jobMeta.clear();
            } else {
                jobMeta.jobcopies = new ArrayList<JobEntryCopy>();
                jobMeta.jobentries = new ArrayList<JobEntryInterface>();
                jobMeta.jobhops = new ArrayList<JobHopMeta>();
                jobMeta.notes = new ArrayList<NotePadMeta>();
                jobMeta.databases = new ArrayList<DatabaseMeta>();
                jobMeta.slaveServers = new ArrayList<SlaveServer>();
                jobMeta.namedParams = new NamedParamsDefault();
            }
            for (JobEntryInterface jobEntryInterface : this.jobentries) {
                jobMeta.jobentries.add((JobEntryInterface)jobEntryInterface.clone());
            }
            for (JobEntryCopy jobEntryCopy : this.jobcopies) {
                jobMeta.jobcopies.add((JobEntryCopy)jobEntryCopy.clone_deep());
            }
            for (JobHopMeta jobHopMeta : this.jobhops) {
                jobMeta.jobhops.add((JobHopMeta)jobHopMeta.clone());
            }
            for (NotePadMeta notePadMeta : this.notes) {
                jobMeta.notes.add((NotePadMeta)notePadMeta.clone());
            }
            for (DatabaseMeta databaseMeta : this.databases) {
                jobMeta.databases.add((DatabaseMeta)databaseMeta.clone());
            }
            for (SlaveServer slaveServer : this.slaveServers) {
                jobMeta.getSlaveServers().add((SlaveServer)slaveServer.clone());
            }
            for (String key : this.listParameters()) {
                jobMeta.addParameterDefinition(key, this.getParameterDefault(key), this.getParameterDescription(key));
            }
            return jobMeta;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.fireNameChangedListeners(this.name, newName);
        this.name = newName;
        this.setInternalKettleVariables();
    }

    @Override
    public void nameFromFilename() {
        if (!Const.isEmpty((String)this.filename)) {
            this.setName(Const.createName((String)this.filename));
        }
    }

    @Override
    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
        this.setInternalKettleVariables();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String newFilename) {
        this.fireFilenameChangedListeners(this.filename, newFilename);
        this.filename = newFilename;
        this.setInternalKettleVariables();
    }

    public DatabaseMeta getLogConnection() {
        return this.logConnection;
    }

    public void setLogConnection(DatabaseMeta ci) {
        this.logConnection = ci;
    }

    @Override
    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    @Override
    public void setDatabases(List<DatabaseMeta> databases) {
        Collections.sort(databases, DatabaseMeta.comparator);
        this.databases = databases;
    }

    @Override
    public void setChanged(boolean ch) {
        if (ch) {
            this.setChanged();
        } else {
            this.clearChanged();
        }
    }

    @Override
    public void clearChanged() {
        int i;
        this.changedEntries = false;
        this.changedHops = false;
        this.changedNotes = false;
        this.changedDatabases = false;
        for (int i2 = 0; i2 < this.nrJobEntries(); ++i2) {
            JobEntryCopy entry = this.getJobEntry(i2);
            entry.setChanged(false);
        }
        for (JobHopMeta hi : this.jobhops) {
            hi.setChanged(false);
        }
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta db = this.getDatabase(i);
            db.setChanged(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta note = this.getNote(i);
            note.setChanged(false);
        }
        super.clearChanged();
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveJobEntriesChanged()) {
            return true;
        }
        if (this.haveJobHopsChanged()) {
            return true;
        }
        if (this.haveConnectionsChanged()) {
            return true;
        }
        return this.haveNotesChanged();
    }

    protected void saveRepJob(Repository rep) throws KettleException {
        try {
            rep.insertJob(this);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobMeta.Exception.UnableToSaveJobToRepository"), (Throwable)dbe);
        }
    }

    private void saveRepParameters(Repository rep) throws KettleException {
        String[] paramKeys = this.listParameters();
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            String desc = this.getParameterDescription(paramKeys[idx]);
            String defValue = this.getParameterDefault(paramKeys[idx]);
            rep.insertJobParameter(this.getID(), idx, paramKeys[idx], defValue, desc);
        }
    }

    private void loadRepParameters(Repository rep) throws KettleException {
        this.eraseParameters();
        int count = rep.countJobParameter(this.getID());
        for (int idx = 0; idx < count; ++idx) {
            String key = rep.getJobParameterKey(this.getID(), idx);
            String defValue = rep.getJobParameterDefault(this.getID(), idx);
            String desc = rep.getJobParameterDescription(this.getID(), idx);
            this.addParameterDefinition(key, defValue, desc);
        }
    }

    @Override
    public boolean showReplaceWarning(Repository rep) {
        if (this.getID() < 0L) {
            try {
                if (rep.getJobID(this.getName(), this.directory.getID()) > 0L) {
                    return true;
                }
            }
            catch (KettleException dbe) {
                return true;
            }
        }
        return false;
    }

    public boolean isDatabaseConnectionUsed(DatabaseMeta databaseMeta) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jobEntry = this.getJobEntry(i);
            DatabaseMeta[] dbs = jobEntry.getEntry().getUsedDatabaseConnections();
            for (int d = 0; d < dbs.length; ++d) {
                if (dbs[d] == null || !dbs[d].equals((Object)databaseMeta)) continue;
                return true;
            }
        }
        return this.logConnection != null && this.logConnection.equals((Object)databaseMeta);
    }

    @Override
    public String getFileType() {
        return "Job";
    }

    @Override
    public String[] getFilterNames() {
        return Const.getJobFilterNames();
    }

    @Override
    public String[] getFilterExtensions() {
        return Const.STRING_JOB_FILTER_EXT;
    }

    @Override
    public String getDefaultExtension() {
        return "kjb";
    }

    @Override
    public String getXML() {
        int i;
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        DatabaseMeta ci = this.getLogConnection();
        StringBuffer retval = new StringBuffer(500);
        retval.append("<").append(XML_TAG).append(">").append(Const.CR);
        retval.append("  ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extended_description", (String)this.extendedDescription));
        retval.append("    ").append(XMLHandler.addTagValue((String)"job_version", (String)this.jobVersion));
        if (this.jobStatus >= 0) {
            retval.append("    ").append(XMLHandler.addTagValue((String)"job_status", (int)this.jobStatus));
        }
        retval.append("  ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory.getPath()));
        retval.append("  ").append(XMLHandler.addTagValue((String)"created_user", (String)this.created_user));
        retval.append("  ").append(XMLHandler.addTagValue((String)"created_date", (String)XMLHandler.date2string((Date)this.created_date)));
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_user", (String)this.modifiedUser));
        retval.append("  ").append(XMLHandler.addTagValue((String)"modified_date", (String)XMLHandler.date2string((Date)this.created_date)));
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        String[] parameters = this.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            retval.append("        ").append(XMLHandler.openTag((String)"parameter")).append(Const.CR);
            retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)parameters[idx]));
            try {
                retval.append("            ").append(XMLHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
                retval.append("            ").append(XMLHandler.addTagValue((String)"description", (String)this.getParameterDescription(parameters[idx])));
            }
            catch (UnknownParamException e) {
                // empty catch block
            }
            retval.append("        ").append(XMLHandler.closeTag((String)"parameter")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        for (i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta dbMeta = this.getDatabase(i);
            if (props != null && props.areOnlyUsedConnectionsSavedToXML()) {
                if (!this.isDatabaseConnectionUsed(dbMeta)) continue;
                retval.append(dbMeta.getXML());
                continue;
            }
            retval.append(dbMeta.getXML());
        }
        retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        for (i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            retval.append("         ").append(slaveServer.getXML()).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        retval.append("  ").append(XMLHandler.addTagValue((String)"logconnection", (String)(ci == null ? "" : ci.getName())));
        retval.append("  ").append(XMLHandler.addTagValue((String)"logtable", (String)this.logTable));
        retval.append("  ").append(XMLHandler.addTagValue((String)"size_limit_lines", (String)this.logSizeLimit));
        retval.append("   ").append(XMLHandler.addTagValue((String)"use_batchid", (boolean)this.useBatchId));
        retval.append("   ").append(XMLHandler.addTagValue((String)"pass_batchid", (boolean)this.batchIdPassed));
        retval.append("   ").append(XMLHandler.addTagValue((String)"use_logfield", (boolean)this.logfieldUsed));
        retval.append("   ").append(XMLHandler.addTagValue((String)"shared_objects_file", (String)this.sharedObjectsFile));
        retval.append("  <entries>").append(Const.CR);
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jge = this.getJobEntry(i);
            retval.append(jge.getXML());
        }
        retval.append("  </entries>").append(Const.CR);
        retval.append("  <hops>").append(Const.CR);
        for (JobHopMeta hi : this.jobhops) {
            retval.append(hi.getXML());
        }
        retval.append("  </hops>").append(Const.CR);
        retval.append("  <notepads>").append(Const.CR);
        for (int i2 = 0; i2 < this.nrNotes(); ++i2) {
            NotePadMeta ni = this.getNote(i2);
            retval.append(ni.getXML());
        }
        retval.append("  </notepads>").append(Const.CR);
        retval.append("</").append(XML_TAG).append(">").append(Const.CR);
        return retval.toString();
    }

    public JobMeta(LogWriter log, String fname, Repository rep) throws KettleXMLException {
        this(log, null, fname, rep, null);
    }

    public JobMeta(LogWriter log, String fname, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this(log, null, fname, rep, prompter);
    }

    public JobMeta(LogWriter log, VariableSpace parentSpace, String fname, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this.log = log;
        this.initializeVariablesFrom(parentSpace);
        try {
            Document doc = XMLHandler.loadXMLFile((FileObject)KettleVFS.getFileObject((String)fname));
            if (doc == null) {
                throw new KettleXMLException(Messages.getString("JobMeta.Exception.ErrorReadingFromXMLFile") + fname);
            }
            this.clear();
            Node jobnode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            this.loadXML(jobnode, rep, prompter);
            this.setFilename(fname);
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobMeta.Exception.UnableToLoadJobFromXMLFile") + fname + "]", (Throwable)e);
        }
    }

    public JobMeta(LogWriter log, Node jobnode, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        this.log = log;
        this.loadXML(jobnode, rep, prompter);
    }

    public boolean isRepReference() {
        return JobMeta.isRepReference(this.getFilename(), this.getName());
    }

    public boolean isFileReference() {
        return !JobMeta.isRepReference(this.getFilename(), this.getName());
    }

    public static boolean isRepReference(String fileName, String transName) {
        return Const.isEmpty((String)fileName) && !Const.isEmpty((String)transName);
    }

    public static boolean isFileReference(String fileName, String transName) {
        return !JobMeta.isRepReference(fileName, transName);
    }

    public void loadXML(Node jobnode, Repository rep, OverwritePrompter prompter) throws KettleXMLException {
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        try {
            String directoryPath;
            this.clear();
            this.setName(XMLHandler.getTagValue((Node)jobnode, (String)"name"));
            if (rep != null && (directoryPath = XMLHandler.getTagValue((Node)jobnode, (String)"directory")) != null) {
                this.directory = rep.getDirectoryTree().findDirectory(directoryPath);
                if (this.directory == null) {
                    this.directory = new RepositoryDirectory();
                }
            }
            this.description = XMLHandler.getTagValue((Node)jobnode, (String)"description");
            this.extendedDescription = XMLHandler.getTagValue((Node)jobnode, (String)"extended_description");
            this.jobVersion = XMLHandler.getTagValue((Node)jobnode, (String)"job_version");
            this.jobStatus = Const.toInt((String)XMLHandler.getTagValue((Node)jobnode, (String)"job_status"), (int)-1);
            this.created_user = XMLHandler.getTagValue((Node)jobnode, (String)"created_user");
            String createDate = XMLHandler.getTagValue((Node)jobnode, (String)"created_date");
            if (createDate != null) {
                this.created_date = XMLHandler.stringToDate((String)createDate);
            }
            this.modifiedUser = XMLHandler.getTagValue((Node)jobnode, (String)"modified_user");
            String modDate = XMLHandler.getTagValue((Node)jobnode, (String)"modified_date");
            if (modDate != null) {
                this.modifiedDate = XMLHandler.stringToDate((String)modDate);
            }
            try {
                this.sharedObjectsFile = XMLHandler.getTagValue((Node)jobnode, (String)"shared_objects_file");
                this.sharedObjects = this.readSharedObjects(rep);
            }
            catch (Exception e) {
                LogWriter.getInstance().logError(this.toString(), Messages.getString("JobMeta.ErrorReadingSharedObjects.Message", e.toString()), new Object[0]);
                LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            Node paramsNode = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG_PARAMETERS);
            int nrParams = XMLHandler.countNodes((Node)paramsNode, (String)"parameter");
            for (int i = 0; i < nrParams; ++i) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramsNode, (String)"parameter", (int)i);
                String paramName = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                String defValue = XMLHandler.getTagValue((Node)paramNode, (String)"default_value");
                String descr = XMLHandler.getTagValue((Node)paramNode, (String)"description");
                this.addParameterDefinition(paramName, defValue, descr);
            }
            int nr = XMLHandler.countNodes((Node)jobnode, (String)"connection");
            for (int i = 0; i < nr; ++i) {
                boolean overwrite;
                Node dbnode = XMLHandler.getSubNodeByNr((Node)jobnode, (String)"connection", (int)i);
                DatabaseMeta dbcon = new DatabaseMeta(dbnode);
                dbcon.shareVariablesWith((VariableSpace)this);
                DatabaseMeta exist = this.findDatabase(dbcon.getName());
                if (exist == null) {
                    this.addDatabase(dbcon);
                    continue;
                }
                if (exist.isShared()) continue;
                boolean askOverwrite = Props.isInitialized() ? props.askAboutReplacingDatabaseConnections() : false;
                boolean bl = overwrite = Props.isInitialized() ? props.replaceExistingDatabaseConnections() : true;
                if (askOverwrite && prompter != null) {
                    overwrite = prompter.overwritePrompt(Messages.getString("JobMeta.Dialog.ConnectionExistsOverWrite.Message", dbcon.getName()), Messages.getString("JobMeta.Dialog.ConnectionExistsOverWrite.DontShowAnyMoreMessage"), "AskAboutReplacingDatabases");
                }
                if (!overwrite) continue;
                int idx = this.indexOfDatabase(exist);
                this.removeDatabase(idx);
                this.addDatabase(idx, dbcon);
            }
            Node slaveServersNode = XMLHandler.getSubNode((Node)jobnode, (String)XML_TAG_SLAVESERVERS);
            int nrSlaveServers = XMLHandler.countNodes((Node)slaveServersNode, (String)"slaveserver");
            for (int i = 0; i < nrSlaveServers; ++i) {
                Node slaveServerNode = XMLHandler.getSubNodeByNr((Node)slaveServersNode, (String)"slaveserver", (int)i);
                SlaveServer slaveServer = new SlaveServer(slaveServerNode);
                slaveServer.shareVariablesWith(this);
                SlaveServer check = this.findSlaveServer(slaveServer.getName());
                if (check != null) {
                    if (check.isShared()) continue;
                    this.addOrReplaceSlaveServer(slaveServer);
                    continue;
                }
                this.slaveServers.add(slaveServer);
            }
            String logcon = XMLHandler.getTagValue((Node)jobnode, (String)"logconnection");
            this.logConnection = this.findDatabase(logcon);
            this.logTable = XMLHandler.getTagValue((Node)jobnode, (String)"logtable");
            this.useBatchId = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"use_batchid"));
            this.batchIdPassed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"pass_batchid"));
            this.logfieldUsed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)jobnode, (String)"use_logfield"));
            this.logSizeLimit = XMLHandler.getTagValue((Node)jobnode, (String)"size_limit_lines");
            Node entriesnode = XMLHandler.getSubNode((Node)jobnode, (String)"entries");
            int tr = XMLHandler.countNodes((Node)entriesnode, (String)"entry");
            for (int i = 0; i < tr; ++i) {
                Node entrynode = XMLHandler.getSubNodeByNr((Node)entriesnode, (String)"entry", (int)i);
                JobEntryCopy je = new JobEntryCopy(entrynode, this.databases, this.slaveServers, rep);
                JobEntryCopy prev = this.findJobEntry(je.getName(), 0, true);
                if (prev != null) {
                    int idx;
                    if (je.getNr() == 0) {
                        idx = this.indexOfJobEntry(prev);
                        this.removeJobEntry(idx);
                    } else if (je.getNr() > 0) {
                        je.setEntry(prev.getEntry());
                        prev = this.findJobEntry(je.getName(), je.getNr(), true);
                        if (prev != null) {
                            idx = this.indexOfJobEntry(prev);
                            this.removeJobEntry(idx);
                        }
                    }
                }
                this.addJobEntry(je);
            }
            Node hopsnode = XMLHandler.getSubNode((Node)jobnode, (String)"hops");
            int ho = XMLHandler.countNodes((Node)hopsnode, (String)"hop");
            for (int i = 0; i < ho; ++i) {
                Node hopnode = XMLHandler.getSubNodeByNr((Node)hopsnode, (String)"hop", (int)i);
                JobHopMeta hi = new JobHopMeta(hopnode, this);
                this.jobhops.add(hi);
            }
            Node notepadsnode = XMLHandler.getSubNode((Node)jobnode, (String)"notepads");
            int nrnotes = XMLHandler.countNodes((Node)notepadsnode, (String)"notepad");
            for (int i = 0; i < nrnotes; ++i) {
                Node notepadnode = XMLHandler.getSubNodeByNr((Node)notepadsnode, (String)"notepad", (int)i);
                NotePadMeta ni = new NotePadMeta(notepadnode);
                this.notes.add(ni);
            }
            this.clearChanged();
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobMeta.Exception.UnableToLoadJobFromXMLNode"), (Throwable)e);
        }
        finally {
            this.setInternalKettleVariables();
        }
    }

    public void readDatabases(Repository rep) throws KettleException {
        this.readDatabases(rep, true);
    }

    @Override
    public void readDatabases(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getDatabaseIDs();
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta databaseMeta = RepositoryUtil.loadDatabaseMeta(rep, dbids[i]);
                databaseMeta.shareVariablesWith((VariableSpace)this);
                DatabaseMeta check = this.findDatabase(databaseMeta.getName());
                if (check != null && !overWriteShared || databaseMeta.getName() == null) continue;
                this.addOrReplaceDatabase(databaseMeta);
                if (overWriteShared) continue;
                databaseMeta.setChanged(false);
            }
            this.setChanged(false);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobMeta.Log.UnableToReadDatabaseIDSFromRepository"), (Throwable)dbe);
        }
        catch (KettleException ke) {
            throw new KettleException(Messages.getString("JobMeta.Log.UnableToReadDatabasesFromRepository"), (Throwable)ke);
        }
    }

    public void readSlaves(Repository rep, boolean overWriteShared) throws KettleException {
        try {
            long[] dbids = rep.getSlaveIDs();
            for (int i = 0; i < dbids.length; ++i) {
                SlaveServer slaveServer = new SlaveServer(rep, dbids[i]);
                slaveServer.shareVariablesWith(this);
                SlaveServer check = this.findSlaveServer(slaveServer.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)slaveServer.getName())) continue;
                this.addOrReplaceSlaveServer(slaveServer);
                if (overWriteShared) continue;
                slaveServer.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobMeta.Log.UnableToReadSlaveServersFromRepository"), (Throwable)dbe);
        }
    }

    public SharedObjects readSharedObjects(Repository rep) throws KettleException {
        String soFile = this.environmentSubstitute(this.sharedObjectsFile);
        SharedObjects sharedObjects = new SharedObjects(soFile);
        Map<SharedObjects.SharedEntry, SharedObjectInterface> objectsMap = sharedObjects.getObjectsMap();
        for (SharedObjectInterface object : objectsMap.values()) {
            if (object instanceof DatabaseMeta) {
                DatabaseMeta databaseMeta = (DatabaseMeta)object;
                databaseMeta.shareVariablesWith((VariableSpace)this);
                this.addOrReplaceDatabase(databaseMeta);
                continue;
            }
            if (!(object instanceof SlaveServer)) continue;
            SlaveServer slaveServer = (SlaveServer)object;
            slaveServer.shareVariablesWith(this);
            this.addOrReplaceSlaveServer(slaveServer);
        }
        if (rep != null) {
            this.readDatabases(rep, true);
            this.readSlaves(rep, true);
        }
        return sharedObjects;
    }

    @Override
    public boolean saveSharedObjects() {
        try {
            String soFile = this.environmentSubstitute(this.sharedObjectsFile);
            SharedObjects sharedObjects = new SharedObjects(soFile);
            ArrayList<Object> shared = new ArrayList<Object>();
            shared.addAll(this.databases);
            shared.addAll(this.slaveServers);
            for (int i = 0; i < shared.size(); ++i) {
                SharedObjectInterface sharedObject = (SharedObjectInterface)shared.get(i);
                if (!sharedObject.isShared()) continue;
                sharedObjects.storeObject(sharedObject);
            }
            sharedObjects.saveToFile();
            return true;
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Unable to save shared ojects: " + e.toString(), new Object[0]);
            return false;
        }
    }

    @Override
    public DatabaseMeta findDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.getName().equalsIgnoreCase(name)) continue;
            return ci;
        }
        return null;
    }

    public void saveRep(Repository rep) throws KettleException {
        this.saveRep(rep, null);
    }

    @Override
    public void saveRep(Repository rep, ProgressMonitorListener monitor) throws KettleException {
        try {
            int i;
            int nrWorks = 2 + this.nrDatabases() + this.nrNotes() + this.nrJobEntries() + this.nrJobHops();
            if (monitor != null) {
                monitor.beginTask(Messages.getString("JobMeta.Monitor.SavingTransformation") + this.directory + Const.FILE_SEPARATOR + this.getName(), nrWorks);
            }
            rep.lockRepository();
            rep.insertLogEntry("save job '" + this.getName() + "'");
            if (monitor != null) {
                monitor.subTask(Messages.getString("JobMeta.Monitor.HandlingPreviousVersionOfJob"));
            }
            this.setID(rep.getJobID(this.getName(), this.directory.getID()));
            if (this.getID() <= 0L) {
                this.setID(rep.getNextJobID());
            } else {
                rep.delAllFromJob(this.getID());
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("JobMeta.Log.SavingDatabaseConnections"), new Object[0]);
            }
            for (i = 0; i < this.nrDatabases(); ++i) {
                DatabaseMeta databaseMeta;
                if (monitor != null) {
                    monitor.subTask(Messages.getString("JobMeta.Monitor.SavingDatabaseTask.Title") + (i + 1) + "/" + this.nrDatabases());
                }
                if ((databaseMeta = this.getDatabase(i)).hasChanged() || databaseMeta.getID() <= 0L) {
                    RepositoryUtil.saveDatabaseMeta(databaseMeta, rep);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask(Messages.getString("JobMeta.Monitor.SavingJobDetails"));
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Saving job info to repository...", new Object[0]);
            }
            this.saveRepJob(rep);
            if (monitor != null) {
                monitor.worked(1);
            }
            for (i = 0; i < this.slaveServers.size(); ++i) {
                SlaveServer slaveServer = this.slaveServers.get(i);
                slaveServer.saveRep(rep, this.getID(), false);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Saving notes to repository...", new Object[0]);
            }
            for (i = 0; i < this.nrNotes(); ++i) {
                if (monitor != null) {
                    monitor.subTask(Messages.getString("JobMeta.Monitor.SavingNoteNr") + (i + 1) + "/" + this.nrNotes());
                }
                NotePadMeta ni = this.getNote(i);
                ni.saveRep(rep, this.getID());
                if (ni.getID() > 0L) {
                    rep.insertJobNote(this.getID(), ni.getID());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Saving " + this.nrJobEntries() + " Job enty copies to repository...", new Object[0]);
            }
            rep.updateJobEntryTypes();
            for (i = 0; i < this.nrJobEntries(); ++i) {
                if (monitor != null) {
                    monitor.subTask(Messages.getString("JobMeta.Monitor.SavingJobEntryNr") + (i + 1) + "/" + this.nrJobEntries());
                }
                JobEntryCopy cge = this.getJobEntry(i);
                cge.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Saving job hops to repository...", new Object[0]);
            }
            for (i = 0; i < this.nrJobHops(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving job hop #" + (i + 1) + "/" + this.nrJobHops());
                }
                JobHopMeta hi = this.getJobHop(i);
                hi.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            this.saveRepParameters(rep);
            rep.commit();
            this.clearChanged();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (KettleDatabaseException dbe) {
            rep.rollback();
            throw new KettleException(Messages.getString("JobMeta.Exception.UnableToSaveJobInRepositoryRollbackPerformed"), (Throwable)dbe);
        }
        finally {
            rep.unlockRepository();
        }
    }

    public JobMeta(LogWriter log, Repository rep, String jobname, RepositoryDirectory repdir) throws KettleException {
        this(log, rep, jobname, repdir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobMeta(LogWriter log, Repository rep, String jobname, RepositoryDirectory repdir, ProgressMonitorListener monitor) throws KettleException {
        this.log = log;
        Repository repository = rep;
        synchronized (repository) {
            block33: {
                try {
                    this.clear();
                    this.directory = repdir;
                    this.setID(rep.getJobID(jobname, repdir.getID()));
                    if (this.getID() > 0L) {
                        int i;
                        long[] noteids = rep.getJobNoteIDs(this.getID());
                        long[] jecids = rep.getJobEntryCopyIDs(this.getID());
                        long[] hopid = rep.getJobHopIDs(this.getID());
                        int nrWork = 2 + noteids.length + jecids.length + hopid.length;
                        if (monitor != null) {
                            monitor.beginTask(Messages.getString("JobMeta.Monitor.LoadingJob") + repdir + Const.FILE_SEPARATOR + jobname, nrWork);
                        }
                        if (monitor != null) {
                            monitor.subTask(Messages.getString("JobMeta.Monitor.ReadingJobInformation"));
                        }
                        RowMetaAndData jobRow = rep.getJob(this.getID());
                        this.setName(jobRow.getString("NAME", null));
                        this.description = jobRow.getString("DESCRIPTION", null);
                        this.extendedDescription = jobRow.getString("EXTENDED_DESCRIPTION", null);
                        this.jobVersion = jobRow.getString("JOB_VERSION", null);
                        this.jobStatus = Const.toInt((String)jobRow.getString("JOB_STATUS", null), (int)-1);
                        this.logTable = jobRow.getString("TABLE_NAME_LOG", null);
                        this.created_user = jobRow.getString("CREATED_USER", null);
                        this.created_date = jobRow.getDate("CREATED_DATE", new Date());
                        this.modifiedUser = jobRow.getString("MODIFIED_USER", null);
                        this.modifiedDate = jobRow.getDate("MODIFIED_DATE", new Date());
                        long id_logdb = jobRow.getInteger("ID_DATABASE_LOG", 0L);
                        if (id_logdb > 0L) {
                            this.logConnection = RepositoryUtil.loadDatabaseMeta(rep, id_logdb);
                            this.logConnection.shareVariablesWith((VariableSpace)this);
                        }
                        this.useBatchId = jobRow.getBoolean("USE_BATCH_ID", false);
                        this.batchIdPassed = jobRow.getBoolean("PASS_BATCH_ID", false);
                        this.logfieldUsed = jobRow.getBoolean("USE_LOGFIELD", false);
                        this.logSizeLimit = rep.getJobAttributeString(this.getID(), 0, "LOG_SIZE_LIMIT");
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        if (monitor != null) {
                            monitor.subTask(Messages.getString("JobMeta.Monitor.ReadingAvailableDatabasesFromRepository"));
                        }
                        try {
                            this.sharedObjectsFile = jobRow.getString("SHARED_FILE", null);
                            this.sharedObjects = this.readSharedObjects(rep);
                        }
                        catch (Exception e) {
                            LogWriter.getInstance().logError(this.toString(), Messages.getString("JobMeta.ErrorReadingSharedObjects.Message", e.toString()), new Object[0]);
                            LogWriter.getInstance().logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "Loading " + noteids.length + " notes", new Object[0]);
                        }
                        for (i = 0; i < noteids.length; ++i) {
                            NotePadMeta ni;
                            if (monitor != null) {
                                monitor.subTask(Messages.getString("JobMeta.Monitor.ReadingNoteNr") + (i + 1) + "/" + noteids.length);
                            }
                            if (this.indexOfNote(ni = new NotePadMeta(log, rep, noteids[i])) < 0) {
                                this.addNote(ni);
                            }
                            if (monitor == null) continue;
                            monitor.worked(1);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "Loading " + jecids.length + " job entries", new Object[0]);
                        }
                        for (i = 0; i < jecids.length; ++i) {
                            if (monitor != null) {
                                monitor.subTask(Messages.getString("JobMeta.Monitor.ReadingJobEntryNr") + (i + 1) + "/" + jecids.length);
                            }
                            JobEntryCopy jec = new JobEntryCopy(log, rep, this.getID(), jecids[i], this.jobentries, this.databases, this.slaveServers);
                            int copyNr = 0;
                            for (JobEntryCopy copy : this.jobcopies) {
                                if (jec.getEntry() != copy.getEntry()) continue;
                                ++copyNr;
                            }
                            jec.setNr(copyNr);
                            int idx = this.indexOfJobEntry(jec);
                            if (idx < 0) {
                                if (jec.getName() != null && jec.getName().length() > 0) {
                                    this.addJobEntry(jec);
                                }
                            } else {
                                this.setJobEntry(idx, jec);
                            }
                            if (monitor == null) continue;
                            monitor.worked(1);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "Loading " + hopid.length + " job hops", new Object[0]);
                        }
                        for (i = 0; i < hopid.length; ++i) {
                            if (monitor != null) {
                                monitor.subTask(Messages.getString("JobMeta.Monitor.ReadingJobHopNr") + (i + 1) + "/" + jecids.length);
                            }
                            JobHopMeta hi = new JobHopMeta(rep, hopid[i], this, this.jobcopies);
                            this.jobhops.add(hi);
                            if (monitor == null) continue;
                            monitor.worked(1);
                        }
                        this.loadRepParameters(rep);
                        this.clearChanged();
                        if (monitor != null) {
                            monitor.subTask(Messages.getString("JobMeta.Monitor.FinishedLoadOfJob"));
                        }
                        if (monitor != null) {
                            monitor.done();
                        }
                        break block33;
                    }
                    throw new KettleException(Messages.getString("JobMeta.Exception.CanNotFindJob") + jobname);
                }
                catch (KettleException dbe) {
                    throw new KettleException(Messages.getString("JobMeta.Exception.AnErrorOccuredReadingJob", jobname), (Throwable)dbe);
                }
                finally {
                    this.initializeVariablesFrom(this.getParentVariableSpace());
                    this.setInternalKettleVariables();
                }
            }
        }
    }

    public JobEntryCopy getJobEntryCopy(int x, int y, int iconsize) {
        int s = this.nrJobEntries();
        for (int i = s - 1; i >= 0; --i) {
            JobEntryCopy je = this.getJobEntry(i);
            Point p = je.getLocation();
            if (p == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize) continue;
            return je;
        }
        return null;
    }

    public int nrJobEntries() {
        return this.jobcopies.size();
    }

    public int nrJobHops() {
        return this.jobhops.size();
    }

    public int nrNotes() {
        return this.notes.size();
    }

    @Override
    public int nrDatabases() {
        return this.databases.size();
    }

    public JobHopMeta getJobHop(int i) {
        return this.jobhops.get(i);
    }

    public JobEntryCopy getJobEntry(int i) {
        return this.jobcopies.get(i);
    }

    public NotePadMeta getNote(int i) {
        return this.notes.get(i);
    }

    @Override
    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public void addJobEntry(JobEntryCopy je) {
        this.jobcopies.add(je);
        this.setChanged();
    }

    public void addJobHop(JobHopMeta hi) {
        this.jobhops.add(hi);
        this.setChanged();
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.setChanged();
    }

    @Override
    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
        Collections.sort(this.databases, DatabaseMeta.comparator);
        this.changedDatabases = true;
    }

    public void addJobEntry(int p, JobEntryCopy si) {
        this.jobcopies.add(p, si);
        this.changedEntries = true;
    }

    public void addJobHop(int p, JobHopMeta hi) {
        this.jobhops.add(p, hi);
        this.changedHops = true;
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changedNotes = true;
    }

    @Override
    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
        this.changedDatabases = true;
    }

    @Override
    public void addOrReplaceDatabase(DatabaseMeta databaseMeta) {
        int index = this.databases.indexOf(databaseMeta);
        if (index < 0) {
            this.addDatabase(databaseMeta);
        } else {
            DatabaseMeta previous = this.getDatabase(index);
            previous.replaceMeta(databaseMeta);
        }
        this.changedDatabases = true;
    }

    public void addOrReplaceSlaveServer(SlaveServer slaveServer) {
        int index = this.slaveServers.indexOf(slaveServer);
        if (index < 0) {
            this.slaveServers.add(slaveServer);
        } else {
            SlaveServer previous = this.slaveServers.get(index);
            previous.replaceMeta(slaveServer);
        }
        this.setChanged();
    }

    public void removeJobEntry(int i) {
        this.jobcopies.remove(i);
        this.setChanged();
    }

    public void removeJobHop(int i) {
        this.jobhops.remove(i);
        this.setChanged();
    }

    public void removeNote(int i) {
        this.notes.remove(i);
        this.setChanged();
    }

    public void raiseNote(int p) {
        if (p >= 0 && p < this.notes.size() - 1) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(note);
            this.changedNotes = true;
        }
    }

    public void lowerNote(int p) {
        if (p > 0 && p < this.notes.size()) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(0, note);
            this.changedNotes = true;
        }
    }

    @Override
    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.changedDatabases = true;
    }

    public int indexOfJobHop(JobHopMeta he) {
        return this.jobhops.indexOf(he);
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    public int indexOfJobEntry(JobEntryCopy ge) {
        return this.jobcopies.indexOf(ge);
    }

    @Override
    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    public void setJobEntry(int idx, JobEntryCopy jec) {
        this.jobcopies.set(idx, jec);
    }

    public JobEntryCopy findJobEntry(String name, int nr, boolean searchHiddenToo) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            if (!jec.getName().equalsIgnoreCase(name) || jec.getNr() != nr || !searchHiddenToo && !jec.isDrawn()) continue;
            return jec;
        }
        return null;
    }

    public JobEntryCopy findJobEntry(String full_name_nr) {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jec = this.getJobEntry(i);
            JobEntryInterface je = jec.getEntry();
            if (!je.toString().equalsIgnoreCase(full_name_nr)) continue;
            return jec;
        }
        return null;
    }

    public JobHopMeta findJobHop(String name) {
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopFrom(JobEntryCopy jge) {
        if (jge != null) {
            for (JobHopMeta hi : this.jobhops) {
                if (hi == null || hi.from_entry == null || !hi.from_entry.equals(jge)) continue;
                return hi;
            }
        }
        return null;
    }

    public JobHopMeta findJobHop(JobEntryCopy from, JobEntryCopy to) {
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || hi == null || hi.from_entry == null || hi.to_entry == null || !hi.from_entry.equals(from) || !hi.to_entry.equals(to)) continue;
            return hi;
        }
        return null;
    }

    public JobHopMeta findJobHopTo(JobEntryCopy jge) {
        for (JobHopMeta hi : this.jobhops) {
            if (hi == null || hi.to_entry == null || !hi.to_entry.equals(jge)) continue;
            return hi;
        }
        return null;
    }

    public int findNrPrevJobEntries(JobEntryCopy from) {
        return this.findNrPrevJobEntries(from, false);
    }

    public JobEntryCopy findPrevJobEntry(JobEntryCopy to, int nr) {
        return this.findPrevJobEntry(to, nr, false);
    }

    public int findNrPrevJobEntries(JobEntryCopy to, boolean info) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || !hi.to_entry.equals(to)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findPrevJobEntry(JobEntryCopy to, int nr, boolean info) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || !hi.to_entry.equals(to)) continue;
            if (count == nr) {
                return hi.from_entry;
            }
            ++count;
        }
        return null;
    }

    public int findNrNextJobEntries(JobEntryCopy from) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || hi.from_entry == null || !hi.from_entry.equals(from)) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy findNextJobEntry(JobEntryCopy from, int cnt) {
        int count = 0;
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.isEnabled() || hi.from_entry == null || !hi.from_entry.equals(from)) continue;
            if (count == cnt) {
                return hi.to_entry;
            }
            ++count;
        }
        return null;
    }

    public boolean hasLoop(JobEntryCopy entry) {
        return this.hasLoop(entry, null);
    }

    public boolean hasLoop(JobEntryCopy entry, JobEntryCopy lookup) {
        return false;
    }

    public boolean isEntryUsedInHops(JobEntryCopy jge) {
        JobHopMeta fr = this.findJobHopFrom(jge);
        JobHopMeta to = this.findJobHopTo(jge);
        return fr != null || to != null;
    }

    public int countEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    public int generateJobEntryNameNr(String basename) {
        int nr = 1;
        JobEntryCopy e = this.findJobEntry(basename + " " + nr, 0, true);
        while (e != null) {
            e = this.findJobEntry(basename + " " + ++nr, 0, true);
        }
        return nr;
    }

    public int findUnusedNr(String name) {
        int nr = 1;
        JobEntryCopy je = this.findJobEntry(name, nr, true);
        while (je != null) {
            je = this.findJobEntry(name, ++nr, true);
        }
        return nr;
    }

    public int findMaxNr(String name) {
        int max = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name) || je.getNr() <= max) continue;
            max = je.getNr();
        }
        return max;
    }

    public String getAlternativeJobentryName(String entryname) {
        String newname = entryname;
        JobEntryCopy jec = this.findJobEntry(newname);
        int nr = 1;
        while (jec != null) {
            newname = entryname + " " + ++nr;
            jec = this.findJobEntry(newname);
        }
        return newname;
    }

    public JobEntryCopy[] getAllJobGraphEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        JobEntryCopy[] retval = new JobEntryCopy[count];
        count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.getName().equalsIgnoreCase(name)) continue;
            retval[count] = je;
            ++count;
        }
        return retval;
    }

    public JobHopMeta[] getAllJobHopsUsing(String name) {
        ArrayList<JobHopMeta> hops = new ArrayList<JobHopMeta>();
        for (JobHopMeta hi : this.jobhops) {
            if (hi.from_entry == null || hi.to_entry == null || !hi.from_entry.getName().equalsIgnoreCase(name) && !hi.to_entry.getName().equalsIgnoreCase(name)) continue;
            hops.add(hi);
        }
        return hops.toArray(new JobHopMeta[hops.size()]);
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public void selectAll() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy ce = this.getJobEntry(i);
            ce.setSelected(false);
        }
    }

    @Override
    public int getMaxUndo() {
        return this.max_undo;
    }

    @Override
    public void setMaxUndo(int mu) {
        this.max_undo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    public int getUndoSize() {
        if (this.undo == null) {
            return 0;
        }
        return this.undo.size();
    }

    public void clearUndo() {
        this.undo = new ArrayList<TransAction>();
        this.undo_position = -1;
    }

    @Override
    public void addUndo(Object[] from, Object[] to, int[] pos, Point[] prev, Point[] curr, int type_of_change, boolean nextAlso) {
        while (this.undo.size() > this.undo_position + 1 && this.undo.size() > 0) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        TransAction ta = new TransAction();
        switch (type_of_change) {
            case 1: {
                ta.setChanged(from, to, pos);
                break;
            }
            case 3: {
                ta.setDelete(from, pos);
                break;
            }
            case 2: {
                ta.setNew(from, pos);
                break;
            }
            case 4: {
                ta.setPosition(from, pos, prev, curr);
            }
        }
        this.undo.add(ta);
        ++this.undo_position;
        if (this.undo.size() > this.max_undo) {
            this.undo.remove(0);
            --this.undo_position;
        }
    }

    @Override
    public TransAction previousUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        --this.undo_position;
        return retval;
    }

    @Override
    public TransAction viewThisUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        ++this.undo_position;
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position + 1);
        return retval;
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            loc = entry.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            loc = ni.getLocation();
            if (loc.x + ni.width > maxx) {
                maxx = loc.x + ni.width;
            }
            if (loc.y + ni.height <= maxy) continue;
            maxy = loc.y + ni.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point[] getSelectedLocations() {
        int sels = this.nrSelected();
        Point[] retval = new Point[sels];
        for (int i = 0; i < sels; ++i) {
            JobEntryCopy si = this.getSelected(i);
            Point p = si.getLocation();
            retval[i] = new Point(p.x, p.y);
        }
        return retval;
    }

    public JobEntryCopy[] getSelectedEntries() {
        int sels = this.nrSelected();
        if (sels == 0) {
            return null;
        }
        JobEntryCopy[] retval = new JobEntryCopy[sels];
        for (int i = 0; i < sels; ++i) {
            JobEntryCopy je;
            retval[i] = je = this.getSelected(i);
        }
        return retval;
    }

    public int nrSelected() {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.isSelected() || !je.isDrawn()) continue;
            ++count;
        }
        return count;
    }

    public JobEntryCopy getSelected(int nr) {
        int count = 0;
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy je = this.getJobEntry(i);
            if (!je.isSelected()) continue;
            if (nr == count) {
                return je;
            }
            ++count;
        }
        return null;
    }

    public int[] getEntryIndexes(JobEntryCopy[] entries) {
        int[] retval = new int[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            retval[i] = this.indexOfJobEntry(entries[i]);
        }
        return retval;
    }

    public JobEntryCopy findStart() {
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            if (!this.getJobEntry(i).isStart()) continue;
            return this.getJobEntry(i);
        }
        return null;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.filename != null) {
            return this.filename;
        }
        return this.getClass().getName();
    }

    public boolean isLogfieldUsed() {
        return this.logfieldUsed;
    }

    public void setLogfieldUsed(boolean logfieldUsed) {
        this.logfieldUsed = logfieldUsed;
    }

    public boolean isBatchIdUsed() {
        return this.useBatchId;
    }

    public void setUseBatchId(boolean useBatchId) {
        this.useBatchId = useBatchId;
    }

    public boolean isBatchIdPassed() {
        return this.batchIdPassed;
    }

    public void setBatchIdPassed(boolean batchIdPassed) {
        this.batchIdPassed = batchIdPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLStatement> getSQLStatements(Repository repository, ProgressMonitorListener monitor) throws KettleException {
        if (monitor != null) {
            monitor.beginTask(Messages.getString("JobMeta.Monitor.GettingSQLNeededForThisJob"), this.nrJobEntries() + 1);
        }
        ArrayList<SQLStatement> stats = new ArrayList<SQLStatement>();
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy copy = this.getJobEntry(i);
            if (monitor != null) {
                monitor.subTask(Messages.getString("JobMeta.Monitor.GettingSQLForJobEntryCopy") + copy + "]");
            }
            List<SQLStatement> list = copy.getEntry().getSQLStatements(repository, this);
            stats.addAll(list);
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask(Messages.getString("JobMeta.Monitor.GettingSQLStatementsForJobLogTables"));
        }
        if (this.logConnection != null && this.logTable != null && this.logTable.length() > 0) {
            Database db = new Database(this.logConnection);
            try {
                db.connect();
                RowMetaInterface fields = Database.getJobLogrecordFields((boolean)false, (boolean)this.useBatchId, (boolean)this.logfieldUsed);
                String sql = db.getDDL(this.logTable, fields);
                if (sql != null && sql.length() > 0) {
                    SQLStatement stat = new SQLStatement(Messages.getString("JobMeta.SQLFeedback.ThisJob"), this.logConnection, sql);
                    stats.add(stat);
                }
            }
            catch (KettleDatabaseException dbe) {
                SQLStatement stat = new SQLStatement(Messages.getString("JobMeta.SQLFeedback.ThisJob"), this.logConnection, null);
                stat.setError(Messages.getString("JobMeta.SQLFeedback.ErrorObtainingJobLogTableInfo") + dbe.getMessage());
                stats.add(stat);
            }
            finally {
                db.disconnect();
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    public String getLogTable() {
        return this.logTable;
    }

    public void setLogTable(String logTable) {
        this.logTable = logTable;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes) {
        Object meta;
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchSteps) {
            for (i = 0; i < this.nrJobEntries(); ++i) {
                JobEntryCopy entryMeta = this.getJobEntry(i);
                stringList.add(new StringSearchResult(entryMeta.getName(), entryMeta, this, Messages.getString("JobMeta.SearchMetadata.JobEntryName")));
                if (entryMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(entryMeta.getDescription(), entryMeta, this, Messages.getString("JobMeta.SearchMetadata.JobEntryDescription")));
                }
                JobEntryInterface metaInterface = entryMeta.getEntry();
                StringSearcher.findMetaData(metaInterface, 1, stringList, entryMeta, this);
            }
        }
        if (searchDatabases) {
            for (i = 0; i < this.nrDatabases(); ++i) {
                meta = this.getDatabase(i);
                stringList.add(new StringSearchResult(meta.getName(), meta, this, Messages.getString("JobMeta.SearchMetadata.DatabaseConnectionName")));
                if (meta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseName(), meta, this, Messages.getString("JobMeta.SearchMetadata.DatabaseName")));
                }
                if (meta.getUsername() != null) {
                    stringList.add(new StringSearchResult(meta.getUsername(), meta, this, Messages.getString("JobMeta.SearchMetadata.DatabaseUsername")));
                }
                if (meta.getDatabaseTypeDesc() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseTypeDesc(), meta, this, Messages.getString("JobMeta.SearchMetadata.DatabaseTypeDescription")));
                }
                if (meta.getDatabasePortNumberString() == null) continue;
                stringList.add(new StringSearchResult(meta.getDatabasePortNumberString(), meta, this, Messages.getString("JobMeta.SearchMetadata.DatabasePort")));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                meta = this.getNote(i);
                if (((NotePadMeta)meta).getNote() == null) continue;
                stringList.add(new StringSearchResult(((NotePadMeta)meta).getNote(), meta, this, Messages.getString("JobMeta.SearchMetadata.NotepadText")));
            }
        }
        return stringList;
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false);
        ArrayList<String> varList = new ArrayList<String>();
        for (StringSearchResult result : stringList) {
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    public List<GUIPositionInterface> getSelectedDrawnJobEntryList() {
        ArrayList<GUIPositionInterface> list = new ArrayList<GUIPositionInterface>();
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy jobEntryCopy = this.getJobEntry(i);
            if (!jobEntryCopy.isDrawn() || !jobEntryCopy.isSelected()) continue;
            list.add(jobEntryCopy);
        }
        return list;
    }

    @Override
    public boolean haveConnectionsChanged() {
        if (this.changedDatabases) {
            return true;
        }
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveJobEntriesChanged() {
        if (this.changedEntries) {
            return true;
        }
        for (int i = 0; i < this.nrJobEntries(); ++i) {
            JobEntryCopy entry = this.getJobEntry(i);
            if (!entry.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveJobHopsChanged() {
        if (this.changedHops) {
            return true;
        }
        for (JobHopMeta hi : this.jobhops) {
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveNotesChanged() {
        if (this.changedNotes) {
            return true;
        }
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta note = this.getNote(i);
            if (!note.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String getSharedObjectsFile() {
        return this.sharedObjectsFile;
    }

    public void setSharedObjectsFile(String sharedObjectsFile) {
        this.sharedObjectsFile = sharedObjectsFile;
    }

    @Override
    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    @Override
    public String getModifiedUser() {
        return this.modifiedUser;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public String getJobversion() {
        return this.jobVersion;
    }

    public int getJobstatus() {
        return this.jobStatus;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
    }

    public void setJobversion(String jobVersion) {
        this.jobVersion = jobVersion;
    }

    public void setJobstatus(int jobStatus) {
        this.jobStatus = jobStatus;
    }

    @Override
    public Date getCreatedDate() {
        return this.created_date;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.created_date = createdDate;
    }

    @Override
    public void setCreatedUser(String createdUser) {
        this.created_user = createdUser;
    }

    @Override
    public String getCreatedUser() {
        return this.created_user;
    }

    public static final JobEntryInterface findJobEntry(List<JobEntryInterface> jobentries, long id_jobentry) {
        if (jobentries == null) {
            return null;
        }
        for (JobEntryInterface je : jobentries) {
            if (je.getID() != id_jobentry) continue;
            return je;
        }
        return null;
    }

    public static final JobEntryCopy findJobEntryCopy(List<JobEntryCopy> jobcopies, long id_jobentry_copy) {
        if (jobcopies == null) {
            return null;
        }
        for (JobEntryCopy jec : jobcopies) {
            if (jec.getID() != id_jobentry_copy) continue;
            return jec;
        }
        return null;
    }

    @Override
    public void setInternalKettleVariables() {
        this.setInternalKettleVariables(this.variables);
    }

    public void setInternalKettleVariables(VariableSpace var) {
        if (this.filename != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.filename);
                FileName fileName = fileObject.getName();
                var.setVariable("Internal.Job.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                var.setVariable("Internal.Job.Filename.Directory", fileDir.getURI());
            }
            catch (IOException e) {
                var.setVariable("Internal.Job.Filename.Directory", "");
                var.setVariable("Internal.Job.Filename.Name", "");
            }
        } else {
            var.setVariable("Internal.Job.Filename.Directory", "");
            var.setVariable("Internal.Job.Filename.Name", "");
        }
        var.setVariable("Internal.Job.Name", Const.NVL((String)this.name, (String)""));
        var.setVariable("Internal.Transformation.Repository.Directory", this.directory != null ? this.directory.getPath() : "");
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Filename.Directory", null);
        var.setVariable("Internal.Transformation.Filename.Name", null);
        var.setVariable("Internal.Transformation.Name", null);
        var.setVariable("Internal.Transformation.Repository.Directory", null);
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void checkJobEntries(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor) {
        remarks.clear();
        if (monitor != null) {
            monitor.beginTask(Messages.getString("JobMeta.Monitor.VerifyingThisJobEntryTask.Title"), this.jobcopies.size() + 2);
        }
        boolean stop_checking = false;
        for (int i = 0; i < this.jobcopies.size() && !stop_checking; ++i) {
            JobEntryInterface entry;
            JobEntryCopy copy = this.jobcopies.get(i);
            if ((!only_selected || only_selected && copy.isSelected()) && (entry = copy.getEntry()) != null) {
                if (monitor != null) {
                    monitor.subTask(Messages.getString("JobMeta.Monitor.VerifyingJobEntry.Title", entry.getName()));
                }
                entry.check(remarks, this);
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        stop_checking = true;
                    }
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public List<ResourceReference> getResourceDependencies() {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        JobEntryCopy copy = null;
        JobEntryInterface entry = null;
        for (int i = 0; i < this.jobcopies.size(); ++i) {
            copy = this.jobcopies.get(i);
            entry = copy.getEntry();
            resourceReferences.addAll(entry.getResourceDependencies(this));
        }
        return resourceReferences;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository) throws KettleException {
        String resourceName = null;
        try {
            String fullname;
            String baseName;
            String originalPath;
            String extension = "kjb";
            if (Const.isEmpty((String)this.getFilename())) {
                originalPath = this.directory.getPath();
                baseName = this.getName();
                fullname = this.directory.getPath() + (this.directory.getPath().endsWith("/") ? "" : "/") + this.getName() + "." + extension;
            } else {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.getFilename()));
                originalPath = fileObject.getParent().getName().getPath();
                baseName = fileObject.getName().getBaseName();
                fullname = fileObject.getName().getPath();
            }
            resourceName = namingInterface.nameResource(baseName, originalPath, extension, ResourceNamingInterface.FileNamingType.JOB);
            ResourceDefinition definition = definitions.get(resourceName);
            if (definition == null) {
                JobMeta jobMeta = (JobMeta)this.realClone(false);
                for (JobEntryCopy jobEntry : jobMeta.jobcopies) {
                    jobEntry.getEntry().exportResources(jobMeta, definitions, namingInterface, repository);
                }
                Map<String, String> directoryMap = namingInterface.getDirectoryMap();
                if (directoryMap != null) {
                    for (String directory : directoryMap.keySet()) {
                        String parameterName = directoryMap.get(directory);
                        jobMeta.addParameterDefinition(parameterName, directory, "Data file path discovered during export");
                    }
                }
                String jobMetaContent = jobMeta.getXML();
                definition = new ResourceDefinition(resourceName, jobMetaContent);
                if (Const.isEmpty((String)this.getFilename())) {
                    definition.setOrigin(fullname);
                } else {
                    definition.setOrigin(this.getFilename());
                }
                definitions.put(fullname, definition);
            }
        }
        catch (FileSystemException e) {
            throw new KettleException(Messages.getString("JobMeta.Exception.AnErrorOccuredReadingJob", this.getFilename()), (Throwable)e);
        }
        catch (IOException e) {
            throw new KettleException(Messages.getString("JobMeta.Exception.AnErrorOccuredReadingJob", this.getFilename()), (Throwable)e);
        }
        return resourceName;
    }

    @Override
    public List<SlaveServer> getSlaveServers() {
        return this.slaveServers;
    }

    public void setSlaveServers(List<SlaveServer> slaveServers) {
        this.slaveServers = slaveServers;
    }

    public SlaveServer findSlaveServer(String serverString) {
        return SlaveServer.findSlaveServer(this.slaveServers, serverString);
    }

    public String[] getSlaveServerNames() {
        return SlaveServer.getSlaveServerNames(this.slaveServers);
    }

    public void renameJobEntryIfNameCollides(JobEntryCopy je) {
        boolean found;
        String newname = je.getName();
        int nr = 1;
        do {
            found = false;
            for (JobEntryCopy copy : this.jobcopies) {
                if (copy == je || !copy.getName().equalsIgnoreCase(newname) || copy.getNr() != 0) continue;
                found = true;
            }
            if (!found) continue;
            newname = je.getName() + " (" + ++nr + ")";
        } while (found);
        je.setName(newname);
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public void setSharedObjects(SharedObjects sharedObjects) {
        this.sharedObjects = sharedObjects;
    }

    public void addNameChangedListener(NameChangedListener listener) {
        if (this.nameChangedListeners == null) {
            this.nameChangedListeners = new ArrayList<NameChangedListener>();
        }
        this.nameChangedListeners.add(listener);
    }

    public void removeNameChangedListener(NameChangedListener listener) {
        this.nameChangedListeners.remove(listener);
    }

    public void addFilenameChangedListener(FilenameChangedListener listener) {
        if (this.filenameChangedListeners == null) {
            this.filenameChangedListeners = new ArrayList<FilenameChangedListener>();
        }
        this.filenameChangedListeners.add(listener);
    }

    public void removeFilenameChangedListener(FilenameChangedListener listener) {
        this.filenameChangedListeners.remove(listener);
    }

    private boolean nameChanged(String oldFilename, String newFilename) {
        if (oldFilename == null && newFilename == null) {
            return false;
        }
        if (oldFilename == null && newFilename != null) {
            return true;
        }
        return oldFilename.equals(newFilename);
    }

    private void fireFilenameChangedListeners(String oldFilename, String newFilename) {
        if (this.nameChanged(oldFilename, newFilename) && this.filenameChangedListeners != null) {
            for (FilenameChangedListener listener : this.filenameChangedListeners) {
                listener.filenameChanged(this, oldFilename, newFilename);
            }
        }
    }

    private void fireNameChangedListeners(String oldName, String newName) {
        if (this.nameChanged(oldName, newName) && this.nameChangedListeners != null) {
            for (NameChangedListener listener : this.nameChangedListeners) {
                listener.nameChanged(this, oldName, newName);
            }
        }
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, defValue);
                continue;
            }
            this.setVariable(key, value);
        }
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public String getLogSizeLimit() {
        return this.logSizeLimit;
    }

    public void setLogSizeLimit(String logSizeLimit) {
        this.logSizeLimit = logSizeLimit;
    }
}

