<?php
/**
 * ReplicationUpdateRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Model;

use \ArrayAccess;
use \InfluxDB2\ObjectSerializer;

/**
 * ReplicationUpdateRequest Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReplicationUpdateRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReplicationUpdateRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'description' => 'string',
        'remote_id' => 'string',
        'remote_bucket_id' => 'string',
        'remote_bucket_name' => 'string',
        'max_queue_size_bytes' => 'int',
        'drop_non_retryable_data' => 'bool',
        'max_age_seconds' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'name' => null,
        'description' => null,
        'remote_id' => null,
        'remote_bucket_id' => null,
        'remote_bucket_name' => null,
        'max_queue_size_bytes' => 'int64',
        'drop_non_retryable_data' => null,
        'max_age_seconds' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'description' => 'description',
        'remote_id' => 'remoteID',
        'remote_bucket_id' => 'remoteBucketID',
        'remote_bucket_name' => 'remoteBucketName',
        'max_queue_size_bytes' => 'maxQueueSizeBytes',
        'drop_non_retryable_data' => 'dropNonRetryableData',
        'max_age_seconds' => 'maxAgeSeconds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'description' => 'setDescription',
        'remote_id' => 'setRemoteId',
        'remote_bucket_id' => 'setRemoteBucketId',
        'remote_bucket_name' => 'setRemoteBucketName',
        'max_queue_size_bytes' => 'setMaxQueueSizeBytes',
        'drop_non_retryable_data' => 'setDropNonRetryableData',
        'max_age_seconds' => 'setMaxAgeSeconds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'description' => 'getDescription',
        'remote_id' => 'getRemoteId',
        'remote_bucket_id' => 'getRemoteBucketId',
        'remote_bucket_name' => 'getRemoteBucketName',
        'max_queue_size_bytes' => 'getMaxQueueSizeBytes',
        'drop_non_retryable_data' => 'getDropNonRetryableData',
        'max_age_seconds' => 'getMaxAgeSeconds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['remote_id'] = isset($data['remote_id']) ? $data['remote_id'] : null;
        $this->container['remote_bucket_id'] = isset($data['remote_bucket_id']) ? $data['remote_bucket_id'] : null;
        $this->container['remote_bucket_name'] = isset($data['remote_bucket_name']) ? $data['remote_bucket_name'] : null;
        $this->container['max_queue_size_bytes'] = isset($data['max_queue_size_bytes']) ? $data['max_queue_size_bytes'] : null;
        $this->container['drop_non_retryable_data'] = isset($data['drop_non_retryable_data']) ? $data['drop_non_retryable_data'] : null;
        $this->container['max_age_seconds'] = isset($data['max_age_seconds']) ? $data['max_age_seconds'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['max_queue_size_bytes']) && ($this->container['max_queue_size_bytes'] < 33554430)) {
            $invalidProperties[] = "invalid value for 'max_queue_size_bytes', must be bigger than or equal to 33554430.";
        }

        if (!is_null($this->container['max_age_seconds']) && ($this->container['max_age_seconds'] < 0)) {
            $invalidProperties[] = "invalid value for 'max_age_seconds', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets remote_id
     *
     * @return string|null
     */
    public function getRemoteId()
    {
        return $this->container['remote_id'];
    }

    /**
     * Sets remote_id
     *
     * @param string|null $remote_id remote_id
     *
     * @return $this
     */
    public function setRemoteId($remote_id)
    {
        $this->container['remote_id'] = $remote_id;

        return $this;
    }

    /**
     * Gets remote_bucket_id
     *
     * @return string|null
     */
    public function getRemoteBucketId()
    {
        return $this->container['remote_bucket_id'];
    }

    /**
     * Sets remote_bucket_id
     *
     * @param string|null $remote_bucket_id remote_bucket_id
     *
     * @return $this
     */
    public function setRemoteBucketId($remote_bucket_id)
    {
        $this->container['remote_bucket_id'] = $remote_bucket_id;

        return $this;
    }

    /**
     * Gets remote_bucket_name
     *
     * @return string|null
     */
    public function getRemoteBucketName()
    {
        return $this->container['remote_bucket_name'];
    }

    /**
     * Sets remote_bucket_name
     *
     * @param string|null $remote_bucket_name remote_bucket_name
     *
     * @return $this
     */
    public function setRemoteBucketName($remote_bucket_name)
    {
        $this->container['remote_bucket_name'] = $remote_bucket_name;

        return $this;
    }

    /**
     * Gets max_queue_size_bytes
     *
     * @return int|null
     */
    public function getMaxQueueSizeBytes()
    {
        return $this->container['max_queue_size_bytes'];
    }

    /**
     * Sets max_queue_size_bytes
     *
     * @param int|null $max_queue_size_bytes max_queue_size_bytes
     *
     * @return $this
     */
    public function setMaxQueueSizeBytes($max_queue_size_bytes)
    {

        if (!is_null($max_queue_size_bytes) && ($max_queue_size_bytes < 33554430)) {
            throw new \InvalidArgumentException('invalid value for $max_queue_size_bytes when calling ReplicationUpdateRequest., must be bigger than or equal to 33554430.');
        }

        $this->container['max_queue_size_bytes'] = $max_queue_size_bytes;

        return $this;
    }

    /**
     * Gets drop_non_retryable_data
     *
     * @return bool|null
     */
    public function getDropNonRetryableData()
    {
        return $this->container['drop_non_retryable_data'];
    }

    /**
     * Sets drop_non_retryable_data
     *
     * @param bool|null $drop_non_retryable_data drop_non_retryable_data
     *
     * @return $this
     */
    public function setDropNonRetryableData($drop_non_retryable_data)
    {
        $this->container['drop_non_retryable_data'] = $drop_non_retryable_data;

        return $this;
    }

    /**
     * Gets max_age_seconds
     *
     * @return int|null
     */
    public function getMaxAgeSeconds()
    {
        return $this->container['max_age_seconds'];
    }

    /**
     * Sets max_age_seconds
     *
     * @param int|null $max_age_seconds max_age_seconds
     *
     * @return $this
     */
    public function setMaxAgeSeconds($max_age_seconds)
    {

        if (!is_null($max_age_seconds) && ($max_age_seconds < 0)) {
            throw new \InvalidArgumentException('invalid value for $max_age_seconds when calling ReplicationUpdateRequest., must be bigger than or equal to 0.');
        }

        $this->container['max_age_seconds'] = $max_age_seconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


