/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import java.util.Arrays;

public abstract class ExpressionHandler {
    private static final int UNINITIALIZED = Integer.MIN_VALUE;
    private IndentationCheck mIndentCheck;
    private DetailAST mMainAst;
    private String mTypeName;
    private ExpressionHandler mParent;
    private int mLevel = Integer.MIN_VALUE;

    public ExpressionHandler(IndentationCheck aIndentCheck, String aTypeName, DetailAST aExpr, ExpressionHandler aParent) {
        this.mIndentCheck = aIndentCheck;
        this.mTypeName = aTypeName;
        this.mMainAst = aExpr;
        this.mParent = aParent;
    }

    public final int getLevel() {
        if (this.mLevel == Integer.MIN_VALUE) {
            this.mLevel = this.getLevelImpl();
        }
        return this.mLevel;
    }

    protected int getLevelImpl() {
        return this.mParent.suggestedChildLevel(this);
    }

    public int suggestedChildLevel(ExpressionHandler aChild) {
        return this.getLevel() + this.mIndentCheck.getBasicOffset();
    }

    protected final void logError(DetailAST aAst, String aSubtypeName, int aActualLevel) {
        this.logError(aAst, aSubtypeName, aActualLevel, this.getLevel());
    }

    protected final void logError(DetailAST aAst, String aSubtypeName, int aActualLevel, int aExpectedLevel) {
        String typeStr = aSubtypeName == "" ? "" : " " + aSubtypeName;
        Object[] args = new Object[]{this.mTypeName + typeStr, new Integer(aActualLevel), new Integer(aExpectedLevel)};
        this.mIndentCheck.indentationLog(aAst.getLineNo(), "indentation.error", args);
    }

    protected final void logChildError(int aLine, int aActualLevel, int aExpectedLevel) {
        Object[] args = new Object[]{this.mTypeName, new Integer(aActualLevel), new Integer(aExpectedLevel)};
        this.mIndentCheck.indentationLog(aLine, "indentation.child.error", args);
    }

    protected final boolean startsLine(DetailAST aAst) {
        return this.getLineStart(aAst) == this.expandedTabsColumnNo(aAst);
    }

    static boolean areOnSameLine(DetailAST aAst1, DetailAST aAst2) {
        return aAst1 != null && aAst2 != null && aAst1.getLineNo() == aAst2.getLineNo();
    }

    protected final boolean atLevelOrGreater(DetailAST aParent) {
        if (this.expandedTabsColumnNo(aParent) < this.getLevel()) {
            return false;
        }
        DetailAST child = aParent.getLastChild();
        while (child != null) {
            if (!this.atLevelOrGreater(child)) {
                return false;
            }
            child = child.getPreviousSibling();
        }
        return true;
    }

    protected final int getLineStart(DetailAST aAst) {
        String line = this.mIndentCheck.getLines()[aAst.getLineNo() - 1];
        return this.getLineStart(line);
    }

    protected final void checkLinesIndent(int aStartLine, int aEndLine, int aIndentLevel) {
        this.checkSingleLine(aStartLine, aIndentLevel);
        aIndentLevel += this.mIndentCheck.getBasicOffset();
        int i = aStartLine + 1;
        while (i <= aEndLine) {
            this.checkSingleLine(i, aIndentLevel);
            ++i;
        }
    }

    protected boolean shouldIncraeseIndent() {
        return true;
    }

    private void checkLinesIndent(LineSet aLines, int aIndentLevel, boolean aFirstLineMatches, int aFirstLine) {
        if (aLines.isEmpty()) {
            return;
        }
        int startLine = aLines.firstLine();
        int endLine = aLines.lastLine();
        int startCol = aLines.firstLineCol();
        int realStartCol = this.getLineStart(this.mIndentCheck.getLines()[startLine - 1]);
        if (realStartCol == startCol) {
            this.checkSingleLine(startLine, startCol, aIndentLevel, aFirstLineMatches);
        }
        if (aFirstLineMatches || aFirstLine > this.mMainAst.getLineNo() && this.shouldIncraeseIndent()) {
            aIndentLevel += this.mIndentCheck.getBasicOffset();
        }
        int i = startLine + 1;
        while (i <= endLine) {
            Integer col = aLines.getStartColumn(new Integer(i));
            String thisLine = this.mIndentCheck.getLines()[i - 1];
            String prevLine = this.mIndentCheck.getLines()[i - 2];
            if (thisLine.matches("^\\s*\\.") || prevLine.matches("\\.\\s*$")) {
                aIndentLevel += this.mIndentCheck.getBasicOffset();
            }
            if (col != null) {
                this.checkSingleLine(i, col, aIndentLevel, false);
            }
            ++i;
        }
    }

    private void checkSingleLine(int aLineNum, int aIndentLevel) {
        String line = this.mIndentCheck.getLines()[aLineNum - 1];
        int start = this.getLineStart(line);
        if (start < aIndentLevel) {
            this.logChildError(aLineNum, start, aIndentLevel);
        }
    }

    private void checkSingleLine(int aLineNum, int aColNum, int aIndentLevel, boolean aMustMatch) {
        String line = this.mIndentCheck.getLines()[aLineNum - 1];
        int start = this.getLineStart(line);
        if (aMustMatch ? start != aIndentLevel : aColNum == start && start < aIndentLevel) {
            this.logChildError(aLineNum, start, aIndentLevel);
        }
    }

    protected final int getLineStart(String aLine) {
        int start = 0;
        while (start < aLine.length()) {
            char c = aLine.charAt(start);
            if (!Character.isWhitespace(c)) {
                return Utils.lengthExpandedTabs(aLine, start, this.mIndentCheck.getIndentationTabWidth());
            }
            ++start;
        }
        return 0;
    }

    protected final void checkChildren(DetailAST aParent, int[] aTokenTypes, int aStartLevel, boolean aFirstLineMatches, boolean aAllowNesting) {
        Arrays.sort(aTokenTypes);
        DetailAST child = (DetailAST)aParent.getFirstChild();
        while (child != null) {
            if (Arrays.binarySearch(aTokenTypes, child.getType()) >= 0) {
                this.checkExpressionSubtree(child, aStartLevel, aFirstLineMatches, aAllowNesting);
            }
            child = (DetailAST)child.getNextSibling();
        }
    }

    protected final void checkExpressionSubtree(DetailAST aTree, int aLevel, boolean aFirstLineMatches, boolean aAllowNesting) {
        LineSet subtreeLines = new LineSet();
        int firstLine = this.getFirstLine(Integer.MAX_VALUE, aTree);
        if (aFirstLineMatches && !aAllowNesting) {
            subtreeLines.addLineAndCol(new Integer(firstLine), this.getLineStart(this.mIndentCheck.getLines()[firstLine - 1]));
        }
        this.findSubtreeLines(subtreeLines, aTree, aAllowNesting);
        this.checkLinesIndent(subtreeLines, aLevel, aFirstLineMatches, firstLine);
    }

    protected final int getFirstLine(int aStartLine, DetailAST aTree) {
        int currLine = aTree.getLineNo();
        if (currLine < aStartLine) {
            aStartLine = currLine;
        }
        DetailAST node = (DetailAST)aTree.getFirstChild();
        while (node != null) {
            aStartLine = this.getFirstLine(aStartLine, node);
            node = (DetailAST)node.getNextSibling();
        }
        return aStartLine;
    }

    protected final int expandedTabsColumnNo(DetailAST aAst) {
        String line = this.mIndentCheck.getLines()[aAst.getLineNo() - 1];
        return Utils.lengthExpandedTabs(line, aAst.getColumnNo(), this.mIndentCheck.getIndentationTabWidth());
    }

    protected final void findSubtreeLines(LineSet aLines, DetailAST aTree, boolean aAllowNesting) {
        if (this.getIndentCheck().getHandlerFactory().isHandledType(aTree.getType()) || aTree.getLineNo() < 0) {
            return;
        }
        Integer lineNum = new Integer(aTree.getLineNo());
        Integer colNum = aLines.getStartColumn(lineNum);
        int thisLineColumn = this.expandedTabsColumnNo(aTree);
        if (colNum == null) {
            aLines.addLineAndCol(lineNum, thisLineColumn);
        } else if (this.expandedTabsColumnNo(aTree) < colNum) {
            aLines.addLineAndCol(lineNum, thisLineColumn);
        }
        DetailAST node = (DetailAST)aTree.getFirstChild();
        while (node != null) {
            this.findSubtreeLines(aLines, node, aAllowNesting);
            node = (DetailAST)node.getNextSibling();
        }
    }

    protected final void checkModifiers() {
        DetailAST modifiers = this.mMainAst.findFirstToken(5);
        DetailAST modifier = (DetailAST)modifiers.getFirstChild();
        while (modifier != null) {
            if (this.startsLine(modifier) && this.expandedTabsColumnNo(modifier) != this.getLevel()) {
                this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
            }
            modifier = (DetailAST)modifier.getNextSibling();
        }
    }

    public abstract void checkIndentation();

    protected final IndentationCheck getIndentCheck() {
        return this.mIndentCheck;
    }

    protected final DetailAST getMainAst() {
        return this.mMainAst;
    }

    protected final ExpressionHandler getParent() {
        return this.mParent;
    }
}

