/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.paros.ParosAbstractTable;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ParosTableSession
extends ParosAbstractTable
implements TableSession {
    private static final String SESSIONID = "SESSIONID";
    private static final String SESSIONNAME = "SESSIONNAME";
    private static final String LASTACCESS = "LASTACCESS";
    private PreparedStatement psReadDate = null;
    private PreparedStatement psReadAll = null;
    private PreparedStatement psInsert = null;
    private PreparedStatement psUpdate = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            this.psReadDate = conn.prepareStatement("SELECT * FROM SESSION WHERE LASTACCESS < ?");
            this.psReadAll = conn.prepareStatement("SELECT * FROM SESSION");
            this.psInsert = conn.prepareStatement("INSERT INTO SESSION (SESSIONID,SESSIONNAME) VALUES (?, ?)");
            this.psUpdate = conn.prepareStatement("UPDATE SESSION SET SESSIONNAME = ?,LASTACCESS = NOW WHERE SESSIONID = ?");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void insert(long sessionId, String sessionName) throws DatabaseException {
        try {
            this.psInsert.setLong(1, sessionId);
            this.psInsert.setString(2, sessionName);
            this.psInsert.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void update(long sessionId, String sessionName) throws DatabaseException {
        try {
            this.psUpdate.setLong(2, sessionId);
            this.psUpdate.setString(1, sessionName);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<RecordSession> listSessions() throws DatabaseException {
        return null;
    }

    private RecordSession build(ResultSet rs) throws HttpMalformedHeaderException, SQLException {
        RecordSession session = null;
        if (rs.next()) {
            session = new RecordSession(rs.getLong(SESSIONID), rs.getString(SESSIONNAME), rs.getDate(LASTACCESS));
        }
        return session;
    }
}

