/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import java.util.LinkedList;

public class PoodleCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "poodle";
    @ParametersDelegate
    private ClientDelegate clientDelegate = new ClientDelegate();
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate = new StarttlsDelegate();
    @ParametersDelegate
    private CiphersuiteDelegate cipherSuiteDelegate = new CiphersuiteDelegate();

    public PoodleCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.starttlsDelegate);
        this.addDelegate(this.cipherSuiteDelegate);
    }

    @Override
    public boolean isExecuteAttack() {
        return false;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        if (this.cipherSuiteDelegate.getCipherSuites() == null) {
            LinkedList cipherSuites = new LinkedList();
            for (CipherSuite suite : CipherSuite.getImplemented()) {
                if (!suite.isCBC() || suite.isPsk() || suite.isSrp()) continue;
                cipherSuites.add(suite);
            }
            config.setDefaultClientSupportedCiphersuites(cipherSuites);
        }
        for (CipherSuite suite : config.getDefaultClientSupportedCiphersuites()) {
            if (suite.isCBC()) continue;
            throw new ConfigurationException("This attack only works with CBC Ciphersuites");
        }
        config.setStopActionsAfterFatal(true);
        config.setQuickReceive(true);
        config.setEarlyStop(true);
        config.setAddRenegotiationInfoExtension(true);
        config.setAddServerNameIndicationExtension(true);
        config.setAddSignatureAndHashAlgorithmsExtension(true);
        config.setQuickReceive(true);
        config.setStopActionsAfterFatal(true);
        config.setStopReceivingAfterFatal(true);
        config.setEarlyStop(true);
        boolean containsEc = false;
        for (CipherSuite suite : config.getDefaultClientSupportedCiphersuites()) {
            KeyExchangeAlgorithm keyExchangeAlgorithm = AlgorithmResolver.getKeyExchangeAlgorithm(suite);
            if (keyExchangeAlgorithm == null || !keyExchangeAlgorithm.name().toUpperCase().contains("EC")) continue;
            containsEc = true;
            break;
        }
        config.setAddECPointFormatExtension(containsEc);
        config.setAddEllipticCurveExtension(containsEc);
        return config;
    }
}

