/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.cipher.DecryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.cipher.EncryptionCipher;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    protected DecryptionCipher decryptCipher;
    protected EncryptionCipher encryptCipher;
    protected final BulkCipherAlgorithm bulkCipherAlg;
    private final KeySet keySet;
    protected TlsContext context;
    protected final CipherSuite cipherSuite;
    protected final ProtocolVersion version;

    public RecordCipher(TlsContext context, KeySet keySet) {
        this.keySet = keySet;
        this.context = context;
        this.cipherSuite = context.getChooser().getSelectedCipherSuite();
        this.version = context.getChooser().getSelectedProtocolVersion();
        this.bulkCipherAlg = AlgorithmResolver.getBulkCipherAlgorithm(context.getChooser().getSelectedCipherSuite());
    }

    public abstract void encrypt(Record var1) throws CryptoException;

    public abstract void encrypt(BlobRecord var1) throws CryptoException;

    public abstract void decrypt(Record var1) throws CryptoException;

    public abstract void decrypt(BlobRecord var1) throws CryptoException;

    public final KeySet getKeySet() {
        return this.keySet;
    }

    protected final byte[] collectAdditionalAuthenticatedData(Record record, ProtocolVersion protocolVersion) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            if (protocolVersion.isTLS13()) {
                stream.write(((Byte)record.getContentType().getValue()).byteValue());
                stream.write((byte[])record.getProtocolVersion().getValue());
                stream.write(ArrayConverter.intToBytes((int)((Integer)record.getLength().getValue()), (int)2));
                return stream.toByteArray();
            }
            if (protocolVersion.isDTLS()) {
                stream.write(ArrayConverter.intToBytes((int)((Integer)record.getEpoch().getValue()).shortValue(), (int)2));
                stream.write(ArrayConverter.longToUint48Bytes((long)((BigInteger)record.getSequenceNumber().getValue()).longValue()));
            } else {
                stream.write(ArrayConverter.longToUint64Bytes((long)((BigInteger)record.getSequenceNumber().getValue()).longValue()));
            }
            stream.write(((Byte)record.getContentType().getValue()).byteValue());
            byte[] version = !protocolVersion.isSSL() ? (byte[])record.getProtocolVersion().getValue() : new byte[]{};
            stream.write(version);
            int length = record.getComputations().getAuthenticatedNonMetaData() == null || record.getComputations().getAuthenticatedNonMetaData().getOriginalValue() == null ? ((byte[])record.getComputations().getPlainRecordBytes().getValue()).length : ((byte[])record.getComputations().getAuthenticatedNonMetaData().getValue()).length;
            stream.write(ArrayConverter.intToBytes((int)length, (int)2));
            return stream.toByteArray();
        }
        catch (IOException E) {
            throw new WorkflowExecutionException("Could not write data to ByteArrayOutputStream");
        }
    }
}

