/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(36, 32, 88) % 12) => ivec3(0, 8, 4)
 * (ivec3(36, 32, 88) % 76) => ivec3(36, 32, 12)
 * (ivec3(59, 77, 68) % 12) => ivec3(11, 5, 8)
 * (ivec3(59, 77, 68) % 76) => ivec3(59, 1, 68)
 */
#version 150

void main()
{
  float[all(equal((ivec3(36, 32, 88) % 12), ivec3(0, 8, 4))) ? 1 : -1] array0;
  float[all(equal((ivec3(36, 32, 88) % 76), ivec3(36, 32, 12))) ? 1 : -1] array1;
  float[all(equal((ivec3(59, 77, 68) % 12), ivec3(11, 5, 8))) ? 1 : -1] array2;
  float[all(equal((ivec3(59, 77, 68) % 76), ivec3(59, 1, 68))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
