<?php

namespace {

	/**
	 * <p>An HTML node in an HTML file, as detected by tidy.</p>
	 * @link https://php.net/manual/en/class.tidy.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	class tidy {

		/**
		 * Return warnings and errors which occurred parsing the specified document
		 * <p>Object-oriented style (property):</p><p>Returns warnings and errors which occurred parsing the specified document.</p>
		 * @var ?string <p>Returns the error buffer as a string, or <b><code>false</code></b> if the buffer is empty.</p>
		 * @link https://php.net/manual/en/tidy.props.errorbuffer.php
		 * @see tidy_access_count(), tidy_error_count(), tidy_warning_count()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public ?string $errorBuffer = null;

		/**
		 * @var ?string <p>The HTML representation of the node, including the surrounding tags.</p>
		 * @link https://php.net/manual/en/class.tidy.php#tidy.props.value
		 */
		public ?string $value = null;

		/**
		 * Constructs a new tidy object
		 * <p>Constructs a new <code>tidy</code> object.</p>
		 * @param ?string $filename <p>If the <code>filename</code> parameter is given, this function will also read that file and initialize the object with the file, acting like <code>tidy_parse_file()</code>.</p>
		 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>For an explanation about each option, visit &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
		 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
		 * @param bool $useIncludePath <p>Search for the file in the include_path.</p>
		 * @return self
		 * @link https://php.net/manual/en/tidy.construct.php
		 * @see tidy::parseFile(), tidy::parseString()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function __construct(?string $filename = null, array|string|null $config = null, ?string $encoding = null, bool $useIncludePath = false) {}

		/**
		 * Returns a tidyNode object starting from the  tag of the tidy parse tree
		 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;body&gt; tag of the tidy parse tree.</p>
		 * @return ?tidyNode <p>Returns a <code>tidyNode</code> object starting from the &lt;body&gt; tag of the tidy parse tree.</p>
		 * @link https://php.net/manual/en/tidy.body.php
		 * @see tidy::head(), tidy::html()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0
		 */
		public function body(): ?\tidyNode {}

		/**
		 * Execute configured cleanup and repair operations on parsed markup
		 * <p>Object-oriented style</p><p>This function cleans and repairs the given tidy <code>tidy</code>.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.cleanrepair.php
		 * @see tidy::repairFile(), tidy::repairString()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function cleanRepair(): bool {}

		/**
		 * Run configured diagnostics on parsed and repaired markup
		 * <p>Object-oriented style</p><p>Runs diagnostic tests on the given tidy <code>tidy</code>, adding some more information about the document in the error buffer.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.diagnose.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function diagnose(): bool {}

		/**
		 * Get current Tidy configuration
		 * <p>Object-oriented style</p><p>Gets the list of the configuration options in use by the given tidy <code>tidy</code>.</p>
		 * @return array <p>Returns an array of configuration options.</p><p>For an explanation about each option, visit &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
		 * @link https://php.net/manual/en/tidy.getconfig.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
		 */
		public function getConfig(): array {}

		/**
		 * Get the Detected HTML version for the specified document
		 * <p>Object-oriented style</p><p>Returns the detected HTML version for the specified tidy <code>tidy</code>.</p>
		 * @return int <p>Returns the detected HTML version.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <code>0</code>.</p>
		 * @link https://php.net/manual/en/tidy.gethtmlver.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function getHtmlVer(): int {}

		/**
		 * Returns the value of the specified configuration option for the tidy document
		 * <p>Object-oriented style</p><p>Returns the value of the specified <code>option</code> for the specified tidy <code>tidy</code>.</p>
		 * @param string $option <p>You will find a list with each configuration option and their types at: &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
		 * @return string|int|bool <p>Returns the value of the specified <code>option</code>. The return type depends on the type of the specified one.</p>
		 * @link https://php.net/manual/en/tidy.getopt.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function getOpt(string $option): string|int|bool {}

		/**
		 * Returns the documentation for the given option name
		 * <p>Object-oriented style</p><p><b>tidy_get_opt_doc()</b> returns the documentation for the given option name.</p><p><b>Note</b>:</p><p>You need at least libtidy from 25 April, 2005 for this function be available.</p>
		 * @param string $option <p>The option name</p>
		 * @return string|false <p>Returns a string if the option exists and has documentation available, or <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidy.getoptdoc.php
		 * @see tidy::getConfig(), tidy::getOpt()
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function getOptDoc(string $option): string|false {}

		/**
		 * Get release date (version) for Tidy library
		 * <p>Object-oriented style</p><p>Gets the release date of the Tidy library.</p>
		 * @return string <p>Returns a string with the release date of the Tidy library, which may be <code>'unknown'</code>.</p>
		 * @link https://php.net/manual/en/tidy.getrelease.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function getRelease(): string {}

		/**
		 * Get status of specified document
		 * <p>Object-oriented style</p><p>Returns the status for the specified tidy <code>tidy</code>.</p>
		 * @return int <p>Returns 0 if no error/warning was raised, 1 for warnings or accessibility errors, or 2 for errors.</p>
		 * @link https://php.net/manual/en/tidy.getstatus.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function getStatus(): int {}

		/**
		 * Returns a tidyNode object starting from the  tag of the tidy parse tree
		 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;head&gt; tag of the tidy parse tree.</p>
		 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
		 * @link https://php.net/manual/en/tidy.head.php
		 * @see tidy::body(), tidy::html()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
		 */
		public function head(): ?\tidyNode {}

		/**
		 * Returns a tidyNode object starting from the  tag of the tidy parse tree
		 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;html&gt; tag of the tidy parse tree.</p>
		 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
		 * @link https://php.net/manual/en/tidy.php.php
		 * @see tidy::body(), tidy::head()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
		 */
		public function html(): ?\tidyNode {}

		/**
		 * Indicates if the document is a XHTML document
		 * <p>Object-oriented style</p><p>Tells if the document is a XHTML document.</p>
		 * @return bool <p>This function returns <b><code>true</code></b> if the specified tidy <code>tidy</code> is a XHTML document, or <b><code>false</code></b> otherwise.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <b><code>false</code></b>.</p>
		 * @link https://php.net/manual/en/tidy.isxhtml.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function isXhtml(): bool {}

		/**
		 * Indicates if the document is a generic (non HTML/XHTML) XML document
		 * <p>Object-oriented style</p><p>Tells if the document is a generic (non HTML/XHTML) XML document.</p>
		 * @return bool <p>This function returns <b><code>true</code></b> if the specified tidy <code>tidy</code> is a generic XML document (non HTML/XHTML), or <b><code>false</code></b> otherwise.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <b><code>false</code></b>.</p>
		 * @link https://php.net/manual/en/tidy.isxml.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function isXml(): bool {}

		/**
		 * Parse markup in file or URI
		 * <p>Object-oriented style</p><p>Parses the given file.</p>
		 * @param string $filename <p>If the <code>filename</code> parameter is given, this function will also read that file and initialize the object with the file, acting like <b>tidy_parse_file()</b>.</p>
		 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>For an explanation about each option, see &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
		 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
		 * @param bool $useIncludePath <p>Search for the file in the include_path.</p>
		 * @return bool <p><b>tidy::parseFile()</b> returns <b><code>true</code></b> on success. <b>tidy_parse_file()</b> returns a new <code>tidy</code> instance on success. Both, the method and the function return <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.parsefile.php
		 * @see tidy::parseString(), tidy::repairFile(), tidy::repairString()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function parseFile(string $filename, array|string|null $config = null, ?string $encoding = null, bool $useIncludePath = false): bool {}

		/**
		 * Parse a document stored in a string
		 * <p>Object-oriented style</p><p>Parses a document stored in a string.</p>
		 * @param string $string <p>The data to be parsed.</p>
		 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>For an explanation about each option, visit &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
		 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
		 * @return bool <p><b>tidy::parseString()</b> returns <b><code>true</code></b> on success. <b>tidy_parse_string()</b> returns a new <code>tidy</code> instance on success. Both, the method and the function return <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.parsestring.php
		 * @see tidy::parseFile(), tidy::repairFile(), tidy::repairString()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
		 */
		public function parseString(string $string, array|string|null $config = null, ?string $encoding = null): bool {}

		/**
		 * Repair a file and return it as a string
		 * <p>Object-oriented style</p><p>Repairs the given file and returns it as a string.</p>
		 * @param string $filename <p>The file to be repaired.</p>
		 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>Check http://tidy.sourceforge.net/docs/quickref.html for an explanation about each option.</p>
		 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
		 * @param bool $useIncludePath <p>Search for the file in the include_path.</p>
		 * @return string|false <p>Returns the repaired contents as a string, or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.repairfile.php
		 * @see tidy::parseFile(), tidy::parseString(), tidy::repairString()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
		 */
		public static function repairFile(string $filename, array|string|null $config = null, ?string $encoding = null, bool $useIncludePath = false): string|false {}

		/**
		 * Repair a string using an optionally provided configuration file
		 * <p>Object-oriented style</p><p>Repairs the given string.</p>
		 * @param string $string <p>The data to be repaired.</p>
		 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>Check &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference for an explanation about each option.</p>
		 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
		 * @return string|false <p>Returns the repaired string, or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/tidy.repairstring.php
		 * @see tidy::parseFile(), tidy::parseString(), tidy::repairFile()
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
		 */
		public static function repairString(string $string, array|string|null $config = null, ?string $encoding = null): string|false {}

		/**
		 * Returns a tidyNode object representing the root of the tidy parse tree
		 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object representing the root of the tidy parse tree.</p>
		 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
		 * @link https://php.net/manual/en/tidy.root.php
		 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
		 */
		public function root(): ?\tidyNode {}
	}

	/**
	 * <p>An HTML node in an HTML file, as detected by tidy.</p>
	 * @link https://php.net/manual/en/class.tidynode.php
	 * @since PHP 5, PHP 7, PHP 8
	 */
	final class tidyNode {

		/**
		 * @var string <p>The HTML representation of the node, including the surrounding tags.</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.value
		 */
		public string $value;

		/**
		 * @var string <p>The name of the HTML node</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.name
		 */
		public string $name;

		/**
		 * @var int <p>The type of the node (one of the nodetype constants, e.g. <b><code>TIDY_NODETYPE_PHP</code></b>)</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.type
		 */
		public int $type;

		/**
		 * @var int <p>The line number at which the tags is located in the file</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.line
		 */
		public int $line;

		/**
		 * @var int <p>The column number at which the tags is located in the file</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.column
		 */
		public int $column;

		/**
		 * @var bool <p>Indicates if the node is a proprietary tag</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.proprietary
		 */
		public bool $proprietary;

		/**
		 * @var ?int <p>The ID of the node (one of the tag constants, e.g. <b><code>TIDY_TAG_FRAME</code></b>)</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.id
		 */
		public ?int $id;

		/**
		 * @var ?array <p>An array of string, representing the attributes names (as keys) of the current node.</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.attribute
		 */
		public ?array $attribute;

		/**
		 * @var ?array <p>An array of <b>tidyNode</b>, representing the children of the current node.</p>
		 * @link https://php.net/manual/en/class.tidynode.php#tidynode.props.child
		 */
		public ?array $child;

		/**
		 * Private constructor to disallow direct instantiation
		 * @return self
		 * @link https://php.net/manual/en/tidynode.construct.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		private function __construct() {}

		/**
		 * Returns the next sibling node of the current node
		 * <p>Returns the next sibling node of the current node.</p>
		 * @return ?tidyNode <p>Returns a <code>tidyNode</code> if the node has a next sibling, or <b><code>null</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.getnextsibling.php
		 * @see tidyNode::getParent(), tidyNode::getPreviousSibling()
		 * @since PHP 8 >= 8.4.0
		 */
		public function getNextSibling(): ?\tidyNode {}

		/**
		 * Returns the parent node of the current node
		 * <p>Returns the parent node of the current node.</p>
		 * @return ?tidyNode <p>Returns a <code>tidyNode</code> if the node has a parent, or <b><code>null</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.getparent.php
		 * @see tidyNode::getPreviousSibling(), tidyNode::getNextSibling()
		 * @since PHP 5 >= 5.2.2, PHP 7, PHP 8
		 */
		public function getParent(): ?\tidyNode {}

		/**
		 * Returns the previous sibling node of the current node
		 * <p>Returns the previous sibling node of the current node.</p>
		 * @return ?tidyNode <p>Returns a <code>tidyNode</code> if the node has a previous sibling, or <b><code>null</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.getprevioussibling.php
		 * @see tidyNode::getParent(), tidyNode::getNextSibling()
		 * @since PHP 8 >= 8.4.0
		 */
		public function getPreviousSibling(): ?\tidyNode {}

		/**
		 * Checks if a node has children
		 * <p>Tells if the node has children.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node has children, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.haschildren.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function hasChildren(): bool {}

		/**
		 * Checks if a node has siblings
		 * <p>Tells if the node has siblings.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node has siblings, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.hassiblings.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function hasSiblings(): bool {}

		/**
		 * Checks if this node is ASP
		 * <p>Tells whether the current node is ASP.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node is ASP, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.isasp.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isAsp(): bool {}

		/**
		 * Checks if a node represents a comment
		 * <p>Tells if the node is a comment.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node is a comment, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.iscomment.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isComment(): bool {}

		/**
		 * Checks if a node is an element node
		 * <p>Tells if the node is an element node, but not the root node of the document.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node is an element node, but not the root node of the document, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.ishtml.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isHtml(): bool {}

		/**
		 * Checks if this node is JSTE
		 * <p>Tells if the node is JSTE.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node is JSTE, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.isjste.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isJste(): bool {}

		/**
		 * Checks if a node is PHP
		 * <p>Tells if the node is PHP.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the current node is PHP code, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.isphp.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isPhp(): bool {}

		/**
		 * Checks if a node represents text (no markup)
		 * <p>Tells if the node represents a text (without any markup).</p>
		 * @return bool <p>Returns <b><code>true</code></b> if the node represent a text, <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/tidynode.istext.php
		 * @since PHP 5, PHP 7, PHP 8
		 */
		public function isText(): bool {}
	}

	/**
	 * ob_start callback function to repair the buffer
	 * <p>Callback function for <code>ob_start()</code> to repair the buffer.</p>
	 * @param string $input <p>The buffer.</p>
	 * @param int $mode <p>The buffer mode.</p>
	 * @return string <p>Returns the modified buffer.</p>
	 * @link https://php.net/manual/en/function.ob-tidyhandler.php
	 * @see ob_start()
	 * @since PHP 5, PHP 7, PHP 8
	 */
	function ob_tidyhandler(string $input, int $mode = null): string {}

	/**
	 * Returns the Number of Tidy accessibility warnings encountered for specified document
	 * <p><b>tidy_access_count()</b> returns the number of accessibility warnings found for the specified document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns the number of warnings.</p>
	 * @link https://php.net/manual/en/function.tidy-access-count.php
	 * @see tidy_error_count(), tidy_warning_count()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_access_count(\tidy $tidy): int {}

	/**
	 * Execute configured cleanup and repair operations on parsed markup
	 * <p>Object-oriented style</p><p>This function cleans and repairs the given tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.cleanrepair.php
	 * @see tidy::repairFile(), tidy::repairString()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_clean_repair(\tidy $tidy): bool {}

	/**
	 * Returns the Number of Tidy configuration errors encountered for specified document
	 * <p>Returns the number of errors encountered in the configuration of the specified tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns the number of errors.</p>
	 * @link https://php.net/manual/en/function.tidy-config-count.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_config_count(\tidy $tidy): int {}

	/**
	 * Run configured diagnostics on parsed and repaired markup
	 * <p>Object-oriented style</p><p>Runs diagnostic tests on the given tidy <code>tidy</code>, adding some more information about the document in the error buffer.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.diagnose.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_diagnose(\tidy $tidy): bool {}

	/**
	 * Returns the Number of Tidy errors encountered for specified document
	 * <p>Returns the number of Tidy errors encountered for the specified document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns the number of errors.</p>
	 * @link https://php.net/manual/en/function.tidy-error-count.php
	 * @see tidy_access_count(), tidy_warning_count()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_error_count(\tidy $tidy): int {}

	/**
	 * Returns a tidyNode object starting from the  tag of the tidy parse tree
	 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;body&gt; tag of the tidy parse tree.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return ?tidyNode <p>Returns a <code>tidyNode</code> object starting from the &lt;body&gt; tag of the tidy parse tree.</p>
	 * @link https://php.net/manual/en/tidy.body.php
	 * @see tidy::head(), tidy::html()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0
	 */
	function tidy_get_body(\tidy $tidy): ?\tidyNode {}

	/**
	 * Get current Tidy configuration
	 * <p>Object-oriented style</p><p>Gets the list of the configuration options in use by the given tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return array <p>Returns an array of configuration options.</p><p>For an explanation about each option, visit &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
	 * @link https://php.net/manual/en/tidy.getconfig.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
	 */
	function tidy_get_config(\tidy $tidy): array {}

	/**
	 * Return warnings and errors which occurred parsing the specified document
	 * <p>Object-oriented style (property):</p><p>Returns warnings and errors which occurred parsing the specified document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return string|false <p>Returns the error buffer as a string, or <b><code>false</code></b> if the buffer is empty.</p>
	 * @link https://php.net/manual/en/tidy.props.errorbuffer.php
	 * @see tidy_access_count(), tidy_error_count(), tidy_warning_count()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_get_error_buffer(\tidy $tidy): string|false {}

	/**
	 * Returns a tidyNode object starting from the  tag of the tidy parse tree
	 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;head&gt; tag of the tidy parse tree.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
	 * @link https://php.net/manual/en/tidy.head.php
	 * @see tidy::body(), tidy::html()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
	 */
	function tidy_get_head(\tidy $tidy): ?\tidyNode {}

	/**
	 * Returns a tidyNode object starting from the  tag of the tidy parse tree
	 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object starting from the &lt;html&gt; tag of the tidy parse tree.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
	 * @link https://php.net/manual/en/tidy.php.php
	 * @see tidy::body(), tidy::head()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
	 */
	function tidy_get_html(\tidy $tidy): ?\tidyNode {}

	/**
	 * Get the Detected HTML version for the specified document
	 * <p>Object-oriented style</p><p>Returns the detected HTML version for the specified tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns the detected HTML version.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <code>0</code>.</p>
	 * @link https://php.net/manual/en/tidy.gethtmlver.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_get_html_ver(\tidy $tidy): int {}

	/**
	 * Returns the documentation for the given option name
	 * <p>Object-oriented style</p><p><b>tidy_get_opt_doc()</b> returns the documentation for the given option name.</p><p><b>Note</b>:</p><p>You need at least libtidy from 25 April, 2005 for this function be available.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @param string $option <p>The option name</p>
	 * @return string|false <p>Returns a string if the option exists and has documentation available, or <b><code>false</code></b> otherwise.</p>
	 * @link https://php.net/manual/en/tidy.getoptdoc.php
	 * @see tidy::getConfig(), tidy::getOpt()
	 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
	 */
	function tidy_get_opt_doc(\tidy $tidy, string $option): string|false {}

	/**
	 * Return a string representing the parsed tidy markup
	 * <p>Gets a string with the repaired html.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return string <p>Returns the parsed tidy markup.</p>
	 * @link https://php.net/manual/en/function.tidy-get-output.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_get_output(\tidy $tidy): string {}

	/**
	 * Get release date (version) for Tidy library
	 * <p>Object-oriented style</p><p>Gets the release date of the Tidy library.</p>
	 * @return string <p>Returns a string with the release date of the Tidy library, which may be <code>'unknown'</code>.</p>
	 * @link https://php.net/manual/en/tidy.getrelease.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_get_release(): string {}

	/**
	 * Returns a tidyNode object representing the root of the tidy parse tree
	 * <p>Object-oriented style</p><p>Returns a <code>tidyNode</code> object representing the root of the tidy parse tree.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return ?tidyNode <p>Returns the <code>tidyNode</code> object.</p>
	 * @link https://php.net/manual/en/tidy.root.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy 0.5.2-1.0.0
	 */
	function tidy_get_root(\tidy $tidy): ?\tidyNode {}

	/**
	 * Get status of specified document
	 * <p>Object-oriented style</p><p>Returns the status for the specified tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns 0 if no error/warning was raised, 1 for warnings or accessibility errors, or 2 for errors.</p>
	 * @link https://php.net/manual/en/tidy.getstatus.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_get_status(\tidy $tidy): int {}

	/**
	 * Returns the value of the specified configuration option for the tidy document
	 * <p>Object-oriented style</p><p>Returns the value of the specified <code>option</code> for the specified tidy <code>tidy</code>.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @param string $option <p>You will find a list with each configuration option and their types at: &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
	 * @return string|int|bool <p>Returns the value of the specified <code>option</code>. The return type depends on the type of the specified one.</p>
	 * @link https://php.net/manual/en/tidy.getopt.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_getopt(\tidy $tidy, string $option): string|int|bool {}

	/**
	 * Indicates if the document is a XHTML document
	 * <p>Object-oriented style</p><p>Tells if the document is a XHTML document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return bool <p>This function returns <b><code>true</code></b> if the specified tidy <code>tidy</code> is a XHTML document, or <b><code>false</code></b> otherwise.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <b><code>false</code></b>.</p>
	 * @link https://php.net/manual/en/tidy.isxhtml.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_is_xhtml(\tidy $tidy): bool {}

	/**
	 * Indicates if the document is a generic (non HTML/XHTML) XML document
	 * <p>Object-oriented style</p><p>Tells if the document is a generic (non HTML/XHTML) XML document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return bool <p>This function returns <b><code>true</code></b> if the specified tidy <code>tidy</code> is a generic XML document (non HTML/XHTML), or <b><code>false</code></b> otherwise.</p><p><b>Warning</b></p> <p>This function is not yet implemented in the Tidylib itself, so it always return <b><code>false</code></b>.</p>
	 * @link https://php.net/manual/en/tidy.isxml.php
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_is_xml(\tidy $tidy): bool {}

	/**
	 * Parse markup in file or URI
	 * <p>Object-oriented style</p><p>Parses the given file.</p>
	 * @param string $filename <p>If the <code>filename</code> parameter is given, this function will also read that file and initialize the object with the file, acting like <b>tidy_parse_file()</b>.</p>
	 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>For an explanation about each option, see &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
	 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
	 * @param bool $useIncludePath <p>Search for the file in the include_path.</p>
	 * @return tidy|false <p><b>tidy::parseFile()</b> returns <b><code>true</code></b> on success. <b>tidy_parse_file()</b> returns a new <code>tidy</code> instance on success. Both, the method and the function return <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.parsefile.php
	 * @see tidy::parseString(), tidy::repairFile(), tidy::repairString()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_parse_file(string $filename, array|string|null $config = null, ?string $encoding = null, bool $useIncludePath = false): \tidy|false {}

	/**
	 * Parse a document stored in a string
	 * <p>Object-oriented style</p><p>Parses a document stored in a string.</p>
	 * @param string $string <p>The data to be parsed.</p>
	 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>For an explanation about each option, visit &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference.</p>
	 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
	 * @return tidy|false <p><b>tidy::parseString()</b> returns <b><code>true</code></b> on success. <b>tidy_parse_string()</b> returns a new <code>tidy</code> instance on success. Both, the method and the function return <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.parsestring.php
	 * @see tidy::parseFile(), tidy::repairFile(), tidy::repairString()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_parse_string(string $string, array|string|null $config = null, ?string $encoding = null): \tidy|false {}

	/**
	 * Repair a file and return it as a string
	 * <p>Object-oriented style</p><p>Repairs the given file and returns it as a string.</p>
	 * @param string $filename <p>The file to be repaired.</p>
	 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>Check http://tidy.sourceforge.net/docs/quickref.html for an explanation about each option.</p>
	 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
	 * @param bool $useIncludePath <p>Search for the file in the include_path.</p>
	 * @return string|false <p>Returns the repaired contents as a string, or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.repairfile.php
	 * @see tidy::parseFile(), tidy::parseString(), tidy::repairString()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
	 */
	function tidy_repair_file(string $filename, array|string|null $config = null, ?string $encoding = null, bool $useIncludePath = false): string|false {}

	/**
	 * Repair a string using an optionally provided configuration file
	 * <p>Object-oriented style</p><p>Repairs the given string.</p>
	 * @param string $string <p>The data to be repaired.</p>
	 * @param array|string|null $config <p>The config <code>config</code> can be passed either as an array or as a string. If a string is passed, it is interpreted as the name of the configuration file, otherwise, it is interpreted as the options themselves.</p> <p>Check &#xBB;&#xA0;http://api.html-tidy.org/#quick-reference for an explanation about each option.</p>
	 * @param ?string $encoding <p>The <code>encoding</code> parameter sets the encoding for input/output documents. The possible values for encoding are: <code>ascii</code>, <code>latin0</code>, <code>latin1</code>, <code>raw</code>, <code>utf8</code>, <code>iso2022</code>, <code>mac</code>, <code>win1252</code>, <code>ibm858</code>, <code>utf16</code>, <code>utf16le</code>, <code>utf16be</code>, <code>big5</code>, and <code>shiftjis</code>.</p>
	 * @return string|false <p>Returns the repaired string, or <b><code>false</code></b> on failure.</p>
	 * @link https://php.net/manual/en/tidy.repairstring.php
	 * @see tidy::parseFile(), tidy::parseString(), tidy::repairFile()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.7.0
	 */
	function tidy_repair_string(string $string, array|string|null $config = null, ?string $encoding = null): string|false {}

	/**
	 * Returns the Number of Tidy warnings encountered for specified document
	 * <p>Returns the number of Tidy warnings encountered for the specified document.</p>
	 * @param \tidy $tidy <p>The <code>Tidy</code> object.</p>
	 * @return int <p>Returns the number of warnings.</p>
	 * @link https://php.net/manual/en/function.tidy-warning-count.php
	 * @see tidy_error_count(), tidy_access_count()
	 * @since PHP 5, PHP 7, PHP 8, PECL tidy >= 0.5.2
	 */
	function tidy_warning_count(\tidy $tidy): int {}

	/**
	 * ASP code
	 */
	define('TIDY_NODETYPE_ASP', null);

	/**
	 * CDATA
	 */
	define('TIDY_NODETYPE_CDATA', null);

	/**
	 * HTML comment
	 */
	define('TIDY_NODETYPE_COMMENT', null);

	/**
	 * doctype
	 */
	define('TIDY_NODETYPE_DOCTYPE', null);

	/**
	 * end tag
	 */
	define('TIDY_NODETYPE_END', null);

	/**
	 * JSTE code
	 */
	define('TIDY_NODETYPE_JSTE', null);

	/**
	 * PHP code
	 */
	define('TIDY_NODETYPE_PHP', null);

	/**
	 * Processing Instruction
	 */
	define('TIDY_NODETYPE_PROCINS', null);

	/**
	 * root node
	 */
	define('TIDY_NODETYPE_ROOT', null);

	/**
	 * XML section
	 */
	define('TIDY_NODETYPE_SECTION', null);

	/**
	 * start tag
	 */
	define('TIDY_NODETYPE_START', null);

	/**
	 * empty tag
	 */
	define('TIDY_NODETYPE_STARTEND', null);

	/**
	 * Text
	 */
	define('TIDY_NODETYPE_TEXT', null);

	/**
	 * XML declaration
	 */
	define('TIDY_NODETYPE_XMLDECL', null);

	define('TIDY_TAG_A', null);

	define('TIDY_TAG_ABBR', null);

	define('TIDY_TAG_ACRONYM', null);

	define('TIDY_TAG_ADDRESS', null);

	define('TIDY_TAG_ALIGN', null);

	define('TIDY_TAG_APPLET', null);

	define('TIDY_TAG_AREA', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_ARTICLE', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_ASIDE', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_AUDIO', null);

	define('TIDY_TAG_B', null);

	define('TIDY_TAG_BASE', null);

	define('TIDY_TAG_BASEFONT', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_BDI', null);

	define('TIDY_TAG_BDO', null);

	define('TIDY_TAG_BGSOUND', null);

	define('TIDY_TAG_BIG', null);

	define('TIDY_TAG_BLINK', null);

	define('TIDY_TAG_BLOCKQUOTE', null);

	define('TIDY_TAG_BODY', null);

	define('TIDY_TAG_BR', null);

	define('TIDY_TAG_BUTTON', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_CANVAS', null);

	define('TIDY_TAG_CAPTION', null);

	define('TIDY_TAG_CENTER', null);

	define('TIDY_TAG_CITE', null);

	define('TIDY_TAG_CODE', null);

	define('TIDY_TAG_COL', null);

	define('TIDY_TAG_COLGROUP', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_COMMAND', null);

	define('TIDY_TAG_COMMENT', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_DATALIST', null);

	define('TIDY_TAG_DD', null);

	define('TIDY_TAG_DEL', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_DETAILS', null);

	define('TIDY_TAG_DFN', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_DIALOG', null);

	define('TIDY_TAG_DIR', null);

	define('TIDY_TAG_DIV', null);

	define('TIDY_TAG_DL', null);

	define('TIDY_TAG_DT', null);

	define('TIDY_TAG_EM', null);

	define('TIDY_TAG_EMBED', null);

	define('TIDY_TAG_FIELDSET', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_FIGCAPTION', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_FIGURE', null);

	define('TIDY_TAG_FONT', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_FOOTER', null);

	define('TIDY_TAG_FORM', null);

	define('TIDY_TAG_FRAME', null);

	define('TIDY_TAG_FRAMESET', null);

	define('TIDY_TAG_H1', null);

	define('TIDY_TAG_H2', null);

	define('TIDY_TAG_H3', null);

	define('TIDY_TAG_H4', null);

	define('TIDY_TAG_H5', null);

	define('TIDY_TAG_H6', null);

	define('TIDY_TAG_HEAD', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_HEADER', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_HGROUP', null);

	define('TIDY_TAG_HR', null);

	define('TIDY_TAG_HTML', null);

	define('TIDY_TAG_I', null);

	define('TIDY_TAG_IFRAME', null);

	define('TIDY_TAG_ILAYER', null);

	define('TIDY_TAG_IMG', null);

	define('TIDY_TAG_INPUT', null);

	define('TIDY_TAG_INS', null);

	define('TIDY_TAG_ISINDEX', null);

	define('TIDY_TAG_KBD', null);

	define('TIDY_TAG_KEYGEN', null);

	define('TIDY_TAG_LABEL', null);

	define('TIDY_TAG_LAYER', null);

	define('TIDY_TAG_LEGEND', null);

	define('TIDY_TAG_LI', null);

	define('TIDY_TAG_LINK', null);

	define('TIDY_TAG_LISTING', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_MAIN', null);

	define('TIDY_TAG_MAP', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_MARK', null);

	define('TIDY_TAG_MARQUEE', null);

	define('TIDY_TAG_MENU', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_MENUITEM', null);

	define('TIDY_TAG_META', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_METER', null);

	define('TIDY_TAG_MULTICOL', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_NAV', null);

	define('TIDY_TAG_NOBR', null);

	define('TIDY_TAG_NOEMBED', null);

	define('TIDY_TAG_NOFRAMES', null);

	define('TIDY_TAG_NOLAYER', null);

	define('TIDY_TAG_NOSAVE', null);

	define('TIDY_TAG_NOSCRIPT', null);

	define('TIDY_TAG_OBJECT', null);

	define('TIDY_TAG_OL', null);

	define('TIDY_TAG_OPTGROUP', null);

	define('TIDY_TAG_OPTION', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_OUTPUT', null);

	define('TIDY_TAG_P', null);

	define('TIDY_TAG_PARAM', null);

	define('TIDY_TAG_PLAINTEXT', null);

	define('TIDY_TAG_PRE', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_PROGRESS', null);

	define('TIDY_TAG_Q', null);

	define('TIDY_TAG_RB', null);

	define('TIDY_TAG_RBC', null);

	define('TIDY_TAG_RP', null);

	define('TIDY_TAG_RT', null);

	define('TIDY_TAG_RTC', null);

	define('TIDY_TAG_RUBY', null);

	define('TIDY_TAG_S', null);

	define('TIDY_TAG_SAMP', null);

	define('TIDY_TAG_SCRIPT', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_SECTION', null);

	define('TIDY_TAG_SELECT', null);

	define('TIDY_TAG_SERVER', null);

	define('TIDY_TAG_SERVLET', null);

	define('TIDY_TAG_SMALL', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_SOURCE', null);

	define('TIDY_TAG_SPACER', null);

	define('TIDY_TAG_SPAN', null);

	define('TIDY_TAG_STRIKE', null);

	define('TIDY_TAG_STRONG', null);

	define('TIDY_TAG_STYLE', null);

	define('TIDY_TAG_SUB', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_SUMMARY', null);

	define('TIDY_TAG_SUP', null);

	define('TIDY_TAG_TABLE', null);

	define('TIDY_TAG_TBODY', null);

	define('TIDY_TAG_TD', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_TEMPLATE', null);

	define('TIDY_TAG_TEXTAREA', null);

	define('TIDY_TAG_TFOOT', null);

	define('TIDY_TAG_TH', null);

	define('TIDY_TAG_THEAD', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_TIME', null);

	define('TIDY_TAG_TITLE', null);

	define('TIDY_TAG_TR', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_TRACK', null);

	define('TIDY_TAG_TT', null);

	define('TIDY_TAG_U', null);

	define('TIDY_TAG_UL', null);

	define('TIDY_TAG_UNKNOWN', null);

	define('TIDY_TAG_VAR', null);

	/**
	 * Added in libtidy 5.0.0. Available as of PHP 7.4.0.
	 */
	define('TIDY_TAG_VIDEO', null);

	define('TIDY_TAG_WBR', null);

	define('TIDY_TAG_XMP', null);

}
