/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.modules.java.lsp.server.LspServerUtils;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.OutputMessage;
import org.netbeans.modules.java.lsp.server.ui.IOContext;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.util.Lookup;

public abstract class AbstractLspInputOutputProvider
implements InputOutputProvider<LspIO, PrintWriter, Void, Void> {
    protected AbstractLspInputOutputProvider() {
        if (!"org.netbeans.modules.nbcode.integration.LspInputOutputProvider".equals(this.getClass().getName())) {
            throw new IllegalStateException();
        }
    }

    public final String getId() {
        return "lspio";
    }

    public final LspIO getIO(String name, boolean newIO, Lookup lookup) {
        IOContext ioCtx = IOContext.find();
        return new LspIO(name, ioCtx, lookup);
    }

    public final Reader getIn(LspIO io) {
        return io.in;
    }

    public final PrintWriter getOut(LspIO io) {
        return new PrintWriter(io.out);
    }

    public final PrintWriter getErr(LspIO io) {
        return new PrintWriter(io.err);
    }

    public final void print(LspIO io, PrintWriter writer, String text, Hyperlink link, OutputColor color, boolean printLineEnd) {
        if (printLineEnd) {
            writer.println(text);
        } else {
            writer.print(text);
        }
    }

    public final Lookup getIOLookup(LspIO io) {
        return io.lookup;
    }

    public final void resetIO(LspIO io) {
        NbCodeLanguageClient client = io.getClient();
        if (client != null) {
            client.resetOutput(io.name);
        }
    }

    public final void showIO(LspIO io, Set<ShowOperation> operations) {
        NbCodeLanguageClient client = io.getClient();
        if (client != null) {
            client.showOutput(io.name);
        }
    }

    public final void closeIO(LspIO io) {
        NbCodeLanguageClient client = io.getClient();
        if (client != null) {
            client.closeOutput(io.name);
        }
    }

    public final boolean isIOClosed(LspIO io) {
        return io.isClosed();
    }

    public final Void getCurrentPosition(LspIO io, PrintWriter writer) {
        return null;
    }

    public final void scrollTo(LspIO io, PrintWriter writer, Void position) {
    }

    public final Void startFold(LspIO io, PrintWriter writer, boolean expanded) {
        return null;
    }

    public final void endFold(LspIO io, PrintWriter writer, Void fold) {
    }

    public final void setFoldExpanded(LspIO io, PrintWriter writer, Void fold, boolean expanded) {
    }

    public final String getIODescription(LspIO io) {
        return "";
    }

    public final void setIODescription(LspIO io, String description) {
    }

    public static final class LspIO {
        private final String name;
        private final IOContext ctx;
        private final NbCodeLanguageClient client;
        final Lookup lookup;
        final Reader in;
        final LspWriter out;
        final LspWriter err;

        LspIO(String name, IOContext ioCtx, Lookup lookup) {
            Reader in;
            this.name = name;
            this.ctx = ioCtx;
            this.lookup = lookup;
            this.out = new LspWriter(true);
            this.err = new LspWriter(false);
            try {
                final InputStream is = ioCtx.getStdIn();
                in = new InputStreamReader(is, "UTF-8"){

                    @Override
                    public void close() throws IOException {
                        is.close();
                        super.close();
                    }
                };
            }
            catch (IOException ex) {
                try {
                    this.err.write(ex.getLocalizedMessage());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in = new CharArrayReader(new char[0]){

                    @Override
                    public void close() {
                    }
                };
            }
            this.in = in;
            if (!(name.startsWith("Run") || name.startsWith("Debug") || name.startsWith("Test"))) {
                this.client = LspServerUtils.findLspClient(Lookup.getDefault());
                if (this.client != null) {
                    this.client.resetOutput(name);
                }
            } else {
                this.client = null;
            }
        }

        boolean isClosed() {
            return this.out.closed && this.err.closed;
        }

        protected NbCodeLanguageClient getClient() {
            return this.client;
        }

        private final class LspWriter
        extends Writer {
            private final boolean stdIO;
            volatile boolean closed;

            LspWriter(boolean stdIO) {
                this.stdIO = stdIO;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String chunk = new String(cbuf, off, len);
                if (LspIO.this.client != null) {
                    if (len > 0) {
                        LspIO.this.client.writeOutput(new OutputMessage(LspIO.this.name, chunk, this.stdIO));
                    }
                } else if (this.stdIO) {
                    LspIO.this.ctx.stdOut(chunk);
                } else {
                    LspIO.this.ctx.stdErr(chunk);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        }
    }
}

