/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.catalog.Catalog;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogModel;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogModelFactory;
import org.netbeans.modules.websvc.jaxws.catalog.System;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CatalogUtils {
    public static void copyCatalogEntriesForAllClients(FileObject catalog, FileObject jaxWsCatalog, JaxWsModel jaxWsModel) throws IOException {
        CatalogModel sourceModel = CatalogUtils.getCatalogModel(catalog);
        CatalogModel targetModel = CatalogUtils.getCatalogModel(jaxWsCatalog);
        Catalog cat1 = sourceModel.getRootComponent();
        Catalog cat2 = targetModel.getRootComponent();
        List<System> systemElements = cat1.getSystems();
        targetModel.startTransaction();
        for (Client client : jaxWsModel.getClients()) {
            String clientName = client.getName();
            for (System systemElement : systemElements) {
                int index;
                String uri = systemElement.getURIAttr();
                String prefix = "xml-resources/web-service-references/" + clientName + "/wsdl/";
                if (uri == null || (index = uri.indexOf(prefix)) < 0) continue;
                System system = targetModel.getFactory().createSystem();
                try {
                    system.setSystemIDAttr(new URI(systemElement.getSystemIDAttr()));
                    system.setURIAttr(new URI(uri.substring(index + prefix.length() - 5)));
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
                cat2.addSystem(system);
            }
        }
        try {
            targetModel.endTransaction();
        }
        catch (IllegalStateException ex) {
            IOException io = new IOException("Cannot modify catalog", ex);
            throw (IOException)Exceptions.attachLocalizedMessage((Throwable)io, (String)NbBundle.getMessage(CatalogUtils.class, (String)"ERR_ModifyCatalog", (Object)ex.getLocalizedMessage()));
        }
    }

    public static void copyCatalogEntriesForClient(FileObject catalog, FileObject jaxWsCatalog, String clientName) throws IOException {
        CatalogModel sourceModel = CatalogUtils.getCatalogModel(catalog);
        CatalogModel targetModel = CatalogUtils.getCatalogModel(jaxWsCatalog);
        Catalog cat1 = sourceModel.getRootComponent();
        List<System> systemElements = cat1.getSystems();
        if (systemElements.size() > 0) {
            Catalog cat2 = targetModel.getRootComponent();
            targetModel.startTransaction();
            for (System systemElement : systemElements) {
                int index;
                String uri = systemElement.getURIAttr();
                String prefix = "xml-resources/web-service-references/" + clientName + "/wsdl/";
                if (uri == null || (index = uri.indexOf(prefix)) < 0) continue;
                System system = null;
                String systemId = systemElement.getSystemIDAttr();
                if (systemId != null) {
                    for (System s : cat2.getSystems()) {
                        if (!systemId.equals(s.getSystemIDAttr())) continue;
                        system = s;
                        break;
                    }
                }
                if (system == null) {
                    system = targetModel.getFactory().createSystem();
                    cat2.addSystem(system);
                }
                try {
                    system.setSystemIDAttr(new URI(systemElement.getSystemIDAttr()));
                    system.setURIAttr(new URI(uri.substring(index + prefix.length() - 5)));
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                targetModel.endTransaction();
            }
            catch (IllegalStateException ex) {
                IOException io = new IOException("Cannot modify catalog", ex);
                throw (IOException)Exceptions.attachLocalizedMessage((Throwable)io, (String)NbBundle.getMessage(CatalogUtils.class, (String)"ERR_ModifyCatalog", (Object)ex.getLocalizedMessage()));
            }
        }
    }

    public static void updateCatalogEntriesForClient(FileObject jaxWsCatalog, String clientName) throws IOException {
        CatalogModel catalogModel = CatalogUtils.getCatalogModel(jaxWsCatalog);
        Catalog cat = catalogModel.getRootComponent();
        String prefix = "xml-resources/web-service-references/" + clientName + "/wsdl/";
        catalogModel.startTransaction();
        for (System systemElement : cat.getSystems()) {
            String uri = systemElement.getURIAttr();
            int index = uri.indexOf(prefix);
            if (index < 0) continue;
            try {
                systemElement.setURIAttr(new URI(uri.substring(index + prefix.length() - 5)));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        catalogModel.endTransaction();
    }

    public static CatalogModel getCatalogModel(FileObject thisFileObj) throws IOException {
        ModelSource source = CatalogUtils.createModelSource(thisFileObj, true);
        return CatalogModelFactory.getInstance().getModel(source);
    }

    private static ModelSource createModelSource(final FileObject thisFileObj, boolean editable) throws IOException {
        assert (thisFileObj != null) : "Null file object.";
        try {
            final DataObject dobj = DataObject.find((FileObject)thisFileObj);
            final EditorCookie editor = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (editor != null) {
                Lookup proxyLookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

                    public Lookup getLookup() {
                        try {
                            return Lookups.fixed((Object[])new Object[]{editor.openDocument(), dobj, thisFileObj});
                        }
                        catch (IOException ex) {
                            return Lookups.fixed((Object[])new Object[]{dobj, thisFileObj});
                        }
                    }
                });
                return new ModelSource(proxyLookup, editable);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }
}

