/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaBeansUtil {
    private JavaBeansUtil() {
    }

    public static void writeBeanProperty(Object obj, Writer out, String propertyName) throws IOException, IntrospectionException {
        XmlBeanWriter beanOut = new XmlBeanWriter(out);
        JavaBeansUtil.writeBeanProperty(obj, beanOut, propertyName);
    }

    public static void writeBeanProperty(Object obj, BeanWriter out, String propertyName) throws IOException, IntrospectionException {
        JavaBeansUtil.writeBeanProperty(obj, out, new HashMap(), propertyName);
    }

    public static void writeBeanProperty(Object obj, BeanWriter out, Map skipChildren, String propertyName) throws IOException, IntrospectionException {
        if (obj == null) {
            return;
        }
        out.beginPropertyName(propertyName);
        if (!JavaBeansUtil.isJavaBeanType(obj.getClass())) {
            out.writeLeafObject(obj);
        } else {
            out.beginInnerNode();
            JavaBeansUtil.writeBean(obj, out, skipChildren);
            out.endInnerNode();
        }
        out.endPropertyName(propertyName);
    }

    public static void writeBean(Object obj, Writer out) throws IOException, IntrospectionException {
        XmlBeanWriter beanOut = new XmlBeanWriter(out);
        JavaBeansUtil.writeBean(obj, beanOut);
    }

    public static void writeBean(Object obj, BeanWriter out) throws IOException, IntrospectionException {
        JavaBeansUtil.writeBean(obj, out, new HashMap());
    }

    public static void writeBean(Object obj, BeanWriter out, Map skipChildren) throws IOException, IntrospectionException {
        if (obj == null) {
            return;
        }
        if (skipChildren.containsKey(obj)) {
            return;
        }
        skipChildren.put(obj, null);
        Class<?> objCls = obj.getClass();
        BeanInfo bi = Introspector.getBeanInfo(objCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Method reader = pd.getReadMethod();
            if (reader == null) continue;
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Class<?> declaringClass = reader.getDeclaringClass();
            if (declaringClass.equals(Object.class) || propertyType == null) continue;
            Object childObj = null;
            try {
                childObj = reader.invoke(obj, null);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (childObj == null) continue;
            if (childObj instanceof Collection) {
                for (Object childElement : (Collection)childObj) {
                    JavaBeansUtil.writeBeanProperty(childElement, out, skipChildren, propertyName);
                }
                continue;
            }
            if (childObj.getClass().isArray()) {
                int size = Array.getLength(childObj);
                for (int j = 0; j < size; ++j) {
                    Object childElement = Array.get(childObj, j);
                    JavaBeansUtil.writeBeanProperty(childElement, out, skipChildren, propertyName);
                }
                continue;
            }
            JavaBeansUtil.writeBeanProperty(childObj, out, skipChildren, propertyName);
        }
        skipChildren.remove(obj);
    }

    public static Object readBean(Class cls, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor construct = cls.getConstructor(new Class[0]);
        Object newValue = construct.newInstance(new Object[0]);
        JavaBeansUtil.readBean(newValue, in);
        return newValue;
    }

    public static void readBean(Object obj, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        JavaBeansUtil.readBean(obj, new InputSource(in), false, null, null);
    }

    public static void readBeanNoEntityResolver(Object obj, InputStream in) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        JavaBeansUtil.readBean(obj, new InputSource(in), false, new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                ByteArrayInputStream bin = new ByteArrayInputStream(new byte[0]);
                return new InputSource(bin);
            }
        }, null);
    }

    public static void readBean(Object obj, InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws ParserConfigurationException, SAXException, IOException, IntrospectionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (er != null) {
            db.setEntityResolver(er);
        }
        if (eh != null) {
            db.setErrorHandler(eh);
        }
        Document doc = db.parse(in);
        JavaBeansUtil.readBean(obj, doc);
    }

    public static Object readBean(Class cls, Document document) throws IntrospectionException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor construct = cls.getConstructor(new Class[0]);
        Object newValue = construct.newInstance(new Object[0]);
        JavaBeansUtil.readBean(newValue, document);
        return newValue;
    }

    public static void readBean(Object obj, Document document) throws IntrospectionException {
        JavaBeansUtil.readBean(obj, document.getDocumentElement());
    }

    public static void readBean(Object obj, Node node) throws IntrospectionException {
        if (obj == null) {
            return;
        }
        int errorCount = 0;
        Class<?> objCls = obj.getClass();
        BeanInfo bi = Introspector.getBeanInfo(objCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Method> propertyWriters = new HashMap<String, Method>();
        HashMap propertyTypes = new HashMap();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Class<?> declaringClass = writer.getDeclaringClass();
            if (declaringClass == null || declaringClass.equals(Object.class) || propertyType == null) continue;
            propertyWriters.put(propertyName, writer);
            propertyTypes.put(propertyName, propertyType);
        }
        HashMap<String, Object> propertiesNewValues = new HashMap<String, Object>();
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                String attrName = attr.getName();
                if (!(propertyWriters.containsKey(attrName) || propertyWriters.containsKey(attrName = Common.convertName(attrName)) || propertyWriters.containsKey(attrName = Introspector.decapitalize(attrName)))) {
                    ++errorCount;
                    System.out.println("Found attribute and did not find property in Java Bean: " + attr.getName());
                    continue;
                }
                Object newValue = JavaBeansUtil.convertValue((Class)propertyTypes.get(attrName), attr.getValue());
                propertiesNewValues.put(attrName, newValue);
            }
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            String childNodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            String string = childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            if (!(propertyWriters.containsKey(childNodeName) || propertyWriters.containsKey(childNodeName = Common.convertName(childNodeName)) || propertyWriters.containsKey(childNodeName = Introspector.decapitalize(childNodeName)))) {
                ++errorCount;
                System.out.println("Found element and did not find property in Java Bean: " + childNode.getNodeName());
                continue;
            }
            Class<?> propertyType = (Class<?>)propertyTypes.get(childNodeName);
            Object newValue = null;
            if (JavaBeansUtil.isJavaBeanType(propertyType)) {
                Class<?> propertyTypeOnce = propertyType;
                if (propertyType.isArray()) {
                    propertyTypeOnce = propertyType.getComponentType();
                }
                try {
                    Constructor<?> construct = propertyTypeOnce.getConstructor(new Class[0]);
                    newValue = construct.newInstance(new Object[0]);
                    JavaBeansUtil.readBean(newValue, childNode);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    ++errorCount;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    ++errorCount;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    ++errorCount;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    ++errorCount;
                }
            } else {
                String nodeValue = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
                Class<?> typeOfNewValue = propertyType;
                if (propertyType.isArray()) {
                    typeOfNewValue = propertyType.getComponentType();
                }
                newValue = JavaBeansUtil.convertValue(typeOfNewValue, nodeValue);
            }
            if (propertyType.isArray()) {
                ArrayList<Object> values = (ArrayList<Object>)propertiesNewValues.get(childNodeName);
                if (values == null) {
                    values = new ArrayList<Object>();
                    propertiesNewValues.put(childNodeName, values);
                }
                values.add(newValue);
                continue;
            }
            propertiesNewValues.put(childNodeName, newValue);
        }
        for (String propertyName : propertiesNewValues.keySet()) {
            Object newValue;
            Class propertyType = (Class)propertyTypes.get(propertyName);
            Method writer = (Method)propertyWriters.get(propertyName);
            if (propertyType.isArray()) {
                List values = (List)propertiesNewValues.get(propertyName);
                newValue = Array.newInstance(propertyType.getComponentType(), values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(newValue, i, values.get(i));
                }
            } else {
                newValue = propertiesNewValues.get(propertyName);
            }
            try {
                writer.invoke(obj, newValue);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                ++errorCount;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                ++errorCount;
            }
        }
    }

    public static void copyBean(Object src, Object dest) throws IntrospectionException {
        JavaBeansUtil.copyBean(src, dest, Collections.emptyMap());
    }

    public static void copyBean(Object src, Object dest, Map nameMapping) throws IntrospectionException {
        if (src == null) {
            return;
        }
        Class<?> srcCls = src.getClass();
        BeanInfo bi = Introspector.getBeanInfo(srcCls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Method> propertyReaders = new HashMap<String, Method>();
        HashMap propertyTypes = new HashMap();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Method reader = pd.getReadMethod();
            if (reader == null) continue;
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Class<?> declaringClass = reader.getDeclaringClass();
            if (declaringClass == null || declaringClass.equals(Object.class) || propertyType == null) continue;
            if (nameMapping.containsKey(propertyName)) {
                propertyName = (String)nameMapping.get(propertyName);
            }
            propertyReaders.put(propertyName, reader);
            propertyTypes.put(propertyName, propertyType);
        }
        Class<?> destCls = dest.getClass();
        bi = Introspector.getBeanInfo(destCls);
        pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Class<?> declaringClass = writer.getDeclaringClass();
            if (declaringClass == null || declaringClass.equals(Object.class) || propertyType == null || !propertyReaders.containsKey(propertyName)) continue;
            try {
                Method reader = (Method)propertyReaders.get(propertyName);
                Object srcValue = reader.invoke(src, null);
                if (JavaBeansUtil.isJavaBeanType(propertyType)) {
                    Class<?> propertyTypeOnce = propertyType;
                    int size = 1;
                    Object destValue = null;
                    if (propertyType.isArray()) {
                        propertyTypeOnce = propertyType.getComponentType();
                        size = Array.getLength(srcValue);
                        destValue = Array.newInstance(propertyTypeOnce, size);
                    }
                    for (int index = 0; index < size; ++index) {
                        Object srcValueOnce;
                        Constructor<?> construct = propertyTypeOnce.getConstructor(new Class[0]);
                        Object destValueOnce = construct.newInstance(new Object[0]);
                        if (propertyType.isArray()) {
                            Array.set(destValue, index, destValueOnce);
                            srcValueOnce = Array.get(srcValue, index);
                        } else {
                            destValue = destValueOnce;
                            srcValueOnce = srcValue;
                        }
                        JavaBeansUtil.copyBean(srcValueOnce, destValueOnce, nameMapping);
                    }
                    writer.invoke(dest, destValue);
                    continue;
                }
                if (!propertyType.isAssignableFrom((Class)propertyTypes.get(propertyName))) continue;
                writer.invoke(dest, srcValue);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isJavaBeanType(Class type) {
        if (Collection.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.isArray()) {
            return JavaBeansUtil.isJavaBeanType(type.getComponentType());
        }
        String typeName = type.getName().intern();
        return typeName != "java.lang.String" && typeName != "java.lang.Integer" && typeName != "int" && typeName != "java.lang.Character" && typeName != "char" && typeName != "java.lang.Long" && typeName != "long" && typeName != "java.lang.Float" && typeName != "float" && typeName != "java.lang.Double" && typeName != "double" && typeName != "java.lang.Boolean" && typeName != "boolean" && typeName != "java.lang.Short" && typeName != "short" && typeName != "java.lang.Byte" && typeName != "byte" && typeName != "java.math.BigDecimal" && typeName != "java.math.BigInteger" && typeName != "java.lang.Object" && typeName != "java.util.Calendar" && typeName != "java.util.Date" && typeName != "java.util.GregorianCalendar" && typeName != "javax.xml.namespace.QName" && typeName != "java.net.URL" && typeName != "java.net.URI";
    }

    public static Object convertValue(Class type, String value) {
        String typeName = type.getName().intern();
        if (typeName == "java.lang.String") {
            return value;
        }
        if (typeName == "java.lang.Boolean" || typeName == "boolean") {
            return Boolean.valueOf(value);
        }
        if (typeName == "java.lang.Integer" || typeName == "int") {
            return Integer.valueOf(value);
        }
        if (typeName == "java.lang.Long" || typeName == "long") {
            return Long.valueOf(value);
        }
        if (typeName == "java.lang.Float" || typeName == "float") {
            return Float.valueOf(value);
        }
        if (typeName == "java.lang.Double" || typeName == "double") {
            return Double.valueOf(value);
        }
        if (typeName == "java.lang.Byte" || typeName == "byte") {
            return Byte.valueOf(value);
        }
        if (typeName == "java.lang.Short" || typeName == "short") {
            return Short.valueOf(value);
        }
        if (typeName == "java.lang.Character" || typeName == "char") {
            return new Character(value.charAt(0));
        }
        if (typeName == "java.net.URL") {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (typeName == "java.net.URI") {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (typeName == "java.math.BigDecimal") {
            return new BigDecimal(value);
        }
        if (typeName == "java.math.BigInteger") {
            return new BigInteger(value);
        }
        if (typeName == "java.util.Calendar") {
            TimeZone tz = TimeZone.getDefault();
            Calendar cal = Calendar.getInstance(tz);
            Date date = null;
            String[] possibleFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};
            ParsePosition pos = null;
            for (int formatNum = 0; formatNum < possibleFormats.length; ++formatNum) {
                pos = new ParsePosition(0);
                SimpleDateFormat formatter = new SimpleDateFormat(possibleFormats[formatNum]);
                formatter.setCalendar(cal);
                date = formatter.parse(value, pos);
                if (date != null) break;
            }
            if (date == null) {
                throw new RuntimeException(Common.getMessage("MSG_BadParse", value));
            }
            cal.setTime(date);
            return cal;
        }
        Constructor c = null;
        try {
            Class[] cc = new Class[]{String.class};
            c = type.getDeclaredConstructor(cc);
            Object[] p = new Object[]{value};
            return c.newInstance(p);
        }
        catch (NoSuchMethodException me) {
            throw new RuntimeException(me);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void genReadType(Writer out, String typeName) throws IOException {
        if ((typeName = typeName.intern()) == "java.util.Calendar") {
            out.write("public static java.util.Calendar stringToCalendar(String value) throws java.text.ParseException {\n");
            out.write("java.util.TimeZone tz = java.util.TimeZone.getDefault();\n");
            out.write("java.util.Calendar cal = java.util.Calendar.getInstance(tz);\n");
            out.write("java.util.Date date = null;\n");
            out.write("String[] possibleFormats = {\"yyyy-MM-dd'T'HH:mm:ss.S\", \"yyyy-MM-dd'T'HH:mm:ss\", \"yyyy-MM-dd\"};\t// NOI18N\n");
            out.write("java.text.ParsePosition pos = null;\n");
            out.write("for (int formatNum = 0; formatNum < possibleFormats.length; ++formatNum) {\n");
            out.write("pos = new java.text.ParsePosition(0);\n");
            out.write("java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat(possibleFormats[formatNum]);\n");
            out.write("formatter.setCalendar(cal);\n");
            out.write("date = formatter.parse(value, pos);\n");
            out.write("if (date != null) {\n");
            out.write("break;\n");
            out.write("}\n");
            out.write("}\n");
            out.write("if (date == null) {\n");
            out.write("throw new java.text.ParseException(\"Bad time/date parse of \"+value, pos.getErrorIndex());\n");
            out.write("}\n");
            out.write("int len = value.length();\n");
            out.write("if (pos.getIndex() < len) {\n");
            out.write("if (value.charAt(pos.getIndex()) == 'Z') {\n");
            out.write("// The Timezone is UTC\n");
            out.write("tz = java.util.TimeZone.getTimeZone(\"GMT\");\n");
            out.write("cal.setTimeZone(tz);\n");
            out.write("} else {\n");
            out.write("tz = java.util.TimeZone.getTimeZone(\"GMT\"+value.substring(pos.getIndex(), len));\n");
            out.write("cal.setTimeZone(tz);\n");
            out.write("}\n");
            out.write("}\n");
            out.write("cal.setTime(date);\n");
            out.write("return cal;\n");
            out.write("}\n");
        } else if (typeName == "base64Binary") {
            out.write("public static byte[] decodeBase64BinaryString(String text) {\n");
            out.write("final int decodeBase64Table[] = {62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};\n");
            out.write("StringBuffer cleanedEncoding = new StringBuffer();\n");
            out.write("int len = text.length();\n");
            out.write("// Get rid of extraneous characters (like whitespace).\n");
            out.write("for (int i = 0; i < len; ++i) {\n");
            out.write("if (text.charAt(i) > 0x20) {\n");
            out.write("cleanedEncoding.append(text.charAt(i));\n");
            out.write("}\n");
            out.write("}\n");
            out.write("char[] encodedText = cleanedEncoding.toString().toCharArray();\n");
            out.write("len = encodedText.length;\n");
            out.write("if (len == 0) {\n");
            out.write("return new byte[0];\n");
            out.write("}\n");
            out.write("int howManyBlocks = len / 4;\n");
            out.write("int partialLen = 3;\n");
            out.write("if (encodedText[len-1] == '=') {\n");
            out.write("partialLen -= 1;\n");
            out.write("if (encodedText[len-2] == '=') {\n");
            out.write("partialLen -= 1;\n");
            out.write("}\n");
            out.write("}\n");
            out.write("int resultLen = partialLen + (howManyBlocks - 1) * 3;\n");
            out.write("byte[] result = new byte[resultLen];\n");
            out.write("int resultIndex = 0;\n");
            out.write("int encodedTextIndex = 0;\n");
            out.write("for (int blockNum = 0; blockNum < howManyBlocks; ++blockNum) {\n");
            out.write("int a = decodeBase64Table[encodedText[encodedTextIndex++] - '+'];\n");
            out.write("int b = decodeBase64Table[encodedText[encodedTextIndex++] - '+'];\n");
            out.write("int c = decodeBase64Table[encodedText[encodedTextIndex++] - '+'];\n");
            out.write("int d = decodeBase64Table[encodedText[encodedTextIndex++] - '+'];\n");
            out.write("result[resultIndex++] = (byte) ( (b >> 4) | (a << 2) );\n");
            out.write("if (resultIndex < resultLen) {\n");
            out.write("result[resultIndex++] = (byte) ( ((b & 0xf) << 4) | (c >> 2) );\n");
            out.write("}\n");
            out.write("if (resultIndex < resultLen) {\n");
            out.write("result[resultIndex++] = (byte) ( ((c & 0x3) << 6) | d);\n");
            out.write("}\n");
            out.write("}\n");
            out.write("return result;\n");
            out.write("}\n");
        }
    }

    public static void genWriteType(Writer out, String typeName) throws IOException {
        if ((typeName = typeName.intern()) == "java.util.Calendar") {
            out.write("public static String calendarToString(java.util.Calendar cal) {\n");
            out.write("java.util.Date date = cal.getTime();\n");
            out.write("java.text.SimpleDateFormat formatter;\n");
            out.write("if (cal.get(java.util.Calendar.HOUR) == 0 && cal.get(java.util.Calendar.MINUTE) == 0 && cal.get(java.util.Calendar.SECOND) == 0) {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd\");\t// NOI18N\n");
            out.write("} else if (cal.get(java.util.Calendar.MILLISECOND) == 0) {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss\");\t// NOI18N\n");
            out.write("} else {\n");
            out.write("formatter = new java.text.SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss.S\");\t// NOI18N\n");
            out.write("}\n");
            out.write("String result = formatter.format(date);\n");
            out.write("if (java.util.TimeZone.getDefault().hasSameRules(cal.getTimeZone())) {\n");
            out.write("return result;\n");
            out.write("}\n");
            out.write("int offset = cal.getTimeZone().getOffset(0);\n");
            out.write("if (offset == 0) {\n");
            out.write("return result+\"Z\";\n");
            out.write("}\n");
            out.write("int seconds = offset / 1000;\n");
            out.write("if (seconds > 0) {\n");
            out.write("result += \"+\";\n");
            out.write("} else {\n");
            out.write("seconds = -1 * seconds;\n");
            out.write("result += \"-\";\n");
            out.write("}\n");
            out.write("int hours = seconds / 3600;\n");
            out.write("if (hours < 10) {\n");
            out.write("result += \"0\";\n");
            out.write("}\n");
            out.write("result += hours + \":\";\n");
            out.write("int minutes = (seconds / 60) % 60;\n");
            out.write("if (minutes < 10) {\n");
            out.write("result += \"0\";\n");
            out.write("}\n");
            out.write("result += minutes;\n");
            out.write("return result;\n");
            out.write("}\n");
        } else if (typeName == "base64Binary") {
            out.write("public static String encodeBase64BinaryString(byte[] instance) {\n");
            out.write("final char encodeBase64Table[] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};\n");
            out.write("byte[] value = (byte[]) instance;\n");
            out.write("int len = value.length;\n");
            out.write("if (len == 0) {\n");
            out.write("return \"\";\n");
            out.write("}\n");
            out.write("int howManyBlocks = len / 3;\n");
            out.write("int partialLen = len % 3;\n");
            out.write("if (partialLen != 0) {\n");
            out.write("howManyBlocks += 1;\n");
            out.write("}\n");
            out.write("int resultLen = howManyBlocks * 4;\n");
            out.write("StringBuffer result = new StringBuffer(resultLen);\n");
            out.write("int valueIndex = 0;\n");
            out.write("for (int blockNum = 0; blockNum < howManyBlocks; ++blockNum) {\n");
            out.write("int a = value[valueIndex++];\n");
            out.write("int b;\n");
            out.write("int c;\n");
            out.write("if (valueIndex < len) {\n");
            out.write("b = value[valueIndex++];\n");
            out.write("} else {\n");
            out.write("b = 0;\n");
            out.write("}\n");
            out.write("if (valueIndex < len) {\n");
            out.write("c = value[valueIndex++];\n");
            out.write("} else {\n");
            out.write("c = 0;\n");
            out.write("}\n");
            out.write("if (a < 0) {\n");
            out.write("a += 256;\n");
            out.write("}\n");
            out.write("if (b < 0) {\n");
            out.write("b += 256;\n");
            out.write("}\n");
            out.write("if (c < 0) {\n");
            out.write("c += 256;\n");
            out.write("}\n");
            out.write("result.append(encodeBase64Table[a >> 2]);\n");
            out.write("result.append(encodeBase64Table[((a & 0x3) << 4) | (b >> 4)]);\n");
            out.write("result.append(encodeBase64Table[((b & 0xf) << 2) | (c >> 6)]);\n");
            out.write("result.append(encodeBase64Table[c & 0x3f]);\n");
            out.write("}\n");
            out.write("if (partialLen == 1) {\n");
            out.write("result.setCharAt(resultLen - 1, '=');\n");
            out.write("result.setCharAt(resultLen - 2, '=');\n");
            out.write("} else if (partialLen == 2) {\n");
            out.write("result.setCharAt(resultLen - 1, '=');\n");
            out.write("}\n");
            out.write("return result.toString();\n");
            out.write("}\n");
        }
    }

    public static Object dummyBean(Class cls, int arraySize) throws IntrospectionException {
        if (!JavaBeansUtil.isJavaBeanType(cls)) {
            return JavaBeansUtil.dummyValue(cls, arraySize);
        }
        Object obj = null;
        try {
            Constructor construct = cls.getConstructor(new Class[0]);
            obj = construct.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        BeanInfo bi = Introspector.getBeanInfo(cls);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            int ii;
            Class<?> baseType;
            PropertyDescriptor pd = pds[i];
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Class<?> declaringClass = writer.getDeclaringClass();
            if (declaringClass == null || declaringClass.equals(Object.class) || propertyType == null) continue;
            Object newValue = null;
            Object baseValue = null;
            if (JavaBeansUtil.isJavaBeanType(propertyType)) {
                baseType = propertyType;
                if (propertyType.isArray()) {
                    baseType = propertyType.getComponentType();
                }
                baseValue = JavaBeansUtil.dummyBean(baseType, arraySize);
                if (propertyType.isArray()) {
                    newValue = Array.newInstance(baseType, arraySize);
                    for (ii = 0; ii < arraySize; ++ii) {
                        Array.set(newValue, ii, baseValue);
                    }
                } else {
                    newValue = baseValue;
                }
            } else {
                baseType = propertyType;
                if (propertyType.isArray()) {
                    baseType = propertyType.getComponentType();
                }
                baseValue = JavaBeansUtil.dummyValue(baseType, arraySize);
                if (propertyType.isArray()) {
                    newValue = Array.newInstance(baseType, arraySize);
                    for (ii = 0; ii < arraySize; ++ii) {
                        Array.set(newValue, ii, baseValue);
                    }
                } else {
                    newValue = baseValue;
                }
            }
            try {
                writer.invoke(obj, newValue);
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static Object dummyValue(Class type, int arraySize) {
        String typeName = type.getName().intern();
        if (Collection.class.isAssignableFrom(type)) {
            ArrayList<String> lst = new ArrayList<String>();
            for (int ii = 0; ii < arraySize; ++ii) {
                lst.add("collection-element");
            }
            return lst;
        }
        if (typeName == "java.lang.String") {
            return "string";
        }
        if (typeName == "java.lang.Boolean" || typeName == "boolean") {
            return Boolean.FALSE;
        }
        if (typeName == "java.lang.Integer" || typeName == "int") {
            return Integer.valueOf("1");
        }
        if (typeName == "java.lang.Long" || typeName == "long") {
            return Long.valueOf("1");
        }
        if (typeName == "java.lang.Float" || typeName == "float") {
            return Float.valueOf("1.0");
        }
        if (typeName == "java.lang.Double" || typeName == "double") {
            return Double.valueOf("1.0");
        }
        if (typeName == "java.lang.Byte" || typeName == "byte") {
            return Byte.valueOf("1");
        }
        if (typeName == "java.lang.Short" || typeName == "short") {
            return Short.valueOf("1");
        }
        if (typeName == "java.lang.Character" || typeName == "char") {
            return new Character('C');
        }
        if (typeName == "java.math.BigDecimal") {
            return new BigDecimal("1.0");
        }
        if (typeName == "java.math.BigInteger") {
            return new BigInteger("1");
        }
        if (typeName == "java.util.Calendar") {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            return cal;
        }
        Constructor c = null;
        try {
            Class[] cc = new Class[]{String.class};
            c = type.getDeclaredConstructor(cc);
            Object[] p = new Object[]{"string"};
            return c.newInstance(p);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class XmlBeanWriter
    extends IndentingBeanWriter
    implements BeanWriter {
        protected Writer out;

        public XmlBeanWriter(Writer out) {
            this.out = out;
        }

        public XmlBeanWriter(Writer out, String indentBy) {
            super(indentBy);
            this.out = out;
        }

        public XmlBeanWriter(Writer out, String indent, String indentBy) {
            super(indent, indentBy);
            this.out = out;
        }

        @Override
        public void beginPropertyName(String propertyName) throws IOException {
            this.out.write(this.indent);
            this.out.write("<" + propertyName + ">");
        }

        @Override
        public void endPropertyName(String propertyName) throws IOException {
            this.out.write("</" + propertyName + ">\n");
        }

        @Override
        public void writeLeafObject(Object obj) throws IOException {
            XMLUtil.printXML(this.out, obj.toString(), false);
        }

        @Override
        public void beginInnerNode() throws IOException {
            super.beginInnerNode();
            this.out.write("\n");
        }

        @Override
        public void endInnerNode() throws IOException {
            super.endInnerNode();
            this.out.write(this.indent);
        }
    }

    public static interface BeanWriter {
        public void beginPropertyName(String var1) throws IOException;

        public void endPropertyName(String var1) throws IOException;

        public void writeLeafObject(Object var1) throws IOException;

        public void beginInnerNode() throws IOException;

        public void endInnerNode() throws IOException;
    }

    public static class HtmlBeanWriter
    extends IndentingBeanWriter
    implements BeanWriter {
        protected Writer out;

        public HtmlBeanWriter(Writer out) {
            this.out = out;
        }

        public HtmlBeanWriter(Writer out, String indentBy) {
            super(indentBy);
            this.out = out;
        }

        public HtmlBeanWriter(Writer out, String indent, String indentBy) {
            super(indent, indentBy);
            this.out = out;
        }

        @Override
        public void beginPropertyName(String propertyName) throws IOException {
            this.out.write(this.indent);
            this.out.write("<tr>");
            this.out.write("<th>" + propertyName + "</th>");
        }

        @Override
        public void endPropertyName(String propertyName) throws IOException {
            this.out.write("</tr>");
            this.out.write("\n");
        }

        @Override
        public void writeLeafObject(Object obj) throws IOException {
            this.out.write("<td>");
            XMLUtil.printXML(this.out, obj.toString(), false);
            this.out.write("</td>");
        }

        @Override
        public void beginInnerNode() throws IOException {
            super.beginInnerNode();
            this.out.write("<td><table width=\"100%\" border=\"1\">");
            this.out.write("\n");
        }

        @Override
        public void endInnerNode() throws IOException {
            super.endInnerNode();
            this.out.write(this.indent);
            this.out.write("</table></td>");
        }
    }

    public static abstract class IndentingBeanWriter
    implements BeanWriter {
        protected String indentBy;
        protected String indent;
        protected int indentLevel = 0;
        protected List indentions;

        public IndentingBeanWriter() {
            this("", "\t");
        }

        public IndentingBeanWriter(String indentBy) {
            this("", indentBy);
        }

        public IndentingBeanWriter(String indent, String indentBy) {
            this.indent = indent;
            this.indentBy = indentBy;
            this.indentions = new ArrayList();
            this.indentions.add(indent);
        }

        @Override
        public void beginInnerNode() throws IOException {
            ++this.indentLevel;
            int indentionsSize = this.indentions.size();
            if (indentionsSize <= this.indentLevel) {
                this.indent = (String)this.indentions.get(indentionsSize - 1);
                do {
                    this.indent = this.indent + this.indentBy;
                    this.indentions.add(this.indent);
                } while (++indentionsSize <= this.indentLevel);
            } else {
                this.indent = (String)this.indentions.get(this.indentLevel);
            }
        }

        @Override
        public void endInnerNode() throws IOException {
            --this.indentLevel;
            this.indent = (String)this.indentions.get(this.indentLevel);
        }
    }
}

