/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.openide.util.NbBundle;

public class CodeSetupPanel
extends JPanel {
    private ParamTableModel tableModel;
    private List<ParameterInfo> inputParams;
    private boolean methodNameModified = false;
    private boolean showParamTypes;
    private Dialog dialog;
    private JLabel paramLabel;
    private JScrollPane paramScrollPane;
    private JTable paramTable;

    public CodeSetupPanel(List<ParameterInfo> inputParams) {
        this(inputParams, true);
    }

    public CodeSetupPanel(List<ParameterInfo> inputParams, boolean showParamTypes) {
        this.initComponents();
        this.inputParams = inputParams;
        this.showParamTypes = showParamTypes;
        this.tableModel = new ParamTableModel();
        this.paramTable.setModel(this.tableModel);
        this.paramTable.addKeyListener(new TableKeyListener());
    }

    public void setDialog(Dialog d) {
        this.dialog = d;
    }

    private void initComponents() {
        this.paramLabel = new JLabel();
        this.paramScrollPane = new JScrollPane();
        this.paramTable = new ParamTable();
        this.paramLabel.setLabelFor(this.paramTable);
        this.paramLabel.setText(NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_Parameters"));
        this.paramTable.setAutoResizeMode(3);
        this.paramScrollPane.setViewportView(this.paramTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paramLabel, -1, 614, Short.MAX_VALUE).addComponent(this.paramScrollPane, -1, 614, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.paramLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramScrollPane, -1, 204, Short.MAX_VALUE).addContainerGap()));
        this.paramLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeSetupPanel.class, (String)"ACSN_Parameters"));
        this.paramLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeSetupPanel.class, (String)"ACSD_Parameters"));
    }

    private class ParamTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Class[] types;
        boolean[] canEdit;

        public ParamTableModel() {
            if (CodeSetupPanel.this.showParamTypes) {
                this.columnNames = new String[]{NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_Name"), NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_Type"), NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_DefaultValue")};
                this.types = new Class[]{String.class, Class.class, Object.class};
                this.canEdit = new boolean[]{false, false, true};
            } else {
                this.columnNames = new String[]{NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_Name"), NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_DefaultValue")};
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return CodeSetupPanel.this.inputParams.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ParameterInfo info = (ParameterInfo)CodeSetupPanel.this.inputParams.get(row);
            if (CodeSetupPanel.this.showParamTypes) {
                switch (column) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return info.getType();
                    }
                    case 2: {
                        return info.getDefaultValue();
                    }
                    case 3: {
                        return info.getStyle() == ParameterInfo.ParamStyle.QUERY;
                    }
                }
            } else {
                switch (column) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return info.getDefaultValue();
                    }
                    case 2: {
                        return info.getStyle() == ParameterInfo.ParamStyle.QUERY;
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ParameterInfo info = (ParameterInfo)CodeSetupPanel.this.inputParams.get(row);
            int columnOffset = 0;
            if (CodeSetupPanel.this.showParamTypes) {
                columnOffset = 1;
            }
            if (column == columnOffset + 1) {
                info.setDefaultValue(value);
            } else if (column == columnOffset + 2) {
                if (((Boolean)value).booleanValue()) {
                    info.setStyle(ParameterInfo.ParamStyle.QUERY);
                } else {
                    info.setStyle(ParameterInfo.ParamStyle.UNKNOWN);
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }
    }

    private class TableKeyListener
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                CodeSetupPanel.this.dialog.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class ParamTable
    extends JTable {
        private ParamTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (CodeSetupPanel.this.showParamTypes) {
                Class type;
                String paramName = (String)CodeSetupPanel.this.tableModel.getValueAt(row, 0);
                Class clazz = type = column == 2 ? (Class)CodeSetupPanel.this.tableModel.getValueAt(row, 1) : Boolean.class;
                if (Enum.class.isAssignableFrom(type)) {
                    JComboBox combo = new JComboBox(type.getEnumConstants());
                    return new DefaultCellEditor(combo);
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    JCheckBox cb = new JCheckBox();
                    cb.setHorizontalAlignment(0);
                    cb.setBorderPainted(true);
                    return new DefaultCellEditor(cb);
                }
                if (paramName.toLowerCase().contains("password")) {
                    return new DefaultCellEditor(new JPasswordField());
                }
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column != 0) {
                return new ParamCellRenderer();
            }
            return super.getCellRenderer(row, column);
        }
    }

    private class ParamCellRenderer
    extends DefaultTableCellRenderer {
        private ParamCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String paramName = (String)CodeSetupPanel.this.tableModel.getValueAt(row, 0);
            if (value == null) {
                return new JLabel(NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_NotSet"));
            }
            if (value instanceof Class) {
                return new JLabel(((Class)value).getName());
            }
            if (value instanceof Boolean) {
                JCheckBox cb = new JCheckBox();
                cb.setHorizontalAlignment(0);
                cb.setBorderPainted(true);
                cb.setSelected((Boolean)value);
                return cb;
            }
            if (paramName.contains("password")) {
                return new JPasswordField((String)value);
            }
            return ret;
        }
    }
}

