/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class RemoveRemoteCommand
extends GitCommand {
    private final String remote;

    public RemoveRemoteCommand(Repository repository, GitClassFactory gitFactory, String remote, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.remote = remote;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        StoredConfig config = repository.getConfig();
        config.unsetSection("remote", this.remote);
        Set subSections = config.getSubsections("branch");
        for (String subSection : subSections) {
            if (!this.remote.equals(config.getString("branch", subSection, "remote"))) continue;
            config.unset("branch", subSection, "remote");
            config.unset("branch", subSection, "merge");
        }
        try {
            config.save();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git remote rm " + this.remote;
    }
}

