/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.vars.models;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class WatchesModel
extends VariablesModel
implements TreeModelFilter {
    public static final String ICON_WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private final RequestProcessor RP = new RequestProcessor(WatchesModel.class);
    private final Map<Watch, Pair<V8Value, String>> evaluatedWatches = new HashMap<Watch, Pair<V8Value, String>>();
    private WatchesListener wlistener = new WatchesListener(this);

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public Object getRoot(TreeModel original) {
        return "Root";
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildren() should be called instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            this.evaluateWatches(this.dbg.getCurrentFrame());
            return original.getChildren(parent, from, to);
        }
        if (parent instanceof Watch) {
            Pair<V8Value, String> ew;
            Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get((Watch)parent);
            }
            V8Value value = ew != null ? (V8Value)ew.first() : null;
            if (value instanceof V8Object) {
                return this.getObjectChildren((V8Object)value);
            }
            return EMPTY_CHILDREN;
        }
        return super.getChildren(parent, from, to);
    }

    @Override
    public int getChildrenCount(Object node) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.getChildrenCount() should be called instead!");
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        throw new IllegalStateException("TreeModelFilter.isLeaf() should be called instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Watch) {
            Pair<V8Value, String> ew;
            Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get((Watch)node);
            }
            V8Value value = ew != null ? (V8Value)ew.first() : null;
            return !WatchesModel.hasChildren(value);
        }
        return super.isLeaf(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return "";
        }
        return super.getShortDescription(node);
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            return ((Watch)node).getExpression();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof Watch) {
            return ICON_WATCH;
        }
        return super.getIconBaseWithExtension(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            Pair<V8Value, String> ew;
            Watch watch = (Watch)node;
            Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
            synchronized (map) {
                ew = this.evaluatedWatches.get(watch);
            }
            if (ew != null) {
                if (ew.second() != null) {
                    if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                        return WatchesModel.toHTML((String)((String)ew.second()), (boolean)true, (boolean)false, (Color)Color.red);
                    }
                    if ("WatchType".equals(columnID)) {
                        return "";
                    }
                } else {
                    V8Value value = (V8Value)ew.first();
                    if (value != null) {
                        if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                            return WatchesModel.toHTML((String)V8Evaluator.getStringValue((V8Value)value));
                        }
                        if ("WatchType".equals(columnID)) {
                            return WatchesModel.toHTML((String)V8Evaluator.getStringType((V8Value)value));
                        }
                    }
                }
            }
            if ("WatchValue".equals(columnID) || "WatchToString".equals(columnID)) {
                return watch.isEnabled() ? "N/A" : "";
            }
            if ("WatchType".equals(columnID)) {
                return "";
            }
        } else {
            if ("WatchValue".equals(columnID)) {
                return super.getValueAt(node, "LocalsValue");
            }
            if ("WatchType".equals(columnID)) {
                return super.getValueAt(node, "LocalsType");
            }
            if ("WatchToString".equals(columnID) || "LocalsToString".equals(columnID)) {
                return super.getValueAt(node, "LocalsToString");
            }
        }
        throw new UnknownTypeException(node);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished() {
        super.notifyFinished();
        if (this.wlistener != null) {
            this.wlistener.unregister();
            this.wlistener = null;
        }
        Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
        synchronized (map) {
            this.evaluatedWatches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateWatches(CallFrame frame) {
        if (frame == null) {
            Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
            synchronized (map) {
                this.evaluatedWatches.clear();
            }
            return;
        }
        Watch[] watches = DebuggerManager.getDebuggerManager().getWatches();
        HashMap<Watch, Pair> watchesMap = null;
        int n = watches.length;
        if (n > 0) {
            int i;
            WatchCB[] cbs = new WatchCB[n];
            for (i = 0; i < n; ++i) {
                if (!watches[i].isEnabled()) continue;
                cbs[i] = new WatchCB();
                V8Request request = this.dbg.sendCommandRequest(V8Command.Evaluate, (V8Arguments)new Evaluate.Arguments(watches[i].getExpression()), (V8Debugger.CommandResponseCallback)cbs[i]);
                if (request != null) continue;
                cbs[i] = null;
                break;
            }
            watchesMap = new HashMap<Watch, Pair>();
            for (i = 0; i < n; ++i) {
                WatchCB cb = cbs[i];
                if (cb == null) continue;
                watchesMap.put(watches[i], Pair.of((Object)cb.getValue(), (Object)cb.getError()));
            }
        }
        Map<Watch, Pair<V8Value, String>> map = this.evaluatedWatches;
        synchronized (map) {
            this.evaluatedWatches.clear();
            if (watchesMap != null) {
                this.evaluatedWatches.putAll(watchesMap);
            }
        }
    }

    private void reevaluateWatch(final Watch watch) {
        this.RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Pair result = null;
                if (watch.isEnabled()) {
                    WatchCB wcb = new WatchCB();
                    V8Request request = WatchesModel.this.dbg.sendCommandRequest(V8Command.Evaluate, (V8Arguments)new Evaluate.Arguments(watch.getExpression()), (V8Debugger.CommandResponseCallback)wcb);
                    if (request != null) {
                        result = Pair.of((Object)wcb.getValue(), (Object)wcb.getError());
                    }
                }
                Map map = WatchesModel.this.evaluatedWatches;
                synchronized (map) {
                    if (result == null) {
                        WatchesModel.this.evaluatedWatches.remove(watch);
                    } else {
                        WatchesModel.this.evaluatedWatches.put(watch, result);
                    }
                }
                WatchesModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
            }
        });
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WatchesModel model;

        public WatchesListener(WatchesModel watchesModel) {
            Watch[] watches;
            this.model = watchesModel;
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void watchAdded(Watch watch) {
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        public void watchRemoved(Watch watch) {
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            this.model.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            this.model.reevaluateWatch(w);
        }

        private void unregister() {
            Watch[] watches;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    static final class WatchCB
    implements V8Debugger.CommandResponseCallback {
        private boolean responded;
        private V8Value value;
        private String error;

        WatchCB() {
        }

        public synchronized void notifyResponse(V8Request request, V8Response response) {
            if (response != null) {
                if (response.isSuccess()) {
                    this.error = null;
                    Evaluate.ResponseBody erb = (Evaluate.ResponseBody)response.getBody();
                    this.value = erb.getValue();
                } else {
                    this.error = response.getErrorMessage();
                    this.value = null;
                }
            }
            this.responded = true;
            this.notifyAll();
        }

        public synchronized V8Value getValue() {
            if (!this.responded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.value;
        }

        public synchronized String getError() {
            if (!this.responded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.error;
        }
    }
}

