/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.vars.models;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.Watch;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.v8debug.ui.vars.models.WatchesModel;
import org.netbeans.modules.javascript.v8debug.ui.vars.tooltip.ToolTipAnnotation;
import org.netbeans.modules.javascript.v8debug.vars.V8Evaluator;
import org.netbeans.modules.javascript.v8debug.vars.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.AbstractExpandToolTipAction;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;
import org.openide.util.RequestProcessor;

public class PinWatchValueProvider
implements PinWatchUISupport.ValueProvider,
V8Debugger.Listener {
    private static final RequestProcessor RP = new RequestProcessor(PinWatchValueProvider.class);
    private final V8Debugger dbg;
    private final Map<Watch, ValueListeners> valueListeners = new HashMap<Watch, ValueListeners>();

    public PinWatchValueProvider(ContextProvider lookupProvider) {
        this.dbg = (V8Debugger)lookupProvider.lookupFirst(null, V8Debugger.class);
        this.dbg.addListener((V8Debugger.Listener)this);
    }

    public String getId() {
        return "org.netbeans.modules.javascript2.debug.PIN_VALUE_PROVIDER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return vl.valueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditableValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        if (vl.value != null && !VariablesModel.isReadOnly(vl.value)) {
            return vl.valueOnlyString;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getHeadActions(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        V8Value value = vl.value;
        if (value == null || !VariablesModel.hasChildren(value)) {
            return null;
        }
        Variable var = new Variable(Variable.Kind.LOCAL, watch.getExpression(), value.getHandle(), value, false);
        return new Action[]{new ExpandAction(var)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeListener(Watch watch, PinWatchUISupport.ValueProvider.ValueChangeListener chl) {
        ValueListeners vl = new ValueListeners(chl);
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.put(watch, vl);
        }
        this.updateValue(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetChangeListener(Watch watch) {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.remove(watch);
        }
    }

    public void notifySuspended(boolean suspended) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCurrentFrame(CallFrame cf) {
        if (cf != null) {
            Map<Watch, ValueListeners> map = this.valueListeners;
            synchronized (map) {
                for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                    ValueListeners vl = wvl.getValue();
                    vl.value = null;
                    vl.valueString = this.getEvaluatingText();
                    vl.valueOnlyString = null;
                    Watch w = wvl.getKey();
                    vl.listener.valueChanged(w);
                    this.updateValue(w);
                }
            }
        }
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                ValueListeners vl = wvl.getValue();
                vl.value = null;
                vl.valueString = null;
                vl.valueOnlyString = null;
                vl.listener.valueChanged(wvl.getKey());
            }
        }
    }

    public void notifyFinished() {
    }

    void updateValue(Watch watch) {
        RP.post(() -> {
            V8Value value;
            if (!this.dbg.isSuspended()) {
                return;
            }
            WatchesModel.WatchCB wcb = new WatchesModel.WatchCB();
            V8Request request = this.dbg.sendCommandRequest(V8Command.Evaluate, (V8Arguments)new Evaluate.Arguments(watch.getExpression()), (V8Debugger.CommandResponseCallback)wcb);
            if (request != null && (value = wcb.getValue()) != null) {
                ValueListeners vl;
                Map<Watch, ValueListeners> map = this.valueListeners;
                synchronized (map) {
                    vl = this.valueListeners.get(watch);
                }
                if (vl != null) {
                    String strValue;
                    vl.value = value;
                    vl.valueString = strValue = V8Evaluator.getStringValue((V8Value)value);
                    vl.valueOnlyString = strValue;
                    vl.listener.valueChanged(watch);
                }
            }
        });
    }

    private static final class ValueListeners {
        volatile String valueString = null;
        volatile V8Value value = null;
        volatile String valueOnlyString = null;
        PinWatchUISupport.ValueProvider.ValueChangeListener listener;

        ValueListeners(PinWatchUISupport.ValueProvider.ValueChangeListener listener) {
            this.listener = listener;
        }
    }

    private class ExpandAction
    extends AbstractExpandToolTipAction {
        private final Variable var;

        ExpandAction(Variable var) {
            this.var = var;
        }

        protected void openTooltipView() {
            ToolTipSupport tts = this.openTooltipView(this.var.getName(), this.var);
            if (tts != null) {
                ToolTipAnnotation.handleToolTipClose(PinWatchValueProvider.this.dbg, tts);
            }
        }
    }
}

