/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class ServerProgress
implements ProgressObject {
    private Object server;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus status;
    public static final Command START_SERVER = new Command(25, "START SERVER");
    public static final Command STOP_SERVER = new Command(26, "STOP SERVER");

    public ServerProgress(Object server) {
        this.server = server;
        this.createRunningProgressEvent(CommandType.START, "");
    }

    public void setStatusStartRunning(String message) {
        this.notify(this.createRunningProgressEvent(START_SERVER, message));
    }

    public void setStatusStartFailed(String message) {
        this.notify(this.createFailedProgressEvent(START_SERVER, message));
    }

    public void setStatusStartCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(START_SERVER, message));
    }

    public void setStatusStopRunning(String message) {
        this.notify(this.createRunningProgressEvent(STOP_SERVER, message));
    }

    public void setStatusStopFailed(String message) {
        this.notify(this.createFailedProgressEvent(STOP_SERVER, message));
    }

    public void setStatusStopCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(CommandType.STOP, message));
    }

    protected void notify(ProgressEvent pe) {
        for (ProgressListener listener : this.listeners) {
            listener.handleProgressEvent(pe);
        }
    }

    protected DeploymentStatus createDeploymentStatus(final CommandType comtype, final String msg, final StateType state) {
        return new DeploymentStatus(){

            public ActionType getAction() {
                return ActionType.EXECUTE;
            }

            public CommandType getCommand() {
                return comtype;
            }

            public String getMessage() {
                return msg;
            }

            public StateType getState() {
                return state;
            }

            public boolean isCompleted() {
                return StateType.COMPLETED.equals(state);
            }

            public boolean isFailed() {
                return StateType.FAILED.equals(state);
            }

            public boolean isRunning() {
                return StateType.RUNNING.equals(state);
            }
        };
    }

    protected ProgressEvent createCompletedProgressEvent(CommandType command, String message) {
        this.status = this.createDeploymentStatus(command, message, StateType.COMPLETED);
        return new ProgressEvent(this.server, null, this.status);
    }

    protected ProgressEvent createFailedProgressEvent(CommandType command, String message) {
        this.status = this.createDeploymentStatus(command, message, StateType.FAILED);
        return new ProgressEvent(this.server, null, this.status);
    }

    protected ProgressEvent createRunningProgressEvent(CommandType command, String message) {
        this.status = this.createDeploymentStatus(command, message, StateType.RUNNING);
        return new ProgressEvent(this.server, null, this.status);
    }

    public void addProgressListener(ProgressListener pol) {
        this.listeners.add(pol);
    }

    public void removeProgressListener(ProgressListener pol) {
        this.listeners.remove(pol);
    }

    public boolean isCancelSupported() {
        return true;
    }

    public void cancel() throws OperationUnsupportedException {
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.status;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public static class Command
    extends CommandType {
        String commandString;

        public Command(int val, String commandString) {
            super(val);
            this.commandString = commandString;
        }

        public String toString() {
            return this.commandString;
        }
    }
}

