/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TmpLocalFile;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.sync.Bundle;
import org.netbeans.modules.php.project.connections.sync.ProgressPanel;
import org.netbeans.modules.php.project.connections.sync.SyncItem;
import org.netbeans.modules.php.project.connections.sync.SyncItems;
import org.netbeans.modules.php.project.connections.sync.SyncPanel;
import org.netbeans.modules.php.project.connections.sync.TimeStamps;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class SyncController
implements Cancellable {
    static final Logger LOGGER = Logger.getLogger(SyncController.class.getName());
    static final RequestProcessor SYNC_RP = new RequestProcessor("Remote PHP Synchronization", 1);
    final FileObject[] files;
    final PhpProject phpProject;
    final RemoteClient remoteClient;
    final RemoteConfiguration remoteConfiguration;
    final TimeStamps timeStamps;
    final SourceFiles sourceFiles;
    volatile boolean cancelled = false;

    private SyncController(FileObject[] files, PhpProject phpProject, RemoteClient remoteClient, RemoteConfiguration remoteConfiguration) {
        this.files = files;
        this.phpProject = phpProject;
        this.remoteClient = remoteClient;
        this.remoteConfiguration = remoteConfiguration;
        this.timeStamps = new TimeStamps(phpProject);
        this.sourceFiles = SourceFiles.forFiles(files);
    }

    public static SyncController forProject(PhpProject phpProject, RemoteClient remoteClient, RemoteConfiguration remoteConfiguration) {
        return new SyncController(null, phpProject, remoteClient, remoteConfiguration);
    }

    public static SyncController forFiles(FileObject[] files, PhpProject phpProject, RemoteClient remoteClient, RemoteConfiguration remoteConfiguration) {
        assert (files != null);
        return new SyncController(files, phpProject, remoteClient, remoteConfiguration);
    }

    public void synchronize(final SyncResultProcessor resultProcessor) {
        SYNC_RP.post(new Runnable(){

            @Override
            public void run() {
                SyncController.this.showPanel(SyncController.this.fetchSyncItems(), resultProcessor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SyncItems fetchSyncItems() {
        assert (!SwingUtilities.isEventDispatchThread());
        SyncItems items = null;
        String displayName = this.sourceFiles == SourceFiles.PROJECT ? Bundle.SyncController_fetching_project(this.phpProject.getName()) : Bundle.SyncController_fetching_files(this.files.length);
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)displayName, (Cancellable)this);
        try {
            progressHandle.start();
            FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.phpProject);
            assert (sources != null);
            Set<TransferFile> remoteFiles = this.getRemoteFiles(sources);
            Set<TransferFile> localFiles = this.getLocalFiles(sources);
            items = this.pairItems(remoteFiles, localFiles);
        }
        catch (RemoteException ex) {
            this.disconnect();
            RemoteUtils.processRemoteException(ex);
        }
        finally {
            progressHandle.finish();
        }
        return items;
    }

    private Set<TransferFile> getRemoteFiles(FileObject sources) throws RemoteException {
        HashSet<TransferFile> remoteFiles = new HashSet<TransferFile>();
        if (this.sourceFiles == SourceFiles.PROJECT) {
            this.initRemoteFiles(remoteFiles, this.remoteClient.prepareDownload(sources, sources));
        } else {
            for (FileObject file : this.files) {
                TransferFile transferFile = this.remoteClient.listFile(sources, file);
                if (transferFile != null) {
                    remoteFiles.add(transferFile);
                    continue;
                }
                this.initRemoteFiles(remoteFiles, this.remoteClient.prepareDownload(sources, file));
            }
        }
        return remoteFiles;
    }

    private Set<TransferFile> getLocalFiles(FileObject sources) {
        HashSet<TransferFile> localFiles = new HashSet<TransferFile>();
        if (this.sourceFiles == SourceFiles.PROJECT) {
            this.initLocalFiles(localFiles, this.remoteClient.prepareUpload(sources, sources));
        } else {
            this.initLocalFiles(localFiles, this.remoteClient.prepareUpload(sources, this.files));
        }
        return localFiles;
    }

    void showPanel(final SyncItems items, final SyncResultProcessor resultProcessor) {
        if (this.cancelled || items == null) {
            if (items != null) {
                items.cleanup();
            }
            return;
        }
        try {
            ProjectManager.getDefault().saveProject((Project)this.phpProject);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SyncPanel panel = new SyncPanel(SyncController.this.phpProject, SyncController.this.remoteConfiguration.getDisplayName(), items.getItems(), SyncController.this.remoteClient, SyncController.this.sourceFiles);
                if (panel.open()) {
                    List<SyncItem> itemsToSynchronize = panel.getItems();
                    SyncController.this.doSynchronize(items, itemsToSynchronize, panel.getSyncInfo(itemsToSynchronize), resultProcessor);
                } else {
                    SyncController.this.disconnect();
                    items.cleanup();
                }
            }
        });
    }

    void doSynchronize(SyncItems syncItems, List<SyncItem> itemsToSynchronize, SyncPanel.SyncInfo syncInfo, SyncResultProcessor resultProcessor) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.cancelled) {
            return;
        }
        new Synchronizer(syncItems, itemsToSynchronize, syncInfo, resultProcessor).sync();
    }

    public boolean cancel() {
        this.cancelled = true;
        this.remoteClient.cancel();
        this.disconnect();
        return true;
    }

    void disconnect() {
        try {
            this.remoteClient.disconnect(true);
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    private SyncItems pairItems(Set<TransferFile> remoteFiles, Set<TransferFile> localFiles) {
        ArrayList<TransferFile> remoteFilesSorted = new ArrayList<TransferFile>(remoteFiles);
        remoteFilesSorted.sort(TransferFile.TRANSFER_FILE_COMPARATOR);
        ArrayList<TransferFile> localFilesSorted = new ArrayList<TransferFile>(localFiles);
        localFilesSorted.sort(TransferFile.TRANSFER_FILE_COMPARATOR);
        this.removeProjectRoot(remoteFilesSorted);
        this.removeProjectRoot(localFilesSorted);
        SyncItems items = new SyncItems();
        Iterator remoteFilesIterator = remoteFilesSorted.iterator();
        Iterator localFilesIterator = localFilesSorted.iterator();
        TransferFile remote = null;
        TransferFile local = null;
        while (remoteFilesIterator.hasNext() || localFilesIterator.hasNext()) {
            if (remote == null && remoteFilesIterator.hasNext()) {
                remote = (TransferFile)remoteFilesIterator.next();
            }
            if (local == null && localFilesIterator.hasNext()) {
                local = (TransferFile)localFilesIterator.next();
            }
            if (remote == null || local == null) {
                items.add(remote, local, this.timeStamps.getSyncTimestamp(remote != null ? remote : local));
                remote = null;
                local = null;
                continue;
            }
            int compare = TransferFile.TRANSFER_FILE_COMPARATOR.compare(remote, local);
            if (compare == 0) {
                items.add(remote, local, this.timeStamps.getSyncTimestamp(remote));
                remote = null;
                local = null;
                continue;
            }
            if (compare < 0) {
                items.add(remote, null, this.timeStamps.getSyncTimestamp(remote));
                remote = null;
                continue;
            }
            items.add(null, local, this.timeStamps.getSyncTimestamp(local));
            local = null;
        }
        return items;
    }

    private void removeProjectRoot(List<TransferFile> files) {
        if (files.isEmpty()) {
            return;
        }
        if (files.get(0).isProjectRoot()) {
            files.remove(0);
        }
    }

    private void initRemoteFiles(Set<TransferFile> allRemoteFiles, Collection<TransferFile> remoteFiles) {
        allRemoteFiles.addAll(remoteFiles);
        for (TransferFile file : remoteFiles) {
            this.initRemoteFiles(allRemoteFiles, file.getRemoteChildren());
        }
    }

    private void initLocalFiles(Set<TransferFile> allLocalFiles, Collection<TransferFile> localFiles) {
        allLocalFiles.addAll(localFiles);
        for (TransferFile file : localFiles) {
            this.initLocalFiles(allLocalFiles, file.getLocalChildren());
        }
    }

    static enum SourceFiles {
        PROJECT,
        DIRECTORIES_ONLY,
        INDIVIDUAL_FILES;


        static SourceFiles forFiles(@NullAllowed FileObject[] files) {
            if (files == null) {
                return PROJECT;
            }
            for (FileObject file : files) {
                if (!file.isData()) continue;
                return INDIVIDUAL_FILES;
            }
            return DIRECTORIES_ONLY;
        }
    }

    public static interface SyncResultProcessor {
        public void process(SyncResult var1);
    }

    private final class Synchronizer {
        private final SyncItems syncItems;
        private final List<SyncItem> itemsToSynchronize;
        private final SyncResultProcessor resultProcessor;
        final ProgressPanel progressPanel;
        final AtomicBoolean cancel = new AtomicBoolean();

        public Synchronizer(SyncItems syncItems, List<SyncItem> itemsToSynchronize, SyncPanel.SyncInfo syncInfo, SyncResultProcessor resultProcessor) {
            assert (SwingUtilities.isEventDispatchThread());
            this.syncItems = syncItems;
            this.itemsToSynchronize = itemsToSynchronize;
            this.resultProcessor = resultProcessor;
            this.progressPanel = new ProgressPanel(syncInfo);
        }

        public void sync() {
            assert (SwingUtilities.isEventDispatchThread());
            this.progressPanel.createPanel(this.cancel);
            SYNC_RP.post(new Runnable(){

                @Override
                public void run() {
                    Synchronizer.this.progressPanel.start(Synchronizer.this.itemsToSynchronize);
                    try {
                        Synchronizer.this.doSync();
                    }
                    finally {
                        if (Synchronizer.this.cancel.get()) {
                            Synchronizer.this.progressPanel.cancel();
                        } else {
                            Synchronizer.this.progressPanel.finish();
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doSync() {
            assert (!SwingUtilities.isEventDispatchThread());
            HashSet<TransferFile> remoteFilesForDelete = new HashSet<TransferFile>();
            HashSet<TransferFile> localFilesForDelete = new HashSet<TransferFile>();
            SyncResult syncResult = new SyncResult();
            for (SyncItem syncItem : this.itemsToSynchronize) {
                if (this.cancel.get()) break;
                TransferFile remoteTransferFile = syncItem.getRemoteTransferFile();
                TransferFile localTransferFile = syncItem.getLocalTransferFile();
                switch (syncItem.getOperation()) {
                    case SYMLINK: {
                        break;
                    }
                    case NOOP: {
                        this.progressPanel.decreaseNoopNumber();
                        break;
                    }
                    case DOWNLOAD: 
                    case DOWNLOAD_REVIEW: {
                        try {
                            TransferInfo downloadInfo = SyncController.this.remoteClient.download(Collections.singleton(remoteTransferFile));
                            if (this.mergeTransferInfo(downloadInfo, syncResult.getDownloadTransferInfo())) break;
                            this.progressPanel.downloadErrorOccured();
                            break;
                        }
                        catch (RemoteException ex) {
                            syncResult.getDownloadTransferInfo().addFailed(remoteTransferFile, ex.getLocalizedMessage());
                            this.progressPanel.downloadErrorOccured();
                            break;
                        }
                        finally {
                            this.progressPanel.decreaseDownloadNumber(syncItem);
                        }
                    }
                    case UPLOAD: 
                    case UPLOAD_REVIEW: {
                        try {
                            if (this.copyContent(syncItem.getTmpLocalFile(), localTransferFile.resolveLocalFile())) {
                                TransferInfo uploadInfo = SyncController.this.remoteClient.upload(Collections.singleton(localTransferFile));
                                if (this.mergeTransferInfo(uploadInfo, syncResult.getUploadTransferInfo())) {
                                    this.progressPanel.decreaseUploadNumber(syncItem);
                                    break;
                                }
                                this.progressPanel.uploadErrorOccured();
                                break;
                            }
                            LOGGER.log(Level.WARNING, "Cannot find FileObject for file {0}", localTransferFile.resolveLocalFile());
                            syncResult.getUploadTransferInfo().addFailed(localTransferFile, Bundle.SyncController_error_tmpFileCopyFailed());
                            this.progressPanel.uploadErrorOccured();
                        }
                        catch (RemoteException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            syncResult.getUploadTransferInfo().addFailed(localTransferFile, ex.getLocalizedMessage());
                            this.progressPanel.uploadErrorOccured();
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, null, ex);
                            syncResult.getUploadTransferInfo().addFailed(localTransferFile, Bundle.SyncController_error_tmpFileCopyFailed());
                            this.progressPanel.uploadErrorOccured();
                        }
                        break;
                    }
                    case DELETE: {
                        if (localTransferFile != null) {
                            localFilesForDelete.add(localTransferFile);
                        }
                        if (remoteTransferFile == null) break;
                        remoteFilesForDelete.add(remoteTransferFile);
                        break;
                    }
                    default: {
                        assert (false) : "Unsupported synchronization operation: " + (Object)((Object)syncItem.getOperation());
                        break;
                    }
                }
                this.setTimeStamp(remoteTransferFile != null ? remoteTransferFile : localTransferFile);
            }
            if (!this.cancel.get()) {
                this.deleteFiles(syncResult, remoteFilesForDelete, localFilesForDelete);
            }
            if (SyncController.this.sourceFiles == SourceFiles.PROJECT) {
                File sources = FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(SyncController.this.phpProject));
                assert (sources != null);
                TransferFile transferFile = TransferFile.fromFile(SyncController.this.remoteClient.createRemoteClientImplementation(sources.getAbsolutePath()), null, sources);
                this.setTimeStamp(transferFile);
            }
            this.syncItems.cleanup();
            SyncController.this.disconnect();
            this.resultProcessor.process(syncResult);
        }

        private void setTimeStamp(TransferFile transferFile) {
            assert (transferFile != null);
            SyncController.this.timeStamps.setSyncTimestamp(transferFile);
        }

        private boolean copyContent(TmpLocalFile source, File target) throws IOException {
            if (source == null) {
                return true;
            }
            FileObject fileObject = FileUtil.toFileObject((File)target);
            if (fileObject == null || !fileObject.isValid()) {
                return false;
            }
            try (InputStream inputStream = source.getInputStream();
                 OutputStream outputStream = fileObject.getOutputStream();){
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            return true;
        }

        private boolean mergeTransferInfo(TransferInfo from, TransferInfo to) {
            to.setRuntime(to.getRuntime() + from.getRuntime());
            to.getTransfered().addAll(from.getTransfered());
            to.getIgnored().putAll(from.getIgnored());
            Map<TransferFile, String> partiallyFailed = from.getPartiallyFailed();
            to.getPartiallyFailed().putAll(partiallyFailed);
            Map<TransferFile, String> failed = from.getFailed();
            to.getFailed().putAll(failed);
            return partiallyFailed.isEmpty() && failed.isEmpty();
        }

        private void deleteFiles(SyncResult syncResult, Set<TransferFile> remoteFiles, Set<TransferFile> localFiles) {
            this.deleteRemoteFiles(syncResult, remoteFiles);
            this.deleteLocalFiles(syncResult, localFiles);
            int failed = 0;
            TransferInfo localDeleteTransferInfo = syncResult.getLocalDeleteTransferInfo();
            failed += localDeleteTransferInfo.getFailed().size() + localDeleteTransferInfo.getPartiallyFailed().size();
            TransferInfo remoteDeleteTransferInfo = syncResult.getRemoteDeleteTransferInfo();
            this.progressPanel.setDeleteNumber(failed += remoteDeleteTransferInfo.getFailed().size() + remoteDeleteTransferInfo.getPartiallyFailed().size());
        }

        private void deleteRemoteFiles(SyncResult syncResult, Set<TransferFile> remoteFiles) {
            if (remoteFiles.isEmpty()) {
                return;
            }
            try {
                TransferInfo deleteInfo = SyncController.this.remoteClient.delete(remoteFiles);
                if (!this.mergeTransferInfo(deleteInfo, syncResult.getRemoteDeleteTransferInfo())) {
                    this.progressPanel.deleteErrorOccured();
                }
            }
            catch (RemoteException ex) {
                LOGGER.log(Level.INFO, null, ex);
                Iterator<TransferFile> iterator = remoteFiles.iterator();
                if (iterator.hasNext()) {
                    TransferFile transferFile = iterator.next();
                    syncResult.getRemoteDeleteTransferInfo().addFailed(transferFile, ex.getLocalizedMessage());
                }
                this.progressPanel.deleteErrorOccured();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteLocalFiles(SyncResult syncResult, Set<TransferFile> localFiles) {
            long start = System.currentTimeMillis();
            TransferInfo deleteInfo = syncResult.getLocalDeleteTransferInfo();
            try {
                TreeSet<TransferFile> folders = new TreeSet<TransferFile>(new Comparator<TransferFile>(){

                    @Override
                    public int compare(TransferFile file1, TransferFile file2) {
                        int cmp = StringUtils.explode((String)file2.getLocalPath(), (String)File.separator).size() - StringUtils.explode((String)file1.getLocalPath(), (String)File.separator).size();
                        return cmp != 0 ? cmp : 1;
                    }
                });
                for (TransferFile transferFile : localFiles) {
                    File localFile = transferFile.resolveLocalFile();
                    if (localFile.isDirectory()) {
                        folders.add(transferFile);
                        continue;
                    }
                    if (!localFile.isFile()) continue;
                    if (localFile.delete()) {
                        deleteInfo.addTransfered(transferFile);
                        continue;
                    }
                    deleteInfo.addFailed(transferFile, Bundle.SyncController_error_deleteLocalFile());
                    this.progressPanel.deleteErrorOccured();
                }
                for (TransferFile folder : folders) {
                    File localDir = folder.resolveLocalFile();
                    String[] children = localDir.list();
                    if (children != null && children.length == 0) {
                        if (localDir.delete()) {
                            deleteInfo.addTransfered(folder);
                            continue;
                        }
                        deleteInfo.addFailed(folder, Bundle.SyncController_error_deleteLocalFile());
                        this.progressPanel.deleteErrorOccured();
                        continue;
                    }
                    deleteInfo.addIgnored(folder, Bundle.SyncController_error_localFolderNotEmpty());
                }
            }
            finally {
                deleteInfo.setRuntime(System.currentTimeMillis() - start);
            }
        }
    }

    public static final class SyncResult {
        private final TransferInfo downloadTransferInfo = new TransferInfo();
        private final TransferInfo uploadTransferInfo = new TransferInfo();
        private final TransferInfo localDeleteTransferInfo = new TransferInfo();
        private final TransferInfo remoteDeleteTransferInfo = new TransferInfo();

        SyncResult() {
        }

        public TransferInfo getDownloadTransferInfo() {
            return this.downloadTransferInfo;
        }

        public TransferInfo getUploadTransferInfo() {
            return this.uploadTransferInfo;
        }

        public TransferInfo getLocalDeleteTransferInfo() {
            return this.localDeleteTransferInfo;
        }

        public TransferInfo getRemoteDeleteTransferInfo() {
            return this.remoteDeleteTransferInfo;
        }
    }
}

