/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jquery.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.css.refactoring.api.EntryHandle;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.javascript2.editor.spi.DeclarationFinder;
import org.netbeans.modules.javascript2.jquery.model.JQueryUtils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JQueryDeclarationFinder
implements DeclarationFinder {
    private static final CssSelectorElementHandle CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON = new CssSelectorElementHandle();

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        TokenSequence ts;
        Rule rule;
        if (JQueryUtils.isJQuery(info, caretOffset) && (rule = this.getRule((TokenSequence<? extends JsTokenId>)(ts = LexUtilities.getJsTokenSequence((TokenHierarchy)info.getSnapshot().getTokenHierarchy(), (int)caretOffset)), caretOffset)) != null) {
            RefactoringElementType type = rule.rule.charAt(0) == '#' ? RefactoringElementType.ID : RefactoringElementType.CLASS;
            Map findAll = CssRefactoring.findAllOccurances((String)rule.rule.substring(1), (RefactoringElementType)type, (FileObject)info.getSnapshot().getSource().getFileObject(), (boolean)true);
            if (findAll == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            DeclarationFinder.DeclarationLocation dl = null;
            for (Map.Entry entry : findAll.entrySet()) {
                FileObject f = (FileObject)entry.getKey();
                Collection entries = (Collection)entry.getValue();
                for (EntryHandle entryHandle : entries) {
                    DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(f, entryHandle.entry().getDocumentRange().getStart());
                    if (dl == null) {
                        dl = dloc;
                    }
                    AlternativeLocationImpl aloc = new AlternativeLocationImpl(dloc, entryHandle, type);
                    dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
                }
            }
            if (dl != null && dl.getAlternativeLocations().size() == 1) {
                dl.getAlternativeLocations().clear();
            }
            if (dl != null) {
                return dl;
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final OffsetRange[] value = new OffsetRange[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence ts = LexUtilities.getJsTokenSequence((Document)doc, (int)caretOffset);
                Rule rule = JQueryDeclarationFinder.this.getRule((TokenSequence<? extends JsTokenId>)ts, caretOffset);
                value[0] = rule != null ? new OffsetRange(rule.startOffset, rule.endOffset) : OffsetRange.NONE;
            }
        });
        return value[0];
    }

    private Rule getRule(TokenSequence<? extends JsTokenId> ts, int caretOffset) {
        if (ts == null) {
            return null;
        }
        ts.move(caretOffset);
        if (!ts.movePrevious() || !ts.moveNext()) {
            return null;
        }
        Token token = ts.token();
        if (token.id() == JsTokenId.STRING) {
            int offset;
            String text = token.text().toString();
            if (text.indexOf(32) == -1 && text.indexOf(47) > -1) {
                return null;
            }
            boolean isRule = false;
            int startRule = -1;
            for (offset = caretOffset - ts.offset(); offset > -1 && !isRule; --offset) {
                char ch = text.charAt(offset);
                if (ch == '.' || ch == '#') {
                    isRule = true;
                    startRule = offset;
                    continue;
                }
                if (ch != ' ' && ch != ':' && ch != '[') continue;
                offset = 0;
            }
            if (isRule) {
                int endRule = -1;
                for (offset = startRule + 1; offset < text.length(); ++offset) {
                    char ch = text.charAt(offset);
                    if (ch != ' ' && ch != '[' && ch != '.' && ch != '#' && ch != ':') continue;
                    endRule = offset;
                    offset = text.length();
                }
                if (endRule == -1) {
                    endRule = text.length();
                }
                return new Rule(text.substring(startRule, endRule), ts.offset() + startRule, ts.offset() + endRule);
            }
        }
        return null;
    }

    private static class CssSelectorElementHandle
    implements ElementHandle {
        private CssSelectorElementHandle() {
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return "";
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    private static class Rule {
        String rule;
        int startOffset;
        int endOffset;

        public Rule(String rule, int startOffset, int endOffset) {
            this.rule = rule;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private DeclarationFinder.DeclarationLocation location;
        private EntryHandle entryHandle;
        private RefactoringElementType type;
        private static final int SELECTOR_TEXT_MAX_LENGTH = 50;

        public AlternativeLocationImpl(DeclarationFinder.DeclarationLocation location, EntryHandle entry, RefactoringElementType type) {
            this.location = location;
            this.entryHandle = entry;
            this.type = type;
        }

        public ElementHandle getElement() {
            return CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            String elementTextPrefix;
            StringBuilder b = new StringBuilder();
            String lineText = this.entryHandle.entry().getLineText().toString();
            assert (lineText != null);
            int curlyBracketIndex = lineText.indexOf(123);
            String croppedLineText = curlyBracketIndex == -1 ? lineText : lineText.substring(0, curlyBracketIndex);
            switch (this.type) {
                case CLASS: {
                    elementTextPrefix = ".";
                    break;
                }
                case ID: {
                    elementTextPrefix = "#";
                    break;
                }
                default: {
                    elementTextPrefix = "";
                }
            }
            String elementText = elementTextPrefix + this.entryHandle.entry().getName();
            int elementTextIndex = croppedLineText.indexOf(elementText);
            if (elementTextIndex == -1) {
                String msg = "A parsing error occured when trying to extract display name for html declaration finder.elementText='" + elementText + "'; lineText='" + lineText + "'; croppedLineText='" + croppedLineText + "'; elementTextPrefix='" + elementTextPrefix + "'";
                Logger.getAnonymousLogger().log(Level.INFO, msg, new IllegalStateException());
                return this.entryHandle.entry().getName();
            }
            String prefix = croppedLineText.substring(0, elementTextIndex).trim();
            String postfix = croppedLineText.substring(elementTextIndex + elementText.length()).trim();
            int overlap = croppedLineText.length() - 50;
            if (overlap > 0) {
                int stripFromPrefix = Math.min(overlap / 2, prefix.length());
                prefix = ".." + prefix.substring(stripFromPrefix);
                int stripFromPostfix = Math.min(overlap - stripFromPrefix, postfix.length());
                postfix = postfix.substring(0, postfix.length() - stripFromPostfix) + "..";
            }
            b.append("<font color=007c00>");
            b.append(prefix);
            b.append(' ');
            b.append("<b>");
            b.append(elementText);
            b.append("</b>");
            b.append(' ');
            b.append(postfix);
            b.append("</font> in ");
            FileObject file = this.location.getFileObject();
            Project project = FileOwnerQuery.getOwner((FileObject)file);
            FileObject pathRoot = null;
            if (project != null) {
                pathRoot = project.getProjectDirectory();
            }
            String path = null;
            String resolveTo = null;
            if (pathRoot != null) {
                path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)file);
            }
            if (path == null && project != null && (path = FileUtil.getRelativePath((FileObject)(pathRoot = project.getProjectDirectory()), (FileObject)file)) != null) {
                resolveTo = "${project.home}/";
            }
            if (path == null) {
                path = file.getPath();
            }
            if (resolveTo != null) {
                b.append("<i>");
                b.append(resolveTo);
                b.append("</i>");
            }
            b.append(path);
            int lineOffset = this.entryHandle.entry().getLineOffset();
            if (lineOffset != -1) {
                b.append(":");
                b.append(lineOffset + 1);
            }
            return b.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return AlternativeLocationImpl.getComparableString(this).compareTo(AlternativeLocationImpl.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            StringBuilder sb = new StringBuilder();
            sb.append(loc.getLocation().getOffset());
            FileObject fo = loc.getLocation().getFileObject();
            if (fo != null) {
                sb.append(fo.getPath());
            }
            return sb.toString();
        }
    }
}

