/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.RestFacadeMethod;
import org.netbeans.modules.websvc.rest.codegen.RestGenerationOptions;
import org.netbeans.modules.websvc.rest.codegen.RestMethod;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SpringHelper;
import org.openide.filesystems.FileObject;

public class SpringEntityResourcesGenerator
extends EntityResourcesGenerator {
    private boolean hasAopAlliance;

    SpringEntityResourcesGenerator(boolean hasAopAlliance) {
        this.hasAopAlliance = hasAopAlliance;
    }

    @Override
    protected void configurePersistence() {
        new SpringHelper(this.getProject(), this.getPersistenceUnit()).configure();
    }

    @Override
    protected void createFolders() {
        this.createFolders(false);
    }

    @Override
    protected boolean generateInfrastracture(Set<FileObject> createdFiles, String entityFqn, FileObject facade) throws IOException {
        if (!super.generateInfrastracture(createdFiles, entityFqn, facade)) {
            return false;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)facade);
        if (javaSource == null) {
            return false;
        }
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                Object[] values;
                String[] annotations;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                if (SpringEntityResourcesGenerator.this.hasAopAlliance) {
                    annotations = new String[]{"PersistenceContext"};
                    values = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "unitName", SpringEntityResourcesGenerator.this.getPersistenceUnit().getName())};
                } else {
                    annotations = new String[]{"PersistenceContext", "Error"};
                    values = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "unitName", SpringEntityResourcesGenerator.this.getPersistenceUnit().getName()), "Please fix your project manually, for instructions see http://wiki.netbeans.org/SpringWithAopalliance"};
                }
                ClassTree classTree = (ClassTree)tree.getTypeDecls().get(0);
                ClassTree newTree = JavaSourceHelper.addField(workingCopy, classTree, new Modifier[]{Modifier.PROTECTED}, annotations, values, "entityManager", SpringEntityResourcesGenerator.this.isJakartaNamespace() ? "jakarta.persistence.EntityManager" : "javax.persistence.EntityManager");
                workingCopy.rewrite((Tree)classTree, (Tree)newTree);
            }
        };
        javaSource.runModificationTask((Task)task).commit();
        return true;
    }

    @Override
    protected List<RestGenerationOptions> getRestFacadeMethodOptions(String entityFQN, String idClass) {
        List<RestGenerationOptions> original = super.getRestFacadeMethodOptions(entityFQN, idClass);
        ArrayList<RestGenerationOptions> result = new ArrayList<RestGenerationOptions>(original.size() + 1);
        result.addAll(original);
        RestGenerationOptions option = new RestGenerationOptions();
        FindMethod method = new FindMethod();
        option.setRestMethod(method);
        option.setParameterNames(new String[]{"all", "maxResults", "firstResult"});
        option.setParameterTypes(new String[]{"boolean", "int", "int"});
        StringBuilder returnType = new StringBuilder(List.class.getCanonicalName());
        returnType.append('<');
        returnType.append(JavaIdentifiers.unqualify((String)entityFQN));
        returnType.append('>');
        option.setReturnType(returnType.toString());
        StringBuilder body = new StringBuilder("try { ");
        body.append("Query query = entityManager.createQuery(");
        body.append('\"');
        body.append("SELECT object(o) FROM ");
        body.append(this.getModel().getEntityInfo(entityFQN).getName());
        body.append(" AS o\");");
        body.append("if (!all) {");
        body.append(" query.setMaxResults(maxResults);");
        body.append(" query.setFirstResult(firstResult);}");
        body.append(" return  query.getResultList();");
        body.append("} finally { entityManager.close();}");
        option.setBody(body.toString());
        result.add(option);
        return result;
    }

    @Override
    protected ModifiersTree addRestMethodAnnotations(GenerationUtils genUtils, TreeMaker maker, RestGenerationOptions option, ModifiersTree modifiers) {
        ModifiersTree tree = super.addRestMethodAnnotations(genUtils, maker, option, modifiers);
        if (option.getRestMethod().getMethod(true) != null) {
            tree = maker.addModifiersAnnotation(tree, genUtils.createAnnotation("org.springframework.transaction.annotation.Transactional"));
        }
        return tree;
    }

    @Override
    protected List<String> getResourceImports(String entityFqn) {
        List<String> original = super.getResourceImports(entityFqn);
        ArrayList<String> result = new ArrayList<String>(original.size() + 1);
        result.addAll(original);
        if (this.isJakartaNamespace()) {
            result.add("javax.persistence.Query");
            result.add("jakarta.persistence.PersistenceContext");
        } else {
            result.add("javax.persistence.Query");
            result.add("javax.persistence.PersistenceContext");
        }
        return result;
    }

    @Override
    protected ModifiersTree addResourceAnnotation(String entityFQN, ClassTree classTree, GenerationUtils genUtils, TreeMaker maker) {
        ModifiersTree tree = super.addResourceAnnotation(entityFQN, classTree, genUtils, maker);
        tree = maker.addModifiersAnnotation(tree, genUtils.createAnnotation("com.sun.jersey.spi.resource.Singleton"));
        tree = maker.addModifiersAnnotation(tree, genUtils.createAnnotation("com.sun.jersey.api.spring.Autowire"));
        return tree;
    }

    @Override
    protected RestGenerationOptions getGenerationOptions(RestFacadeMethod method, String entityFQN, String paramArg, String idType) {
        String entitySimpleName = JavaIdentifiers.unqualify((String)entityFQN);
        RestGenerationOptions options = super.getGenerationOptions(method, entityFQN, paramArg, idType);
        boolean needPathSegment = false;
        EntityClassInfo entityInfo = this.getModel().getEntityInfo(entityFQN);
        if (entityInfo != null) {
            EntityClassInfo.FieldInfo idFieldInfo = entityInfo.getIdFieldInfo();
            needPathSegment = idFieldInfo != null && idFieldInfo.isEmbeddedId() && idFieldInfo.getType() != null;
        }
        switch (method) {
            case CREATE: {
                StringBuilder builder = new StringBuilder("entityManager.persist(entity);");
                builder.append("return Response.created(");
                builder.append("URI.create(");
                builder.append(this.getIdFieldToUriStmt(this.getModel().getEntityInfo(entityFQN).getIdFieldInfo()));
                builder.append(".toString())).build();");
                options.setBody(builder.toString());
                return options;
            }
            case EDIT: {
                options.setReturnType("void");
                StringBuilder builder = new StringBuilder("entityManager.merge(entity);");
                options.setBody(builder.toString());
                return options;
            }
            case REMOVE: {
                options.setReturnType("void");
                StringBuilder builder = new StringBuilder();
                if (needPathSegment) {
                    builder.append(idType);
                    builder.append(" key=getPrimaryKey(id);\n");
                    paramArg = "key";
                }
                builder.append(entitySimpleName);
                builder.append(" entity = entityManager.getReference(");
                builder.append(entitySimpleName);
                builder.append(".class, ");
                builder.append(paramArg);
                builder.append(");");
                builder.append("entityManager.remove(entity);");
                options.setBody(builder.toString());
                return options;
            }
            case FIND: {
                StringBuilder builder = new StringBuilder();
                if (needPathSegment) {
                    builder.append(idType);
                    builder.append(" key=getPrimaryKey(id);\n");
                    paramArg = "key";
                }
                builder.append("return entityManager.find(");
                builder.append(entitySimpleName);
                builder.append(".class, ");
                builder.append(paramArg);
                builder.append(");");
                options.setBody(builder.toString());
                return options;
            }
            case FIND_ALL: {
                options.setBody("return find(true , -1 , -1);");
                return options;
            }
            case FIND_RANGE: {
                options.setBody("return find( false , max, first)");
                return options;
            }
            case COUNT: {
                StringBuilder builder = new StringBuilder("try {");
                builder.append("Query query = entityManager.createQuery(");
                builder.append('\"');
                builder.append("SELECT count(o) FROM ");
                builder.append(this.getModel().getEntityInfo(entityFQN).getName());
                builder.append(" AS o\");");
                builder.append("return query.getSingleResult().toString();");
                builder.append("} finally { entityManager.close(); }");
                options.setBody(builder.toString());
                return options;
            }
        }
        return null;
    }

    private static final class FindMethod
    implements RestMethod {
        private FindMethod() {
        }

        @Override
        public boolean overrides() {
            return false;
        }

        @Override
        public String getUriPath() {
            return null;
        }

        @Override
        public String getMethodName() {
            return "find";
        }

        @Override
        public String getMethod(Boolean jakartaVariant) {
            return null;
        }
    }
}

