/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.rest.client.RESTResourcesView;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RESTExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedResourceNode = null;
    private ProjectNodeFactory factory;
    private static final ProjectNodeFactory REST_FACTORY = new RestProjectNodeFactory();
    private JLabel jLblTreeView;

    public RESTExplorerPanel() {
        this(REST_FACTORY);
    }

    public RESTExplorerPanel(ProjectNodeFactory factory) {
        this.initComponents();
        this.initUserComponents();
        this.factory = factory;
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(RESTExplorerPanel.class, (String)"LBL_SelectRESTResource"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        this.treeView.setDefaultActionAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RESTExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RESTExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        Children.Array rootChildren = new Children.Array();
        AbstractNode explorerResourcesRoot = new AbstractNode((Children)rootChildren);
        ArrayList<Node> projectNodeList = new ArrayList<Node>();
        for (Project prj : projects) {
            Node node = this.factory.createNode(prj);
            if (node == null) continue;
            projectNodeList.add(node);
        }
        Node[] projectNodes = new Node[projectNodeList.size()];
        projectNodeList.toArray(projectNodes);
        rootChildren.add(projectNodes);
        this.manager.setRootContext((Node)explorerResourcesRoot);
        this.descriptor.setValid(false);
        this.treeView.requestFocusInWindow();
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Node getSelectedService() {
        return this.selectedResourceNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            if (this.factory.canSelect(node)) {
                this.selectedResourceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedResourceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    public static interface ProjectNodeFactory {
        public Node createNode(Project var1);

        public boolean canSelect(Node var1);
    }

    private static class RestProjectNodeFactory
    implements ProjectNodeFactory {
        private RestProjectNodeFactory() {
        }

        @Override
        public Node createNode(Project project) {
            LogicalViewProvider logicalProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalProvider != null) {
                Node rootNode = logicalProvider.createLogicalView();
                Node restResourcesNode = RESTResourcesView.createRESTResourcesView(project);
                if (restResourcesNode != null) {
                    return new ProjectNode((Children)new FilterNode.Children(restResourcesNode), rootNode);
                }
            }
            return null;
        }

        @Override
        public boolean canSelect(Node node) {
            return node.getLookup().lookup(RestServiceDescription.class) != null;
        }
    }

    private static class ProjectNode
    extends AbstractNode {
        private final Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

