/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.BackupVaultDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BackupVaultRequest
extends BmcRequest<BackupVaultDetails> {
    private String vaultId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private BackupVaultDetails backupVaultDetails;

    public String getVaultId() {
        return this.vaultId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public BackupVaultDetails getBackupVaultDetails() {
        return this.backupVaultDetails;
    }

    @InternalSdk
    public BackupVaultDetails getBody$() {
        return this.backupVaultDetails;
    }

    public Builder toBuilder() {
        return new Builder().vaultId(this.vaultId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).backupVaultDetails(this.backupVaultDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vaultId=").append(String.valueOf(this.vaultId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",backupVaultDetails=").append(String.valueOf((Object)this.backupVaultDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupVaultRequest)) {
            return false;
        }
        BackupVaultRequest other = (BackupVaultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.backupVaultDetails, (Object)other.backupVaultDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.backupVaultDetails == null ? 43 : this.backupVaultDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BackupVaultRequest, BackupVaultDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vaultId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private BackupVaultDetails backupVaultDetails = null;

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder backupVaultDetails(BackupVaultDetails backupVaultDetails) {
            this.backupVaultDetails = backupVaultDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BackupVaultRequest o) {
            this.vaultId(o.getVaultId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.backupVaultDetails(o.getBackupVaultDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BackupVaultRequest build() {
            BackupVaultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BackupVaultDetails body) {
            this.backupVaultDetails(body);
            return this;
        }

        public BackupVaultRequest buildWithoutInvocationCallback() {
            BackupVaultRequest request = new BackupVaultRequest();
            request.vaultId = this.vaultId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.backupVaultDetails = this.backupVaultDetails;
            return request;
        }
    }
}

