/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.NetworkingTopology;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetNetworkingTopologyResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private NetworkingTopology networkingTopology;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NetworkingTopology getNetworkingTopology() {
        return this.networkingTopology;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "networkingTopology"})
    private GetNetworkingTopologyResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, NetworkingTopology networkingTopology) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.networkingTopology = networkingTopology;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",networkingTopology=").append(String.valueOf((Object)this.networkingTopology));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNetworkingTopologyResponse)) {
            return false;
        }
        GetNetworkingTopologyResponse other = (GetNetworkingTopologyResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.networkingTopology, (Object)other.networkingTopology);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.networkingTopology == null ? 43 : this.networkingTopology.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetNetworkingTopologyResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private NetworkingTopology networkingTopology;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder networkingTopology(NetworkingTopology networkingTopology) {
            this.networkingTopology = networkingTopology;
            return this;
        }

        public Builder copy(GetNetworkingTopologyResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.networkingTopology(o.getNetworkingTopology());
            return this;
        }

        public GetNetworkingTopologyResponse build() {
            return new GetNetworkingTopologyResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.networkingTopology);
        }
    }
}

