/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetIpv6Response
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private Ipv6 ipv6;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Ipv6 getIpv6() {
        return this.ipv6;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "ipv6"})
    private GetIpv6Response(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, Ipv6 ipv6) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.ipv6 = ipv6;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ipv6=").append(String.valueOf((Object)this.ipv6));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIpv6Response)) {
            return false;
        }
        GetIpv6Response other = (GetIpv6Response)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.ipv6, (Object)other.ipv6);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ipv6 == null ? 43 : this.ipv6.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetIpv6Response> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private Ipv6 ipv6;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ipv6(Ipv6 ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public Builder copy(GetIpv6Response o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.ipv6(o.getIpv6());
            return this;
        }

        public GetIpv6Response build() {
            return new GetIpv6Response(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.ipv6);
        }
    }
}

