/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListVnicAttachmentsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String availabilityDomain;
    private String instanceId;
    private Integer limit;
    private String page;
    private String vnicId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).availabilityDomain(this.availabilityDomain).instanceId(this.instanceId).limit(this.limit).page(this.page).vnicId(this.vnicId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",vnicId=").append(String.valueOf(this.vnicId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVnicAttachmentsRequest)) {
            return false;
        }
        ListVnicAttachmentsRequest other = (ListVnicAttachmentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.vnicId, other.vnicId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVnicAttachmentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String availabilityDomain = null;
        private String instanceId = null;
        private Integer limit = null;
        private String page = null;
        private String vnicId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVnicAttachmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.instanceId(o.getInstanceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.vnicId(o.getVnicId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVnicAttachmentsRequest build() {
            ListVnicAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListVnicAttachmentsRequest buildWithoutInvocationCallback() {
            ListVnicAttachmentsRequest request = new ListVnicAttachmentsRequest();
            request.compartmentId = this.compartmentId;
            request.availabilityDomain = this.availabilityDomain;
            request.instanceId = this.instanceId;
            request.limit = this.limit;
            request.page = this.page;
            request.vnicId = this.vnicId;
            return request;
        }
    }
}

