/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.VirtualCircuitPublicPrefix;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListVirtualCircuitPublicPrefixesRequest
extends BmcRequest<Void> {
    private String virtualCircuitId;
    private VirtualCircuitPublicPrefix.VerificationState verificationState;

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public VirtualCircuitPublicPrefix.VerificationState getVerificationState() {
        return this.verificationState;
    }

    public Builder toBuilder() {
        return new Builder().virtualCircuitId(this.virtualCircuitId).verificationState(this.verificationState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",virtualCircuitId=").append(String.valueOf(this.virtualCircuitId));
        sb.append(",verificationState=").append(String.valueOf((Object)this.verificationState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVirtualCircuitPublicPrefixesRequest)) {
            return false;
        }
        ListVirtualCircuitPublicPrefixesRequest other = (ListVirtualCircuitPublicPrefixesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.virtualCircuitId, other.virtualCircuitId) && Objects.equals((Object)this.verificationState, (Object)other.verificationState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualCircuitId == null ? 43 : this.virtualCircuitId.hashCode());
        result = result * 59 + (this.verificationState == null ? 43 : this.verificationState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVirtualCircuitPublicPrefixesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String virtualCircuitId = null;
        private VirtualCircuitPublicPrefix.VerificationState verificationState = null;

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder verificationState(VirtualCircuitPublicPrefix.VerificationState verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVirtualCircuitPublicPrefixesRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.verificationState(o.getVerificationState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVirtualCircuitPublicPrefixesRequest build() {
            ListVirtualCircuitPublicPrefixesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListVirtualCircuitPublicPrefixesRequest buildWithoutInvocationCallback() {
            ListVirtualCircuitPublicPrefixesRequest request = new ListVirtualCircuitPublicPrefixesRequest();
            request.virtualCircuitId = this.virtualCircuitId;
            request.verificationState = this.verificationState;
            return request;
        }
    }
}

