/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIpsecCpeDeviceConfigContentRequest
extends BmcRequest<Void> {
    private String ipscId;
    private String opcRequestId;

    public String getIpscId() {
        return this.ipscId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().ipscId(this.ipscId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ipscId=").append(String.valueOf(this.ipscId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIpsecCpeDeviceConfigContentRequest)) {
            return false;
        }
        GetIpsecCpeDeviceConfigContentRequest other = (GetIpsecCpeDeviceConfigContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ipscId, other.ipscId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipscId == null ? 43 : this.ipscId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIpsecCpeDeviceConfigContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ipscId = null;
        private String opcRequestId = null;

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIpsecCpeDeviceConfigContentRequest o) {
            this.ipscId(o.getIpscId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIpsecCpeDeviceConfigContentRequest build() {
            GetIpsecCpeDeviceConfigContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIpsecCpeDeviceConfigContentRequest buildWithoutInvocationCallback() {
            GetIpsecCpeDeviceConfigContentRequest request = new GetIpsecCpeDeviceConfigContentRequest();
            request.ipscId = this.ipscId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

