/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCpeDeviceConfigContentRequest
extends BmcRequest<Void> {
    private String cpeId;
    private String opcRequestId;

    public String getCpeId() {
        return this.cpeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cpeId(this.cpeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cpeId=").append(String.valueOf(this.cpeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCpeDeviceConfigContentRequest)) {
            return false;
        }
        GetCpeDeviceConfigContentRequest other = (GetCpeDeviceConfigContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cpeId, other.cpeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpeId == null ? 43 : this.cpeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCpeDeviceConfigContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cpeId = null;
        private String opcRequestId = null;

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCpeDeviceConfigContentRequest o) {
            this.cpeId(o.getCpeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCpeDeviceConfigContentRequest build() {
            GetCpeDeviceConfigContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCpeDeviceConfigContentRequest buildWithoutInvocationCallback() {
            GetCpeDeviceConfigContentRequest request = new GetCpeDeviceConfigContentRequest();
            request.cpeId = this.cpeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

