/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteAppCatalogSubscriptionRequest
extends BmcRequest<Void> {
    private String listingId;
    private String compartmentId;
    private String resourceVersion;

    public String getListingId() {
        return this.listingId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Builder toBuilder() {
        return new Builder().listingId(this.listingId).compartmentId(this.compartmentId).resourceVersion(this.resourceVersion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",listingId=").append(String.valueOf(this.listingId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",resourceVersion=").append(String.valueOf(this.resourceVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteAppCatalogSubscriptionRequest)) {
            return false;
        }
        DeleteAppCatalogSubscriptionRequest other = (DeleteAppCatalogSubscriptionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceVersion, other.resourceVersion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceVersion == null ? 43 : this.resourceVersion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAppCatalogSubscriptionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String listingId = null;
        private String compartmentId = null;
        private String resourceVersion = null;

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAppCatalogSubscriptionRequest o) {
            this.listingId(o.getListingId());
            this.compartmentId(o.getCompartmentId());
            this.resourceVersion(o.getResourceVersion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAppCatalogSubscriptionRequest build() {
            DeleteAppCatalogSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteAppCatalogSubscriptionRequest buildWithoutInvocationCallback() {
            DeleteAppCatalogSubscriptionRequest request = new DeleteAppCatalogSubscriptionRequest();
            request.listingId = this.listingId;
            request.compartmentId = this.compartmentId;
            request.resourceVersion = this.resourceVersion;
            return request;
        }
    }
}

