/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MemberReplica
extends ExplicitlySetBmcModel {
    @JsonProperty(value="volumeReplicaId")
    private final String volumeReplicaId;
    @JsonProperty(value="membershipState")
    private final MembershipState membershipState;

    @Deprecated
    @ConstructorProperties(value={"volumeReplicaId", "membershipState"})
    public MemberReplica(String volumeReplicaId, MembershipState membershipState) {
        this.volumeReplicaId = volumeReplicaId;
        this.membershipState = membershipState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVolumeReplicaId() {
        return this.volumeReplicaId;
    }

    public MembershipState getMembershipState() {
        return this.membershipState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MemberReplica(");
        sb.append("super=").append(super.toString());
        sb.append("volumeReplicaId=").append(String.valueOf(this.volumeReplicaId));
        sb.append(", membershipState=").append(String.valueOf((Object)this.membershipState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberReplica)) {
            return false;
        }
        MemberReplica other = (MemberReplica)((Object)o);
        return Objects.equals(this.volumeReplicaId, other.volumeReplicaId) && Objects.equals((Object)this.membershipState, (Object)other.membershipState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.volumeReplicaId == null ? 43 : this.volumeReplicaId.hashCode());
        result = result * 59 + (this.membershipState == null ? 43 : this.membershipState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MembershipState implements BmcEnum
    {
        AddPending("ADD_PENDING"),
        Stable("STABLE"),
        RemovePending("REMOVE_PENDING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MembershipState> map;

        private MembershipState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MembershipState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MembershipState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MembershipState.class);
            map = new HashMap<String, MembershipState>();
            for (MembershipState v : MembershipState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="volumeReplicaId")
        private String volumeReplicaId;
        @JsonProperty(value="membershipState")
        private MembershipState membershipState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder volumeReplicaId(String volumeReplicaId) {
            this.volumeReplicaId = volumeReplicaId;
            this.__explicitlySet__.add("volumeReplicaId");
            return this;
        }

        public Builder membershipState(MembershipState membershipState) {
            this.membershipState = membershipState;
            this.__explicitlySet__.add("membershipState");
            return this;
        }

        public MemberReplica build() {
            MemberReplica model = new MemberReplica(this.volumeReplicaId, this.membershipState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MemberReplica model) {
            if (model.wasPropertyExplicitlySet("volumeReplicaId")) {
                this.volumeReplicaId(model.getVolumeReplicaId());
            }
            if (model.wasPropertyExplicitlySet("membershipState")) {
                this.membershipState(model.getMembershipState());
            }
            return this;
        }
    }
}

