/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ClusterConfigurationDetails;
import com.oracle.bmc.core.model.ClusterNetworkPlacementConfigurationDetails;
import com.oracle.bmc.core.model.CreateClusterNetworkInstancePoolDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateClusterNetworkDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="instancePools")
    private final List<CreateClusterNetworkInstancePoolDetails> instancePools;
    @JsonProperty(value="placementConfiguration")
    private final ClusterNetworkPlacementConfigurationDetails placementConfiguration;
    @JsonProperty(value="clusterConfiguration")
    private final ClusterConfigurationDetails clusterConfiguration;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "freeformTags", "instancePools", "placementConfiguration", "clusterConfiguration"})
    public CreateClusterNetworkDetails(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, List<CreateClusterNetworkInstancePoolDetails> instancePools, ClusterNetworkPlacementConfigurationDetails placementConfiguration, ClusterConfigurationDetails clusterConfiguration) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.instancePools = instancePools;
        this.placementConfiguration = placementConfiguration;
        this.clusterConfiguration = clusterConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public List<CreateClusterNetworkInstancePoolDetails> getInstancePools() {
        return this.instancePools;
    }

    public ClusterNetworkPlacementConfigurationDetails getPlacementConfiguration() {
        return this.placementConfiguration;
    }

    public ClusterConfigurationDetails getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateClusterNetworkDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", instancePools=").append(String.valueOf(this.instancePools));
        sb.append(", placementConfiguration=").append(String.valueOf((Object)this.placementConfiguration));
        sb.append(", clusterConfiguration=").append(String.valueOf((Object)this.clusterConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateClusterNetworkDetails)) {
            return false;
        }
        CreateClusterNetworkDetails other = (CreateClusterNetworkDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.instancePools, other.instancePools) && Objects.equals((Object)this.placementConfiguration, (Object)other.placementConfiguration) && Objects.equals((Object)this.clusterConfiguration, (Object)other.clusterConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.instancePools == null ? 43 : this.instancePools.hashCode());
        result = result * 59 + (this.placementConfiguration == null ? 43 : this.placementConfiguration.hashCode());
        result = result * 59 + (this.clusterConfiguration == null ? 43 : this.clusterConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="instancePools")
        private List<CreateClusterNetworkInstancePoolDetails> instancePools;
        @JsonProperty(value="placementConfiguration")
        private ClusterNetworkPlacementConfigurationDetails placementConfiguration;
        @JsonProperty(value="clusterConfiguration")
        private ClusterConfigurationDetails clusterConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder instancePools(List<CreateClusterNetworkInstancePoolDetails> instancePools) {
            this.instancePools = instancePools;
            this.__explicitlySet__.add("instancePools");
            return this;
        }

        public Builder placementConfiguration(ClusterNetworkPlacementConfigurationDetails placementConfiguration) {
            this.placementConfiguration = placementConfiguration;
            this.__explicitlySet__.add("placementConfiguration");
            return this;
        }

        public Builder clusterConfiguration(ClusterConfigurationDetails clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            this.__explicitlySet__.add("clusterConfiguration");
            return this;
        }

        public CreateClusterNetworkDetails build() {
            CreateClusterNetworkDetails model = new CreateClusterNetworkDetails(this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.instancePools, this.placementConfiguration, this.clusterConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateClusterNetworkDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("instancePools")) {
                this.instancePools(model.getInstancePools());
            }
            if (model.wasPropertyExplicitlySet("placementConfiguration")) {
                this.placementConfiguration(model.getPlacementConfiguration());
            }
            if (model.wasPropertyExplicitlySet("clusterConfiguration")) {
                this.clusterConfiguration(model.getClusterConfiguration());
            }
            return this;
        }
    }
}

