/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.jstestdriver.preferences;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class JsTestDriverPreferences {
    public static final String CONFIG = "config";
    private static final String ENABLED = "enabled";
    private static final Map<Project, Preferences> CACHE = new WeakHashMap<Project, Preferences>();

    private JsTestDriverPreferences() {
    }

    public static boolean isEnabled(Project project) {
        return JsTestDriverPreferences.getPreferences(project).getBoolean(ENABLED, false);
    }

    public static void setEnabled(Project project, boolean enabled) {
        JsTestDriverPreferences.getPreferences(project).putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public static String getConfig(Project project) {
        return JsTestDriverPreferences.resolvePath(project, JsTestDriverPreferences.getPreferences(project).get(CONFIG, null));
    }

    public static void setConfig(Project project, String config) {
        JsTestDriverPreferences.getPreferences(project).put(CONFIG, JsTestDriverPreferences.relativizePath(project, config));
    }

    public static void addPreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        JsTestDriverPreferences.getPreferences(project).addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        JsTestDriverPreferences.getPreferences(project).removePreferenceChangeListener(listener);
    }

    private static String relativizePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (File)file);
        if (path == null || path.startsWith("../")) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Preferences getPreferences(Project project) {
        assert (project != null);
        Map<Project, Preferences> map = CACHE;
        synchronized (map) {
            Preferences preferences = CACHE.get(project);
            if (preferences == null) {
                preferences = ProjectUtils.getPreferences((Project)project, JsTestDriverPreferences.class, (boolean)false);
                CACHE.put(project, preferences);
            }
            assert (preferences != null) : project.getProjectDirectory();
            return preferences;
        }
    }
}

