/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.preferences;

import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;

public final class NodeJsPreferences {
    public static final String ENABLED = "enabled";
    public static final String NODE_PATH = "node.path";
    public static final String NODE_SOURCES_PATH = "node.sources.path";
    public static final String NODE_DEFAULT = "node.default";
    public static final String START_FILE = "start.file";
    public static final String START_ARGS = "start.args";
    public static final String RUN_ENABLED = "run.enabled";
    public static final String RUN_RESTART = "run.restart";
    public static final String DEBUG_PORT = "debug.port";
    public static final String SYNC_ENABLED = "sync.enabled";
    public static final String ASK_RUN_CONFIGURATION = "ask.run.enabled";
    public static final String ASK_SYNC_ENABLED = "ask.sync.enabled";
    public static final String DEBUG_PROTOCOL = "debug.protocol";
    private final Project project;
    private Preferences privatePreferences;
    private Preferences sharedPreferences;

    public NodeJsPreferences(Project project) {
        assert (project != null);
        this.project = project;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        this.getPrivatePreferences().addPreferenceChangeListener(listener);
        this.getSharedPreferences().addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        this.getPrivatePreferences().removePreferenceChangeListener(listener);
        this.getSharedPreferences().removePreferenceChangeListener(listener);
    }

    public boolean isEnabled() {
        return this.getSharedPreferences().getBoolean(ENABLED, false);
    }

    public void setEnabled(boolean enabled) {
        this.getSharedPreferences().putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public String getNode() {
        return FileUtils.resolvePath(this.project, this.getPrivatePreferences().get(NODE_PATH, null));
    }

    public void setNode(String node) {
        this.getPrivatePreferences().put(NODE_PATH, FileUtils.relativizePath(this.project, node));
    }

    @CheckForNull
    public String getNodeSources() {
        return FileUtils.resolvePath(this.project, this.getPrivatePreferences().get(NODE_SOURCES_PATH, null));
    }

    public void setNodeSources(@NullAllowed String nodeSources) {
        if (nodeSources == null) {
            this.getPrivatePreferences().remove(NODE_SOURCES_PATH);
        } else {
            this.getPrivatePreferences().put(NODE_SOURCES_PATH, FileUtils.relativizePath(this.project, nodeSources));
        }
    }

    public boolean isDefaultNode() {
        return this.getSharedPreferences().getBoolean(NODE_DEFAULT, true);
    }

    public void setDefaultNode(boolean defaultNode) {
        this.getSharedPreferences().putBoolean(NODE_DEFAULT, defaultNode);
    }

    @CheckForNull
    public String getStartFile() {
        return FileUtils.resolvePath(this.project, this.getSharedPreferences().get(START_FILE, null));
    }

    public void setStartFile(@NullAllowed String startFile) {
        if (startFile == null) {
            this.getSharedPreferences().remove(START_FILE);
        } else {
            this.getSharedPreferences().put(START_FILE, FileUtils.relativizePath(this.project, startFile));
        }
    }

    @CheckForNull
    public String getStartArgs() {
        return this.getSharedPreferences().get(START_ARGS, null);
    }

    public void setStartArgs(@NullAllowed String startArgs) {
        if (startArgs == null) {
            this.getSharedPreferences().remove(START_ARGS);
        } else {
            this.getSharedPreferences().put(START_ARGS, startArgs);
        }
    }

    public boolean isRunEnabled() {
        return this.getSharedPreferences().getBoolean(RUN_ENABLED, false);
    }

    public void setRunEnabled(boolean enabled) {
        this.getSharedPreferences().putBoolean(RUN_ENABLED, enabled);
    }

    public boolean isRunRestart() {
        return this.getSharedPreferences().getBoolean(RUN_RESTART, false);
    }

    public void setRunRestart(boolean restart) {
        this.getSharedPreferences().putBoolean(RUN_RESTART, restart);
    }

    public int getDebugPort() {
        return this.getPrivatePreferences().getInt(DEBUG_PORT, 9292);
    }

    public void setDebugPort(int debugPort) {
        this.getPrivatePreferences().putInt(DEBUG_PORT, debugPort);
    }

    public boolean isSyncEnabled() {
        return this.getSharedPreferences().getBoolean(SYNC_ENABLED, true);
    }

    public void setSyncEnabled(boolean enabled) {
        this.getSharedPreferences().putBoolean(SYNC_ENABLED, enabled);
    }

    public boolean isAskRunEnabled() {
        boolean ask = this.getPrivatePreferences().getBoolean(ASK_RUN_CONFIGURATION, true);
        if (ask) {
            this.getPrivatePreferences().putBoolean(ASK_RUN_CONFIGURATION, false);
        }
        return ask;
    }

    public boolean isAskSyncEnabled() {
        boolean ask = this.getPrivatePreferences().getBoolean(ASK_SYNC_ENABLED, true);
        if (ask) {
            this.getPrivatePreferences().putBoolean(ASK_SYNC_ENABLED, false);
        }
        return ask;
    }

    @CheckForNull
    public String getDebugProtocol() {
        return this.getPrivatePreferences().get(DEBUG_PROTOCOL, null);
    }

    public void setDebugProtocol(@NullAllowed String debugProtocol) {
        if (debugProtocol == null) {
            this.getPrivatePreferences().remove(DEBUG_PROTOCOL);
        } else {
            this.getPrivatePreferences().put(DEBUG_PROTOCOL, debugProtocol);
        }
    }

    private synchronized Preferences getPrivatePreferences() {
        if (this.privatePreferences == null) {
            this.privatePreferences = ProjectUtils.getPreferences((Project)this.project, NodeJsPreferences.class, (boolean)false);
        }
        return this.privatePreferences;
    }

    private synchronized Preferences getSharedPreferences() {
        if (this.sharedPreferences == null) {
            this.sharedPreferences = ProjectUtils.getPreferences((Project)this.project, NodeJsPreferences.class, (boolean)true);
        }
        return this.sharedPreferences;
    }
}

