/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.api.keyring.Keyring;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class NBBugzillaUtils {
    private static final String NB_BUGZILLA_PASSWORD = "nbbugzilla.password";
    private static final String NB_BUGZILLA_USERNAME = "nbbugzilla.username";
    private static final Pattern netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");

    public static boolean isNbRepository(String url) {
        boolean ret = netbeansUrlPattern.matcher(url).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.startsWith(nbUrl);
    }

    public static String getNBUsername() {
        String user = NBBugzillaUtils.getPreferences().get(NB_BUGZILLA_USERNAME, "");
        return user.equals("") ? null : user;
    }

    public static char[] getNBPassword() {
        return Keyring.read((String)NB_BUGZILLA_PASSWORD);
    }

    public static void saveNBUsername(String username) {
        if (username == null) {
            return;
        }
        NBBugzillaUtils.getPreferences().put(NB_BUGZILLA_USERNAME, username);
    }

    public static void saveNBPassword(char[] password) {
        if (password == null) {
            Keyring.delete((String)NB_BUGZILLA_PASSWORD);
        } else {
            Keyring.save((String)NB_BUGZILLA_PASSWORD, (char[])password, (String)NbBundle.getMessage(NBBugzillaUtils.class, (String)"NBRepositorySupport.password_keyring_description"));
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/bugtracking");
    }
}

