/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.DbURLClassLoader;

public class DbDriverManager {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.db.explorer.DbDriverManager");
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final DbDriverManager DEFAULT = new DbDriverManager();
    private Set<Driver> registeredDrivers;
    private Map<Connection, Driver> conn2Driver = new WeakHashMap<Connection, Driver>();
    private Map<JDBCDriver, ClassLoader> driver2Loader = new WeakHashMap<JDBCDriver, ClassLoader>();

    private DbDriverManager() {
    }

    public static DbDriverManager getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String databaseURL, Properties props, JDBCDriver jdbcDriver) throws SQLException {
        Driver driver;
        if (LOG) {
            LOGGER.log(Level.FINE, "Attempting to connect to '" + databaseURL + "'");
        }
        if ((driver = this.getDriverInternal(databaseURL, jdbcDriver, false)) != null) {
            Connection conn;
            String driverClassName = driver.getClass().getName();
            if ("com.mysql.jdbc.Driver".equals(driverClassName) || "com.mysql.cj.jdbc.Driver".equals(driverClassName)) {
                props.put("useUnicode", "true");
                props.put("characterEncoding", "utf8");
            }
            if ((conn = driver.connect(databaseURL, props)) == null) {
                if (LOG) {
                    LOGGER.log(Level.FINE, driver.getClass().getName() + ".connect() returned null");
                }
                throw this.createDriverNotFoundException();
            }
            Map<Connection, Driver> map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(conn, driver);
            }
            return conn;
        }
        try {
            Connection conn = DriverManager.getConnection(databaseURL, props);
            Map<Connection, Driver> map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(conn, null);
            }
            return conn;
        }
        catch (SQLException sQLException) {
            throw this.createDriverNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getSameDriverConnection(Connection existingConn, String databaseURL, Properties props) throws SQLException {
        if (existingConn == null) {
            throw new NullPointerException();
        }
        Driver driver = null;
        Map<Connection, Driver> map = this.conn2Driver;
        synchronized (map) {
            if (!this.conn2Driver.containsKey(existingConn)) {
                throw new IllegalArgumentException("A connection not obtained through DbDriverManager was passed.");
            }
            driver = this.conn2Driver.get(existingConn);
        }
        if (driver != null) {
            Connection newConn = driver.connect(databaseURL, props);
            if (newConn == null) {
                throw new SQLException("Unable to connect using existingConn's original driver", "08001");
            }
            Map<Connection, Driver> map2 = this.conn2Driver;
            synchronized (map2) {
                this.conn2Driver.put(newConn, driver);
            }
            return newConn;
        }
        return DriverManager.getConnection(databaseURL, props);
    }

    public synchronized void registerDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            this.registeredDrivers = new HashSet<Driver>();
        }
        this.registeredDrivers.add(driver);
    }

    public synchronized void deregisterDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            return;
        }
        this.registeredDrivers.remove(driver);
    }

    public Driver getDriver(String databaseURL, JDBCDriver jdbcDriver) throws SQLException {
        Driver d = this.getDriverInternal(databaseURL, jdbcDriver, true);
        if (d == null) {
            throw this.createDriverNotFoundException();
        }
        return d;
    }

    public Driver getDriver(JDBCDriver jdbcDriver) throws SQLException {
        Object driver;
        ClassLoader l = this.getClassLoader(jdbcDriver);
        try {
            driver = Class.forName(jdbcDriver.getClassName(), true, l).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SQLException sqlex = this.createDriverNotFoundException();
            sqlex.initCause(e);
            throw sqlex;
        }
        if (driver instanceof Driver) {
            return (Driver)driver;
        }
        throw new SQLException(driver.getClass().getName() + " is not a driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getDriverInternal(String databaseURL, JDBCDriver jdbcDriver, boolean lookInDriverManager) throws SQLException {
        Driver d;
        DbDriverManager dbDriverManager = this;
        synchronized (dbDriverManager) {
            if (this.registeredDrivers != null) {
                for (Driver d2 : this.registeredDrivers) {
                    try {
                        if (!d2.acceptsURL(databaseURL)) continue;
                        return d2;
                    }
                    catch (SQLException sQLException) {
                    }
                }
            }
        }
        if (jdbcDriver != null && (d = this.getDriver(jdbcDriver)) != null) {
            return d;
        }
        if (lookInDriverManager) {
            try {
                return DriverManager.getDriver(databaseURL);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(JDBCDriver driver) {
        ClassLoader loader = null;
        Map<JDBCDriver, ClassLoader> map = this.driver2Loader;
        synchronized (map) {
            loader = this.driver2Loader.get(driver);
            if (loader == null) {
                loader = new DbURLClassLoader(driver.getURLs());
                if (LOG) {
                    LOGGER.log(Level.FINE, "Creating " + loader);
                }
                this.driver2Loader.put(driver, loader);
            } else if (LOG) {
                LOGGER.log(Level.FINE, "Reusing " + loader);
            }
        }
        return loader;
    }

    private SQLException createDriverNotFoundException() {
        return new SQLException("Unable to find a suitable driver", "08001");
    }
}

