/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebFreeFormActionProvider;
import org.netbeans.modules.web.freeform.WebModules;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportHandle;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LookupProviderImpl
implements LookupProvider {
    private static final String HELP_ID_FRAGMENT = "web";

    public Lookup createAdditionalLookup(Lookup baseContext) {
        Project prj = (Project)baseContext.lookup(Project.class);
        ProjectAccessor acc = (ProjectAccessor)baseContext.lookup(ProjectAccessor.class);
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)baseContext.lookup(AuxiliaryConfiguration.class);
        assert (aux != null);
        assert (prj != null);
        assert (acc != null);
        return new ProjectLookup(prj, acc.getHelper(), acc.getEvaluator(), aux);
    }

    private static Lookup initLookup(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        WebClasspath webcp = new WebClasspath(projectHelper, projectEvaluator, aux, project);
        return Lookups.fixed((Object[])new Object[]{new ProjectOpenedHookImpl(webcp), new PrivilegedTemplatesImpl(), new WebModules(project, projectHelper, projectEvaluator, aux), new WebFreeFormActionProvider(project, projectHelper, aux), new HelpIDFragmentProviderImpl(), new JsfSupportHandle()});
    }

    public static boolean isMyProject(AuxiliaryConfiguration aux) {
        return aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true) != null || aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true) != null;
    }

    static Element upgradeSchema(Element old) {
        Document doc = old.getOwnerDocument();
        Element nue = doc.createElementNS("http://www.netbeans.org/ns/freeform-project-web/2", "web-data");
        LookupProviderImpl.copyXMLTree(doc, old, nue, "http://www.netbeans.org/ns/freeform-project-web/2");
        return nue;
    }

    private static void copyXMLTree(Document doc, Element from, Element to, String newNamespace) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node newNode;
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS(newNamespace, oldElement.getTagName());
                    NamedNodeMap attrs = oldElement.getAttributes();
                    int alength = attrs.getLength();
                    for (int j = 0; j < alength; ++j) {
                        Attr oldAttr = (Attr)attrs.item(j);
                        ((Element)newNode).setAttributeNS(oldAttr.getNamespaceURI(), oldAttr.getName(), oldAttr.getValue());
                    }
                    LookupProviderImpl.copyXMLTree(doc, oldElement, (Element)newNode, newNamespace);
                    break;
                }
                case 3: {
                    newNode = doc.createTextNode(((Text)node).getData());
                    break;
                }
                case 8: {
                    newNode = doc.createComment(((Comment)node).getData());
                    break;
                }
                default: {
                    throw new AssertionError(node);
                }
            }
            to.appendChild(newNode);
        }
    }

    private static final class ProjectLookup
    extends ProxyLookup
    implements AntProjectListener {
        private AntProjectHelper helper;
        private PropertyEvaluator evaluator;
        private Project project;
        private AuxiliaryConfiguration aux;
        private boolean isMyProject;

        public ProjectLookup(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
            super(new Lookup[0]);
            this.project = project;
            this.helper = helper;
            this.evaluator = evaluator;
            this.aux = new UpgradingAuxiliaryConfiguration(aux);
            this.isMyProject = LookupProviderImpl.isMyProject(aux);
            this.updateLookup();
            helper.addAntProjectListener((AntProjectListener)this);
        }

        private void updateLookup() {
            Lookup l = Lookup.EMPTY;
            if (this.isMyProject) {
                l = LookupProviderImpl.initLookup(this.project, this.helper, this.evaluator, this.aux);
            }
            this.setLookups(new Lookup[]{l});
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (LookupProviderImpl.isMyProject(this.aux) != this.isMyProject) {
                this.isMyProject = !this.isMyProject;
                this.updateLookup();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    public static final class WebClasspath
    implements AntProjectListener,
    PropertyChangeListener {
        private ClassPath[] registeredCP = new ClassPath[0];
        private List<FileObject> registeredRoots = Collections.emptyList();
        private PropertyEvaluator evaluator;
        private AuxiliaryConfiguration aux;
        private Project project;
        private PropertyChangeSupport pcs;
        private boolean prjClosed = false;

        public WebClasspath(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux, Project proj) {
            this.evaluator = evaluator;
            this.aux = aux;
            this.project = proj;
            helper.addAntProjectListener((AntProjectListener)this);
            evaluator.addPropertyChangeListener((PropertyChangeListener)this);
            this.pcs = new PropertyChangeSupport(this);
        }

        public void prjOpened() {
            this.registeredRoots = this.getWebRoots(this.aux, this.project, this.evaluator);
            FileObject[] fos = this.registeredRoots.toArray(new FileObject[0]);
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])fos);
            this.registeredCP = new ClassPath[]{cp};
            GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
            this.prjClosed = false;
        }

        public void prjClosed() {
            if (!this.registeredRoots.isEmpty()) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
            }
            this.registeredRoots = Collections.emptyList();
            this.prjClosed = true;
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.updateClasspath();
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.updateClasspath();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        private synchronized void updateClasspath() {
            List<FileObject> newRoots;
            if (!this.prjClosed && (newRoots = this.getWebRoots(this.aux, this.project, this.evaluator)) != null && !newRoots.equals(this.registeredRoots)) {
                FileObject[] fos = newRoots.toArray(new FileObject[0]);
                ClassPath cp = ClassPathSupport.createClassPath((FileObject[])fos);
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
                this.registeredCP = new ClassPath[]{cp};
                this.registeredRoots = newRoots;
                GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        private List<FileObject> getWebRoots(AuxiliaryConfiguration aux, Project proj, PropertyEvaluator evaluator) {
            Element web = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
            if (web == null) {
                return null;
            }
            List webModules = XMLUtil.findSubElements((Element)web);
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (Element webModulesEl : webModules) {
                assert (webModulesEl.getLocalName().equals("web-module")) : webModulesEl;
                roots.add(FileUtil.toFileObject((File)this.getFile(webModulesEl, "doc-root", proj, evaluator)));
            }
            return roots;
        }

        private File getFile(Element parent, String fileElName, Project proj, PropertyEvaluator evaluator) {
            Element el = XMLUtil.findElement((Element)parent, (String)fileElName, (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            return Util.resolveFile((PropertyEvaluator)evaluator, (File)FileUtil.toFile((FileObject)proj.getProjectDirectory()), (String)XMLUtil.findText((Node)el));
        }
    }

    private static class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private final WebClasspath webcp;

        public ProjectOpenedHookImpl(WebClasspath wcp) {
            this.webcp = wcp;
        }

        protected void projectOpened() {
            this.webcp.prjOpened();
        }

        protected void projectClosed() {
            this.webcp.prjClosed();
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java"};
        private static final String[] RECOMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "ant-script", "ant-task", "servlet-types", "web-types", "j2ee-types", "junit", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMENDED_TYPES;
        }
    }

    private static final class HelpIDFragmentProviderImpl
    implements HelpIDFragmentProvider {
        private HelpIDFragmentProviderImpl() {
        }

        public String getHelpIDFragment() {
            return LookupProviderImpl.HELP_ID_FRAGMENT;
        }
    }

    static final class UpgradingAuxiliaryConfiguration
    implements AuxiliaryConfiguration {
        private final AuxiliaryConfiguration delegate;

        public UpgradingAuxiliaryConfiguration(AuxiliaryConfiguration delegate) {
            this.delegate = delegate;
        }

        public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
            if (elementName.equals("web-data") && namespace.equals("http://www.netbeans.org/ns/freeform-project-web/2") && shared) {
                Element old;
                Element nue = this.delegate.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
                if (nue == null && (old = this.delegate.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true)) != null) {
                    nue = LookupProviderImpl.upgradeSchema(old);
                }
                return nue;
            }
            return this.delegate.getConfigurationFragment(elementName, namespace, shared);
        }

        public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
            this.delegate.putConfigurationFragment(fragment, shared);
        }

        public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
            return this.delegate.removeConfigurationFragment(elementName, namespace, shared);
        }
    }
}

