/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.project.LaunchedProjectOpener;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OpenRunningShellAction
implements ProjectActionPerformer {
    public boolean enable(Project project) {
        Collection<ShellAgent> agents = ShellLaunchManager.getInstance().getLiveAgents(project);
        return !agents.isEmpty();
    }

    public void perform(Project project) {
        Collection<ShellAgent> agents = ShellLaunchManager.getInstance().getLiveAgents(project);
        HashSet<ShellAgent> waiting = new HashSet<ShellAgent>(agents);
        Collection<JShellEnvironment> envs = ShellRegistry.get().openedShells(project);
        for (JShellEnvironment e : envs) {
            ShellAgent a = LaunchedProjectOpener.get().getProjectAgent(e);
            if (a == null) continue;
            waiting.remove(a);
        }
        if (!waiting.isEmpty()) {
            ShellAgent selected = (ShellAgent)waiting.iterator().next();
            LaunchedProjectOpener.get().openAgentShell(selected);
        } else if (!envs.isEmpty()) {
            try {
                envs.iterator().next().open();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static Action action() {
        Action a = MainProjectSensitiveActions.mainProjectSensitiveAction((ProjectActionPerformer)new OpenRunningShellAction(), (String)NbBundle.getMessage(OpenRunningShellAction.class, (String)"LBL_OpenShellForMainProject"), null);
        a.putValue("iconBase", "org/netbeans/modules/jshell/resources/jshell-terminal.png");
        return a;
    }
}

