/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjshell;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.execution.StreamingExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import org.netbeans.lib.nbjshell.NbExecutionControl;

public class NbExecutionControlBase
extends StreamingExecutionControl
implements NbExecutionControl {
    private static final Logger LOG = Logger.getLogger(NbExecutionControlBase.class.getName());
    private ObjectInput remoteIn;
    private ObjectOutput remoteOut;

    public NbExecutionControlBase(ObjectOutput out, ObjectInput in) {
        super(out, in);
        this.remoteOut = out;
        this.remoteIn = in;
    }

    public ObjectOutput getRemoteOut() {
        return this.remoteOut;
    }

    protected ObjectInput getRemoteIn() {
        return this.remoteIn;
    }

    @Override
    public Map<String, String> commandVersionInfo() {
        Map<String, String> result = new HashMap<String, String>();
        try {
            Object o = this.extensionCommand("nb_vmInfo", null);
            if (!(o instanceof Map)) {
                return Collections.emptyMap();
            }
            result = (Map)o;
        }
        catch (ExecutionControl.InternalException | ExecutionControl.RunException ex) {
            LOG.log(Level.INFO, "Error invoking JShell agent", ex.toString());
        }
        catch (ExecutionControl.EngineTerminationException ex) {
            this.shutdown();
        }
        return result;
    }

    protected void shutdown() {
        if (this.remoteIn == null) {
            return;
        }
        try {
            this.remoteIn.close();
            this.remoteOut.close();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error closing streams", ex);
        }
    }
}

