/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.BasicAggregateProgressFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.ModuleInfoSupport;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.dependencies.DependencyExcludeNodeVisitor;
import org.netbeans.modules.maven.dependencies.ExcludeDependencyPanel;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.netbeans.modules.maven.nodes.InstallDocSourcePanel;
import org.netbeans.modules.maven.nodes.InstallPanel;
import org.netbeans.modules.maven.nodes.PathFinders;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.maven.queries.RepositoryForBinaryQueryImpl;
import org.netbeans.modules.maven.spi.nodes.DependencyTypeIconBadge;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Cancellable;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class DependencyNode
extends AbstractNode
implements PreferenceChangeListener {
    private boolean longLiving;
    private PropertyChangeListener listener;
    private ChangeListener listener2;
    final Data data = (Data)this.getLookup().lookup(Data.class);
    private volatile String iconBase = "org/netbeans/modules/maven/DependencyIcon.png";
    private static final String toolTipJavadoc = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_JavadocBadge");
    private static final String toolTipSource = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_SourceBadge");
    private static final String toolTipMissing = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_MissingBadge");
    private static final String toolTipManaged = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencyManaged.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_ManagedBadge");
    private static final String toolTipForeignBundler = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_PreferSourcesBadge");
    private static final RequestProcessor RP = new RequestProcessor(DependencyNode.class);
    private static final RemoveDependencyAction REMOVEDEPINSTANCE = new RemoveDependencyAction(Lookup.EMPTY);
    private static final String SHOW_MANAGED_DEPENDENCIES = "show.managed.dependencies";
    private static Action DOWNLOAD_JAVADOC_ACTION = new DownloadJavadocSrcAction(true);
    private static Action DOWNLOAD_SOURCE_ACTION = new DownloadJavadocSrcAction(false);
    private static final SetInCurrentAction SETINCURRENTINSTANCE = new SetInCurrentAction(Lookup.EMPTY);
    private static final AddToModuleInfoAction ADDTOMODULEINFO = new AddToModuleInfoAction(Lookup.EMPTY);

    private static Children createChildren(@NullAllowed Node nodeDelegate) {
        return nodeDelegate == null ? Children.LEAF : new JarContentFilterChildren(nodeDelegate);
    }

    @NonNull
    private static Lookup createLookup(@NonNull Project project, @NonNull Artifact art, @NullAllowed Node nodeDelegate, Supplier<Boolean> canAddToModuleInfo) {
        FileObject fo;
        PathFinder pathFinderDelegate = nodeDelegate == null ? null : (PathFinder)nodeDelegate.getLookup().lookup(PathFinder.class);
        FileObject fileObject = fo = nodeDelegate == null ? null : (FileObject)nodeDelegate.getLookup().lookup(FileObject.class);
        if (fo != null) {
            return Lookups.fixed((Object[])new Object[]{new Data(art, project, fo, canAddToModuleInfo), project, art, PathFinders.createDelegatingPathFinder(pathFinderDelegate), fo});
        }
        return Lookups.fixed((Object[])new Object[]{new Data(art, project, null, canAddToModuleInfo), project, art, PathFinders.createDelegatingPathFinder(pathFinderDelegate)});
    }

    @CheckForNull
    static Node createNodeDelegate(@NonNull Artifact art, FileObject fo, boolean longLiving) {
        if (!longLiving) {
            return null;
        }
        if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
            return PackageView.createPackageView((SourceGroup)new ArtifactSourceGroup(art));
        }
        return null;
    }

    public DependencyNode(NbMavenProjectImpl project, final Artifact art, FileObject fo, boolean isLongLiving, Node nodeDelegate, Supplier<Boolean> canAddToModuleInfo) {
        super(DependencyNode.createChildren(nodeDelegate), DependencyNode.createLookup(project, art, nodeDelegate, canAddToModuleInfo));
        this.data.fileObject.set(fo);
        this.longLiving = isLongLiving;
        if (this.longLiving) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            NbMavenProject.addPropertyChangeListener(project, WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)project.getProjectWatcher()));
            this.listener2 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    if (event instanceof MavenFileOwnerQueryImpl.GAVCHangeEvent) {
                        MavenFileOwnerQueryImpl.GAVCHangeEvent ev = (MavenFileOwnerQueryImpl.GAVCHangeEvent)event;
                        if (ev.matches(art)) {
                            DependencyNode.this.refreshNode();
                        }
                    } else {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
            DependenciesNode.prefs().addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)DependenciesNode.prefs()));
        }
        this.setDisplayName(this.createName(false));
        this.setIconBase(false);
        if (this.longLiving) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DependencyNode.this.refreshNode();
                }
            });
        }
        this.data.setNode(this);
    }

    private void setIconBase(boolean longLiving) {
        String base = longLiving && this.data.isDependencyProjectAvailable() ? (this.data.isTransitive() ? "org/netbeans/modules/maven/TransitiveMaven2Icon.png" : "org/netbeans/modules/maven/resources/Maven2Icon.gif") : (this.data.isTransitive() ? (this.data.isAddedToCP() ? "org/netbeans/modules/maven/TransitiveDependencyIcon.png" : "org/netbeans/modules/maven/TransitiveArtifactIcon.png") : (this.data.isAddedToCP() ? "org/netbeans/modules/maven/DependencyIcon.png" : "org/netbeans/modules/maven/ArtifactIcon.png"));
        this.iconBase = base;
        this.setIconBaseWithExtension(base);
    }

    public String getShortDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><i>").append(Bundle.DESC_Dep1()).append("</i><b> ").append(this.data.art.getGroupId()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep2()).append("</i><b> ").append(this.data.art.getArtifactId()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep3()).append("</i><b> ").append(this.data.art.getVersion()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep4()).append("</i><b> ").append(this.data.art.getType()).append("</b><br>");
        if (this.data.art.getClassifier() != null) {
            buf.append("<i>").append(Bundle.DESC_Dep5()).append("</i><b> ").append(this.data.art.getClassifier()).append("</b><br>");
        }
        buf.append("<i>").append(Bundle.DESC_scope()).append("</i><b> ").append(this.data.art.getScope()).append("</b><br>");
        List trail = this.data.art.getDependencyTrail();
        for (int i = trail.size() - 2; i > 0 && i < trail.size(); --i) {
            String[] id = ((String)trail.get(i)).split(":");
            buf.append("<i>").append(Bundle.DESC_via()).append("</i> ").append(id[1]).append("<br>");
        }
        return buf.toString();
    }

    private void refreshNode() {
        Node nodeDelegate;
        Children childs;
        assert (!SwingUtilities.isEventDispatchThread());
        FileObject fo = FileUtil.toFileObject((File)this.data.art.getFile());
        this.data.sourceExists.set(this.data.getSourceFile().exists());
        this.data.javadocExists.set(this.data.getJavadocFile().exists());
        this.data.fileObject.set(fo);
        this.setDisplayName(this.createName(this.longLiving));
        this.setIconBase(this.longLiving);
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
        if (this.longLiving && Children.LEAF == this.getChildren() && (childs = DependencyNode.createChildren(nodeDelegate = DependencyNode.createNodeDelegate(this.data.art, fo, true))) != Children.LEAF) {
            this.setChildren(childs);
            PathFinders.updateDelegate((PathFinder)this.getLookup().lookup(PathFinder.class), (PathFinder)nodeDelegate.getLookup().lookup(PathFinder.class));
        }
    }

    public String getHtmlDisplayName() {
        StringBuilder n = new StringBuilder("<html>");
        n.append(this.getDisplayName());
        if (ArtifactUtils.isSnapshot((String)this.data.art.getVersion()) && this.data.art.getVersion().indexOf("SNAPSHOT") < 0) {
            n.append(" <b>[").append(this.data.art.getVersion()).append("]</b>");
        }
        if (!this.data.art.getArtifactHandler().isAddedToClasspath() && !"compile".equals(this.data.art.getScope())) {
            n.append("  <i>[").append(this.data.art.getScope()).append("]</i>");
        }
        n.append("</html>");
        return n.toString();
    }

    private String createName(boolean longLiving) {
        Project prj;
        if (longLiving && (prj = this.data.getDependencyProject()) != null) {
            return ProjectUtils.getInformation((Project)prj).getDisplayName();
        }
        if (NbArtifactFixer.isFallbackFile(this.data.art.getFile())) {
            return this.data.art.getArtifactId() + "-" + this.data.art.getBaseVersion() + (String)(this.data.art.getClassifier() != null ? "-" + this.data.art.getClassifier() : "") + "." + this.data.art.getArtifactHandler().getExtension();
        }
        return this.data.art.getFile().getName();
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> acts = new ArrayList<Action>();
        if (this.longLiving && this.data.isDependencyProjectAvailable()) {
            acts.add(OpenProjectAction.SINGLETON);
        }
        boolean local = this.data.isLocal();
        if (this.data.isAddedToCP()) {
            InstallLocalArtifactAction act = new InstallLocalArtifactAction();
            acts.add(act);
            if (!local) {
                act.setEnabled(true);
            }
        }
        if (local) {
            acts.add(new CopyLocationAction());
        }
        if (!this.data.hasJavadocInRepository()) {
            acts.add(DOWNLOAD_JAVADOC_ACTION);
            if (this.data.isAddedToCP()) {
                acts.add(new InstallLocalJavadocAction());
            }
        }
        if (!this.data.hasSourceInRepository()) {
            acts.add(DOWNLOAD_SOURCE_ACTION);
            if (this.data.isAddedToCP()) {
                acts.add(new InstallLocalSourcesAction());
            }
        }
        if (this.data.isTransitive()) {
            acts.add(new ExcludeTransitiveAction());
            acts.add(SETINCURRENTINSTANCE);
        } else {
            acts.add(REMOVEDEPINSTANCE);
        }
        if (this.data.canAddToModuleInfo()) {
            acts.add(ADDTOMODULEINFO);
        }
        acts.add(null);
        acts.add(CommonArtifactActions.createViewArtifactDetails(this.data.art, this.data.getMavenProject().getRemoteArtifactRepositories()));
        acts.add(CommonArtifactActions.createFindUsages(this.data.art));
        acts.add(null);
        acts.add(CommonArtifactActions.createViewJavadocAction(this.data.art));
        acts.add(null);
        acts.add((Action)PropertiesAction.get(PropertiesAction.class));
        return acts.toArray(new Action[0]);
    }

    public boolean canDestroy() {
        return !this.data.isTransitive();
    }

    public void destroy() throws IOException {
        REMOVEDEPINSTANCE.createContextAwareInstance(this.getLookup()).actionPerformed(null);
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    void downloadJavadocSources(ProgressContributor progress, boolean isjavadoc) {
        DependencyNode.downloadJavadocSources(progress, isjavadoc, this.data.art, this.data.project);
        this.refreshNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Artifact downloadJavadocSources(ProgressContributor progress, boolean isjavadoc, Artifact artifact, Project prj) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        progress.start(2);
        if ("system".equals(artifact.getScope())) {
            progress.finish();
            return null;
        }
        NbMavenProjectImpl prjimpl = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        Artifact sources = null;
        try {
            List<RepositoryForBinaryQueryImpl.Coordinates> coordinates;
            String bundleName;
            String baseClassifier;
            Object classifier;
            if (isjavadoc) {
                classifier = artifact.getClassifier() != null ? ("tests".equals(artifact.getClassifier()) ? "test-javadoc" : artifact.getClassifier() + "-javadoc") : "javadoc";
                baseClassifier = "javadoc";
                bundleName = "MSG_Checking_Javadoc";
            } else {
                baseClassifier = "sources";
                classifier = artifact.getClassifier() != null ? ("tests".equals(artifact.getClassifier()) ? "test-sources" : artifact.getClassifier() + "-sources") : "sources";
                bundleName = "MSG_Checking_Sources";
            }
            sources = prjimpl.getEmbedder().createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), (String)classifier);
            progress.progress(NbBundle.getMessage(DependencyNode.class, (String)bundleName, (Object)artifact.getId()), 1);
            online.resolveArtifact(sources, prjimpl.getOriginalMavenProject().getRemoteArtifactRepositories(), prjimpl.getEmbedder().getLocalRepository());
            if (artifact.getFile() != null && artifact.getFile().exists() && (coordinates = RepositoryForBinaryQueryImpl.getJarMetadataCoordinates(artifact.getFile())) != null) {
                for (RepositoryForBinaryQueryImpl.Coordinates coordinate : coordinates) {
                    sources = prjimpl.getEmbedder().createArtifactWithClassifier(coordinate.groupId, coordinate.artifactId, coordinate.version, "jar", baseClassifier);
                    progress.progress(NbBundle.getMessage(DependencyNode.class, (String)bundleName, (Object)artifact.getId()), 1);
                    online.resolveArtifact(sources, prjimpl.getOriginalMavenProject().getRemoteArtifactRepositories(), prjimpl.getEmbedder().getLocalRepository());
                }
            }
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
        }
        catch (ArtifactResolutionException artifactResolutionException) {
        }
        finally {
            progress.finish();
        }
        return sources;
    }

    public Image getIcon(int param) {
        return this.badge(super.getIcon(param));
    }

    private boolean isIconProjectBased() {
        String base = this.iconBase;
        return "org/netbeans/modules/maven/TransitiveMaven2Icon.png".equals(base) || "org/netbeans/modules/maven/resources/Maven2Icon.gif".equals(base);
    }

    private Image badge(Image retValue) {
        ForeignClassBundler fcb;
        if (this.data.isLocal()) {
            FileObject fo;
            Image ann;
            if (!this.isIconProjectBased()) {
                if (this.data.hasJavadocInRepository()) {
                    ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyJavadocIncluded.png");
                    ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipJavadoc);
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)0);
                }
                if (this.data.hasSourceInRepository()) {
                    ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencySrcIncluded.png");
                    ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipSource);
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)8);
                }
            } else {
                Object fcb2;
                Project p = this.data.getDependencyProject();
                if (p != null && (fcb2 = (ForeignClassBundler)p.getLookup().lookup(ForeignClassBundler.class)) != null && !fcb2.preferSources()) {
                    Image ann2 = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/brokenProjectBadge.png");
                    ann2 = ImageUtilities.addToolTipToImage((Image)ann2, (String)toolTipForeignBundler);
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann2, (int)0, (int)0);
                }
            }
            if (DependencyNode.showManagedState() && this.data.isManaged()) {
                ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyManaged.png");
                ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipManaged);
                retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)0, (int)8);
            }
            if ((fo = this.data.fileObject.get()) != null && fo.isValid()) {
                for (DependencyTypeIconBadge badge : Lookup.getDefault().lookupAll(DependencyTypeIconBadge.class)) {
                    Image ann3 = badge.getBadgeIcon(fo, this.data.art);
                    if (ann3 == null) continue;
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann3, (int)0, (int)0);
                    break;
                }
            }
            return retValue;
        }
        if (!this.isIconProjectBased()) {
            Image ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/brokenProjectBadge.png");
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipMissing);
            return ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)0, (int)0);
        }
        Project p = this.data.getDependencyProject();
        if (p != null && (fcb = (ForeignClassBundler)p.getLookup().lookup(ForeignClassBundler.class)) != null && !fcb.preferSources()) {
            Image ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/brokenProjectBadge.png");
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipForeignBundler);
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)0, (int)0);
        }
        return retValue;
    }

    public Image getOpenedIcon(int type) {
        return this.badge(super.getOpenedIcon(type));
    }

    public Component getCustomizer() {
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set basicProps = sheet.get("properties");
        try {
            PropertySupport.Reflection artifactId = new PropertySupport.Reflection((Object)this.data.art, String.class, "getArtifactId", null);
            artifactId.setName("artifactId");
            artifactId.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Artifact"));
            artifactId.setShortDescription("");
            PropertySupport.Reflection groupId = new PropertySupport.Reflection((Object)this.data.art, String.class, "getGroupId", null);
            groupId.setName("groupId");
            groupId.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Group"));
            groupId.setShortDescription("");
            PropertySupport.Reflection version = new PropertySupport.Reflection((Object)this.data.art, String.class, "getVersion", null);
            version.setName("version");
            version.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Version"));
            version.setShortDescription(NbBundle.getMessage(DependencyNode.class, (String)"HINT_Version"));
            PropertySupport.Reflection type = new PropertySupport.Reflection((Object)this.data.art, String.class, "getType", null);
            type.setName("type");
            type.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Type"));
            PropertySupport.Reflection scope = new PropertySupport.Reflection((Object)this.data.art, String.class, "getScope", null);
            scope.setName("scope");
            scope.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Scope"));
            PropertySupport.Reflection classifier = new PropertySupport.Reflection((Object)this.data.art, String.class, "getClassifier", null);
            classifier.setName("classifier");
            classifier.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Classifier"));
            PropertySupport.Reflection hasJavadoc = new PropertySupport.Reflection((Object)this.data, Boolean.TYPE, "hasJavadocInRepository", null);
            hasJavadoc.setName("javadoc");
            hasJavadoc.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Javadoc_Locally"));
            PropertySupport.Reflection hasSources = new PropertySupport.Reflection((Object)this.data, Boolean.TYPE, "hasSourceInRepository", null);
            hasSources.setName("sources");
            hasSources.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Sources_Locally"));
            PropertySupport.Reflection transitive = new PropertySupport.Reflection((Object)this.data, Boolean.TYPE, "isTransitive", null);
            transitive.setName("transitive");
            transitive.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Transitive"));
            PropertySupport.Reflection path = new PropertySupport.Reflection((Object)this.data.art, File.class, "getFile", null);
            path.setName("path");
            path.setDisplayName("Path");
            path.setShortDescription("Absolute path to the artifact in the local filesystem.");
            PropertySupport.Reflection repositorypath = new PropertySupport.Reflection((Object)this.data, String.class, "getArtifactRepositoryPath", null);
            repositorypath.setName("repositorypath");
            repositorypath.setDisplayName("Repository Path");
            repositorypath.setShortDescription("Relative path within the local maven repository.");
            basicProps.put(new Node.Property[]{artifactId, groupId, version, type, scope, classifier, transitive, hasJavadoc, hasSources, path, repositorypath});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        return sheet;
    }

    private static boolean showManagedState() {
        return DependenciesNode.prefs().getBoolean(SHOW_MANAGED_DEPENDENCIES, false);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(SHOW_MANAGED_DEPENDENCIES)) {
            this.refreshNode();
        }
    }

    private Relocation getRelocation(Dependency d) {
        ProjectBuildingRequest dpbr = EmbedderFactory.getProjectEmbedder().createMavenExecutionRequest().getProjectBuildingRequest();
        dpbr.setValidationLevel(0);
        dpbr.setProcessPlugins(false);
        dpbr.setResolveDependencies(false);
        ArrayList remoteRepos = new ArrayList();
        dpbr.setRemoteRepositories(remoteRepos);
        String groupId = d.getGroupId();
        String artifactId = d.getArtifactId();
        String version = d.getVersion();
        if (!(groupId == null || "".equals(groupId.trim()) || artifactId == null || "".equals(artifactId.trim()) || version == null || "".equals(version.trim()))) {
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            Artifact a = embedder.createProjectArtifact(groupId, artifactId, version);
            try {
                ProjectBuildingResult r = embedder.buildProject(a, dpbr);
                DistributionManagement dm = r.getProject().getDistributionManagement();
                return dm != null ? dm.getRelocation() : null;
            }
            catch (ProjectBuildingException ex) {
                Logger.getLogger(DependencyNode.class.getName()).log(Level.INFO, version, ex);
            }
        }
        return null;
    }

    private static class JarContentFilterChildren
    extends FilterNode.Children {
        JarContentFilterChildren(Node orig) {
            super(orig);
        }

        protected Node copyNode(Node node) {
            return new JarFilterNode(node);
        }
    }

    public static class Data {
        private final Artifact art;
        private final Project project;
        private final Supplier<Boolean> canAddToModuleInfo;
        private AtomicReference<FileObject> fileObject;
        private final AtomicBoolean sourceExists = new AtomicBoolean(false);
        private final AtomicBoolean javadocExists = new AtomicBoolean(false);
        private DependencyNode node;

        public Data(Artifact art, Project project, FileObject fileObject, Supplier<Boolean> canAddToModuleInfo) {
            this.art = art;
            this.project = project;
            this.fileObject = new AtomicReference<FileObject>(fileObject);
            this.canAddToModuleInfo = canAddToModuleInfo;
        }

        public String getArtifactRepositoryPath() {
            return EmbedderFactory.getProjectEmbedder().getLocalRepository().pathOf(this.art);
        }

        public boolean isLocal() {
            FileObject fo = this.fileObject.get();
            return fo != null && fo.isValid() && !NbArtifactFixer.isFallbackFile(this.art.getFile());
        }

        public boolean hasJavadocInRepository() {
            return this.javadocExists.get() && !"system".equals(this.art.getScope());
        }

        public File getJavadocFile() {
            File artifact = this.art.getFile();
            String version = artifact.getParentFile().getName();
            String artifactId = artifact.getParentFile().getParentFile().getName();
            return new File(artifact.getParentFile(), artifactId + "-" + version + (String)(this.art.getClassifier() != null ? ("tests".equals(this.art.getClassifier()) ? "-test" : "-" + this.art.getClassifier()) : "") + "-javadoc.jar");
        }

        public File getSourceFile() {
            File artifact = this.art.getFile();
            String version = artifact.getParentFile().getName();
            String artifactId = artifact.getParentFile().getParentFile().getName();
            return new File(artifact.getParentFile(), artifactId + "-" + version + (String)(this.art.getClassifier() != null ? ("tests".equals(this.art.getClassifier()) ? "-test" : "-" + this.art.getClassifier()) : "") + "-sources.jar");
        }

        public boolean hasSourceInRepository() {
            return this.sourceExists.get() && !"system".equals(this.art.getScope());
        }

        MavenProject getMavenProject() {
            return ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        }

        public boolean isTransitive() {
            List trail = this.art.getDependencyTrail();
            return trail != null && trail.size() > 2;
        }

        boolean canAddToModuleInfo() {
            return this.canAddToModuleInfo.get();
        }

        public boolean isManaged() {
            DependencyManagement dm = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getDependencyManagement();
            if (dm != null) {
                List dmList = dm.getDependencies();
                for (org.apache.maven.model.Dependency d : dmList) {
                    if (!this.art.getGroupId().equals(d.getGroupId()) || !this.art.getArtifactId().equals(d.getArtifactId())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isAddedToCP() {
            return this.art.getArtifactHandler().isAddedToClasspath();
        }

        private boolean isDependencyProjectAvailable() {
            return this.getDependencyProject() != null;
        }

        private Project getDependencyProject() {
            if ("system".equals(this.art.getScope())) {
                return null;
            }
            URI uri = org.openide.util.Utilities.toURI((File)this.art.getFile());
            return FileOwnerQuery.getOwner((URI)uri);
        }

        private void setNode(DependencyNode aThis) {
            this.node = aThis;
        }

        public DependencyNode getNode() {
            return this.node;
        }
    }

    private static class ArtifactSourceGroup
    implements SourceGroup {
        private final Artifact art;

        public ArtifactSourceGroup(Artifact art) {
            this.art = art;
        }

        public FileObject getRootFolder() {
            FileObject fo = FileUtil.toFileObject((File)this.art.getFile());
            if (fo != null) {
                return FileUtil.getArchiveRoot((FileObject)fo);
            }
            return null;
        }

        public String getName() {
            return this.art.getId();
        }

        public String getDisplayName() {
            return this.art.getId();
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(Bundle.BTN_Open_Project()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HashSet<Project> projects = new HashSet<Project>();
                    for (Artifact art : context.lookupAll(Artifact.class)) {
                        Project p;
                        File f = art.getFile();
                        if (f == null || (p = FileOwnerQuery.getOwner((URI)org.openide.util.Utilities.toURI((File)f))) == null) continue;
                        projects.add(p);
                    }
                    OpenProjects.getDefault().open((Project[])projects.toArray(new NbMavenProjectImpl[0]), false, true);
                }
            };
        }
    }

    private class InstallLocalArtifactAction
    extends AbstractAction {
        public InstallLocalArtifactAction() {
            this.putValue("Name", Bundle.BTN_Manually_install());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File fil = InstallPanel.showInstallDialog(DependencyNode.this.data.art);
            if (fil != null) {
                InstallPanel.runInstallGoal((NbMavenProjectImpl)DependencyNode.this.data.project.getLookup().lookup(NbMavenProjectImpl.class), fil, DependencyNode.this.data.art);
            }
        }
    }

    private class CopyLocationAction
    extends AbstractAction {
        CopyLocationAction() {
            super(Bundle.CopyLocationAction_name());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(DependencyNode.this.data.art.getFile().getAbsolutePath()), null);
        }
    }

    private class InstallLocalJavadocAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalJavadocAction() {
            this.putValue("Name", Bundle.BTN_Add_javadoc());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.source = InstallDocSourcePanel.showInstallDialog(true);
            if (this.source != null) {
                RP.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            File target = DependencyNode.this.data.getJavadocFile();
            try {
                FileUtils.copyFile((File)this.source, (File)target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                target.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class InstallLocalSourcesAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalSourcesAction() {
            this.putValue("Name", Bundle.BTN_Add_sources());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.source = InstallDocSourcePanel.showInstallDialog(false);
            if (this.source != null) {
                RP.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            File target = DependencyNode.this.data.getSourceFile();
            try {
                FileUtils.copyFile((File)this.source, (File)target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                target.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class ExcludeTransitiveAction
    extends AbstractAction {
        public ExcludeTransitiveAction() {
            this.putValue("Name", Bundle.BTN_Exclude_Dependency());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            RP.post(new Runnable(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    void var4_9;
                    org.apache.maven.shared.dependency.tree.DependencyNode rootnode = DependencyTreeFactory.createDependencyTree((MavenProject)DependencyNode.this.data.getMavenProject(), (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (String)"test");
                    DependencyExcludeNodeVisitor nv = new DependencyExcludeNodeVisitor(DependencyNode.this.data.art.getGroupId(), DependencyNode.this.data.art.getArtifactId(), DependencyNode.this.data.art.getType());
                    rootnode.accept((DependencyNodeVisitor)nv);
                    Set<org.apache.maven.shared.dependency.tree.DependencyNode> nds = nv.getDirectDependencies();
                    if (nds.size() > 1) {
                        ExcludeDependencyPanel pnl = new ExcludeDependencyPanel(DependencyNode.this.data.getMavenProject(), DependencyNode.this.data.art, nds, rootnode);
                        DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Exclude());
                        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (ret != DialogDescriptor.OK_OPTION) return;
                        Collection collection = pnl.getDependencyExcludes().get(DependencyNode.this.data.art);
                    } else {
                        Set<org.apache.maven.shared.dependency.tree.DependencyNode> set = nds;
                    }
                    ExcludeTransitiveAction.this.runModifyExclusions(DependencyNode.this.data.art, (Collection<org.apache.maven.shared.dependency.tree.DependencyNode>)var4_9);
                }
            });
        }

        private void runModifyExclusions(final Artifact art, final Collection<org.apache.maven.shared.dependency.tree.DependencyNode> nds) {
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (org.apache.maven.shared.dependency.tree.DependencyNode nd : nds) {
                        Exclusion ex;
                        Artifact directArt = nd.getArtifact();
                        Dependency dep = model.getProject().findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null);
                        if (dep == null) {
                            org.apache.maven.model.Profile prof2;
                            ArrayList<String> profileNames = new ArrayList<String>();
                            for (org.apache.maven.model.Profile prof2 : DependencyNode.this.data.getMavenProject().getActiveProfiles()) {
                                profileNames.add(prof2.getId());
                            }
                            prof2 = profileNames.iterator();
                            while (prof2.hasNext()) {
                                String profileId = (String)prof2.next();
                                Profile modProf = model.getProject().findProfileById(profileId);
                                if (modProf == null || (dep = modProf.findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dep == null) {
                            List deps = model.getProject().getDependencies();
                            for (Dependency d : deps) {
                                Relocation rel = DependencyNode.this.getRelocation(d);
                                if (rel == null || !rel.getArtifactId().equals(directArt.getArtifactId()) || !rel.getGroupId().equals(directArt.getGroupId()) || !rel.getVersion().equals(directArt.getVersion())) continue;
                                dep = d;
                                break;
                            }
                        }
                        if (dep == null) {
                            dep = model.getFactory().createDependency();
                            dep.setGroupId(directArt.getGroupId());
                            dep.setArtifactId(directArt.getArtifactId());
                            dep.setVersion(directArt.getVersion());
                            if (!"jar".equals(directArt.getType())) {
                                dep.setType(directArt.getType());
                            }
                            model.getProject().addDependency(dep);
                        }
                        if ((ex = dep.findExclusionById(art.getGroupId(), art.getArtifactId())) != null) continue;
                        Exclusion exclude = model.getFactory().createExclusion();
                        exclude.setGroupId(art.getGroupId());
                        exclude.setArtifactId(art.getArtifactId());
                        dep.addExclusion(exclude);
                    }
                }
            };
            FileObject fo = FileUtil.toFileObject((File)((NbMavenProjectImpl)DependencyNode.this.data.project.getLookup().lookup(NbMavenProjectImpl.class)).getPOMFile());
            Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
        }
    }

    private static class SetInCurrentAction
    extends AbstractAction
    implements ContextAwareAction {
        private final Lookup lkp;

        SetInCurrentAction(Lookup lookup) {
            this.putValue("Name", Bundle.BTN_Set_Dependency());
            this.lkp = lookup;
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                this.setEnabled(false);
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new SetInCurrentAction(actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            final Collection artifacts = this.lkp.lookupAll(Artifact.class);
            if (artifacts.isEmpty()) {
                return;
            }
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                return;
            }
            final NbMavenProjectImpl project = (NbMavenProjectImpl)prjs.iterator().next();
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (Artifact art : artifacts) {
                        Dependency dep = model.getProject().findDependencyById(art.getGroupId(), art.getArtifactId(), null);
                        if (dep == null) {
                            ArrayList<String> profileNames = new ArrayList<String>();
                            for (org.apache.maven.model.Profile prof : project.getOriginalMavenProject().getActiveProfiles()) {
                                profileNames.add(prof.getId());
                            }
                            for (String profileId : profileNames) {
                                Profile modProf = model.getProject().findProfileById(profileId);
                                if (modProf == null || (dep = modProf.findDependencyById(art.getGroupId(), art.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dep != null) continue;
                        dep = model.getFactory().createDependency();
                        dep.setGroupId(art.getGroupId());
                        dep.setArtifactId(art.getArtifactId());
                        dep.setVersion(art.getVersion());
                        if (!"jar".equals(art.getType())) {
                            dep.setType(art.getType());
                        }
                        if (!"compile".equals(art.getScope())) {
                            dep.setScope(art.getScope());
                        }
                        if (art.getClassifier() != null) {
                            dep.setClassifier(art.getClassifier());
                        }
                        model.getProject().addDependency(dep);
                    }
                }
            };
            RP.post(new Runnable(){
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$operation = modelOperation;
                }

                @Override
                public void run() {
                    FileObject fo = FileUtil.toFileObject((File)project.getPOMFile());
                    Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(this.val$operation));
                }
            });
        }
    }

    private static class RemoveDependencyAction
    extends AbstractAction
    implements ContextAwareAction {
        private final Lookup lkp;

        RemoveDependencyAction(Lookup look) {
            this.putValue("Name", Bundle.BTN_Remove_Dependency());
            this.lkp = look;
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                this.setEnabled(false);
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new RemoveDependencyAction(actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            final Collection artifacts = this.lkp.lookupAll(Artifact.class);
            if (artifacts.isEmpty()) {
                return;
            }
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                return;
            }
            final NbMavenProjectImpl project = (NbMavenProjectImpl)prjs.iterator().next();
            final ArrayList unremoved = new ArrayList();
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (Artifact art : artifacts) {
                        Dependency dep = model.getProject().findDependencyById(art.getGroupId(), art.getArtifactId(), null);
                        if (dep != null) {
                            model.getProject().removeDependency(dep);
                            continue;
                        }
                        unremoved.add(art);
                    }
                }
            };
            RP.post(new Runnable(){
                final /* synthetic */ ModelOperation val$operation;
                final /* synthetic */ List val$unremoved;
                {
                    this.val$operation = modelOperation;
                    this.val$unremoved = list;
                }

                @Override
                public void run() {
                    FileObject fo = FileUtil.toFileObject((File)project.getPOMFile());
                    Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(this.val$operation));
                    if (this.val$unremoved.size() > 0) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyNode.class, (String)"MSG_Located_In_Parent", (Object)this.val$unremoved.size()), Integer.MAX_VALUE);
                    }
                }
            });
        }
    }

    private static class AddToModuleInfoAction
    extends AbstractAction
    implements ContextAwareAction {
        private final Lookup lkp;

        AddToModuleInfoAction(Lookup lookup) {
            this.putValue("Name", Bundle.BTN_AddToModuleInfo());
            this.lkp = lookup;
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                this.setEnabled(false);
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new AddToModuleInfoAction(actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Collection artifacts = this.lkp.lookupAll(Artifact.class);
            if (artifacts.isEmpty()) {
                return;
            }
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                return;
            }
            ModuleInfoSupport.addRequires(((NbMavenProjectImpl)prjs.iterator().next()).getOriginalMavenProject(), (Collection<? extends Artifact>)artifacts);
        }
    }

    private static class DownloadJavadocSrcAction
    extends AbstractAction
    implements ContextAwareAction {
        private final boolean javadoc;
        private final Lookup actionContext;

        public DownloadJavadocSrcAction(boolean javadoc) {
            this(javadoc, Lookup.EMPTY);
        }

        private DownloadJavadocSrcAction(boolean javadoc, Lookup actionContext) {
            this.putValue("Name", javadoc ? Bundle.LBL_Download_Javadoc() : Bundle.LBL_Download__Sources());
            this.javadoc = javadoc;
            this.actionContext = actionContext;
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new DownloadJavadocSrcAction(this.javadoc, actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            if (this.actionContext == null) {
                return;
            }
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressContributor contributor = BasicAggregateProgressFactory.createProgressContributor((String)"multi-1");
                    String label = javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                    AggregateProgressHandle handle = BasicAggregateProgressFactory.createHandle((String)label, (ProgressContributor[])new ProgressContributor[]{contributor}, (Cancellable)ProgressTransferListener.cancellable(), null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        for (Data data : actionContext.lookupAll(Data.class)) {
                            ProgressContributor contributor2 = BasicAggregateProgressFactory.createProgressContributor((String)"multi-1");
                            handle.addContributor(contributor2);
                            if (javadoc && !data.hasJavadocInRepository()) {
                                data.getNode().downloadJavadocSources(contributor2, javadoc);
                                continue;
                            }
                            if (!javadoc && !data.hasSourceInRepository()) {
                                data.getNode().downloadJavadocSources(contributor2, javadoc);
                                continue;
                            }
                            contributor2.finish();
                        }
                    }
                    catch (ThreadDeath threadDeath) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private static class JarFilterNode
    extends FilterNode {
        JarFilterNode(Node original) {
            super(original, (Children)(FilterNode.Children.LEAF == original.getChildren() ? FilterNode.Children.LEAF : new JarContentFilterChildren(original)));
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> result = new ArrayList<Action>();
            result.addAll(Arrays.asList(super.getActions(false)));
            result.add(new OpenJavadocAction());
            return result.toArray(new Action[0]);
        }

        private class OpenJavadocAction
        extends AbstractAction {
            private OpenJavadocAction() {
                this.putValue("Name", Bundle.BTN_View_Javadoc());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                URL javadocUrl;
                DataObject dobj = (DataObject)JarFilterNode.this.getOriginal().getLookup().lookup(DataObject.class);
                if (dobj == null) {
                    return;
                }
                FileObject fil = dobj.getPrimaryFile();
                FileObject jar = FileUtil.getArchiveFile((FileObject)fil);
                FileObject root = FileUtil.getArchiveRoot((FileObject)jar);
                Object rel = FileUtil.getRelativePath((FileObject)root, (FileObject)fil);
                rel = ((String)rel).replaceAll("[.]class$", ".html");
                JavadocForBinaryQuery.Result res = JavadocForBinaryQuery.findJavadoc((URL)root.toURL());
                if (fil.isFolder()) {
                    rel = (String)rel + "/package-summary.html";
                }
                if ((javadocUrl = this.findJavadoc((String)rel, res.getRoots())) != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(javadocUrl);
                } else {
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERR_No_Javadoc_Found(fil.getPath()));
                }
            }

            URL findJavadoc(String resource, URL[] urls) {
                for (int i = 0; i < urls.length; ++i) {
                    Object base = urls[i].toExternalForm();
                    if (!((String)base).endsWith("/")) {
                        base = (String)base + "/";
                    }
                    try {
                        URL u = new URL((String)base + resource);
                        FileObject fo = URLMapper.findFileObject((URL)u);
                        if (fo == null) continue;
                        return u;
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }

    static class ShowManagedStateAction
    extends AbstractAction
    implements Presenter.Popup {
        ShowManagedStateAction() {
            String s = Bundle.LBL_ShowManagedState();
            this.putValue("Name", s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependenciesNode.prefs().putBoolean(DependencyNode.SHOW_MANAGED_DEPENDENCIES, !DependencyNode.showManagedState());
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this);
            mi.setSelected(DependencyNode.showManagedState());
            return mi;
        }
    }
}

