/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.codehaus.plexus.util.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ExecMojo
extends ExecutionEventObject {
    public final String goal;
    public final ExecutionEventObject.GAV plugin;
    public final String phase;
    public final String executionId;
    private String errorMessage;
    private InputLocation location;
    private URL[] classpathURLs;
    private String implementationClass;
    private File currentProjectLocation;

    public ExecMojo(String goal, ExecutionEventObject.GAV plugin, String phase, String executionId, ExecutionEvent.Type type) {
        super(type);
        this.goal = goal;
        this.plugin = plugin;
        this.phase = phase;
        this.executionId = executionId;
    }

    public static ExecMojo create(JSONObject obj, ExecutionEvent.Type t) {
        JSONArray urls;
        String file;
        JSONObject loc;
        String message;
        JSONObject mojo = (JSONObject)obj.get((Object)"mojo");
        String id = (String)mojo.get((Object)"id");
        String[] ids = id.split(":");
        ExecutionEventObject.GAV mojoGav = new ExecutionEventObject.GAV(ids[0], ids[1], ids[2]);
        String goal = (String)mojo.get((Object)"goal");
        String execId = (String)mojo.get((Object)"execId");
        String phase = (String)mojo.get((Object)"phase");
        ExecMojo toRet = new ExecMojo(goal, mojoGav, phase, execId, t);
        JSONObject exc = (JSONObject)obj.get((Object)"exc");
        if (exc != null && (message = (String)exc.get((Object)"msg")) != null) {
            byte[] bytes = Base64.decodeBase64((byte[])message.getBytes(StandardCharsets.UTF_8));
            toRet.setErrorMessage(new String(bytes, StandardCharsets.UTF_8));
        }
        if ((loc = (JSONObject)mojo.get((Object)"loc")) != null) {
            Long lineNumber = (Long)loc.get((Object)"ln");
            Long columnNumber = (Long)loc.get((Object)"col");
            file = (String)loc.get((Object)"loc");
            String modelid = (String)loc.get((Object)"id");
            InputSource is = new InputSource();
            is.setLocation(file);
            is.setModelId(modelid);
            InputLocation location = new InputLocation(lineNumber.intValue(), columnNumber.intValue(), is);
            toRet.setLocation(location);
        }
        if ((urls = (JSONArray)mojo.get((Object)"urls")) != null) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (String url : urls) {
                try {
                    urlList.add(new URL(url));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            toRet.setClasspathURLs(urlList.toArray(new URL[0]));
        }
        toRet.setImplementationClass((String)mojo.get((Object)"impl"));
        File prjFile = null;
        file = (String)mojo.get((Object)"prjFile");
        if (file != null) {
            prjFile = FileUtil.normalizeFile((File)new File(file));
        }
        toRet.setCurrentProjectLocation(prjFile);
        return toRet;
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public InputLocation getLocation() {
        return this.location;
    }

    private void setLocation(InputLocation location) {
        this.location = location;
    }

    public URL[] getClasspathURLs() {
        return this.classpathURLs;
    }

    public void setClasspathURLs(URL[] classpathURLs) {
        this.classpathURLs = classpathURLs;
    }

    public URL getPluginJarURL() {
        if (this.classpathURLs != null) {
            String name = "/" + this.plugin.artifactId + "-" + this.plugin.version + ".jar";
            for (URL url : this.classpathURLs) {
                if (!url.toExternalForm().endsWith(name)) continue;
                return url;
            }
        }
        return null;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    @CheckForNull
    public Project findProject() {
        FileObject fo;
        if (this.currentProjectLocation != null && (fo = FileUtil.toFileObject((File)this.currentProjectLocation)) != null) {
            try {
                return ProjectManager.getDefault().findProject(fo);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    void setCurrentProjectLocation(File currentProjectLocation) {
        this.currentProjectLocation = currentProjectLocation;
    }
}

