/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.io.File;
import org.codehaus.plexus.util.DirectoryScanner;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.spi.cos.CompileOnSaveSkipper;

public class MainClassesCoSSkipper
implements CompileOnSaveSkipper {
    @Override
    public boolean skip(RunConfig config, boolean includingTests, long timeStamp) {
        if (includingTests && !RunUtils.hasApplicationCompileOnSaveEnabled(config) && RunUtils.hasTestCompileOnSaveEnabled(config)) {
            String[] inclds;
            File dirFile = FileUtilities.convertStringToFile(config.getMavenProject().getBuild().getSourceDirectory());
            if (dirFile == null || !dirFile.exists()) {
                return false;
            }
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(dirFile);
            ds.setIncludes(new String[]{"**/*.java"});
            ds.addDefaultExcludes();
            ds.scan();
            for (String inc : inclds = ds.getIncludedFiles()) {
                File f = new File(dirFile, inc);
                if (f.lastModified() < timeStamp) continue;
                return true;
            }
        }
        return false;
    }
}

